/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRStore;

public abstract class AbstractNumericStore
extends AbstractRStore<Double>
implements RNumericStore {
    protected static final String toChar(double num) {
        if (num == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (num == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        return Double.toString(num);
    }

    @Override
    public final byte getStoreType() {
        return 3;
    }

    @Override
    public final String getBaseVectorRClassName() {
        return "numeric";
    }

    @Override
    public boolean getLogi(int idx) {
        return this.getNum(idx) != 0.0;
    }

    @Override
    public final boolean getLogi(long idx) {
        return this.getNum(idx) != 0.0;
    }

    @Override
    public final void setLogi(int idx, boolean logi) {
        this.setNum(idx, logi ? 1.0 : 0.0);
    }

    @Override
    public final void setLogi(long idx, boolean logi) {
        this.setNum(idx, logi ? 1.0 : 0.0);
    }

    @Override
    public final int getInt(int idx) {
        return (int)this.getNum(idx);
    }

    @Override
    public final int getInt(long idx) {
        return (int)this.getNum(idx);
    }

    @Override
    public final void setInt(int idx, int integer) {
        this.setNum(idx, (double)integer);
    }

    @Override
    public final void setInt(long idx, int integer) {
        this.setNum(idx, (double)integer);
    }

    @Override
    public final double getCplxRe(int idx) {
        return this.getNum(idx);
    }

    @Override
    public final double getCplxRe(long idx) {
        return this.getNum(idx);
    }

    @Override
    public final double getCplxIm(int idx) {
        return 0.0;
    }

    @Override
    public final double getCplxIm(long idx) {
        return 0.0;
    }

    @Override
    public final String getChar(int idx) {
        return AbstractNumericStore.toChar(this.getNum(idx));
    }

    @Override
    public String getChar(long idx) {
        return AbstractNumericStore.toChar(this.getNum(idx));
    }

    @Override
    public abstract Double[] toArray();

    @Override
    public boolean allEqual(RStore<?> other) {
        long length = this.getLength();
        if (3 != other.getStoreType() || length != other.getLength()) {
            return false;
        }
        if (length < 0L) {
            return true;
        }
        if (length <= Integer.MAX_VALUE) {
            int ilength = (int)length;
            int idx = 0;
            while (idx < ilength) {
                if (this.isMissing(idx) ? (this.isNA(idx) ? !other.isNA(idx) : !other.isMissing(idx)) : !(Math.abs(this.getNum(idx) - other.getNum(idx)) < 2.220446E-16)) {
                    return false;
                }
                ++idx;
            }
        } else {
            long idx = 0L;
            while (idx < length) {
                if (this.isMissing(idx) ? (this.isNA(idx) ? !other.isNA(idx) : !other.isMissing(idx)) : !(Math.abs(this.getNum(idx) - other.getNum(idx)) < 2.220446E-16)) {
                    return false;
                }
                ++idx;
            }
        }
        return true;
    }
}

