/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers;

import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.jcommons.collections.CopyOnWriteList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class AbstractPostSelectionProvider
implements IPostSelectionProvider {
    private final CopyOnWriteList<ISelectionChangedListener> selectionListeners = new CopyOnWriteList();
    private final CopyOnWriteList<ISelectionChangedListener> postSelectionListeners = new CopyOnWriteList();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        ImList listeners = this.selectionListeners.toList();
        for (ISelectionChangedListener listener : listeners) {
            SafeRunnable.run(() -> listener.selectionChanged(event));
        }
    }

    protected void firePostSelectionChanged(SelectionChangedEvent event) {
        ImList listeners = this.postSelectionListeners.toList();
        for (ISelectionChangedListener listener : listeners) {
            SafeRunnable.run(() -> listener.selectionChanged(event));
        }
    }
}

