/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Position;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.ui.refactoring.Messages;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.ScheduledRefactoring;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressService;

public class RefactoringExecutionHelper {
    private final Refactoring refactoring;
    private final IProgressService execContext;
    private final Shell parent;
    private final int stopSeverity;
    private SourceUnit insertPositionSourceUnit;
    private Position insertPosition;

    public RefactoringExecutionHelper(Refactoring refactoring, int stopSeverity, Shell parent, IProgressService context) {
        assert (refactoring != null);
        assert (parent != null);
        assert (context != null);
        this.refactoring = refactoring;
        this.stopSeverity = stopSeverity;
        this.parent = parent;
        this.execContext = context;
    }

    public void perform(final boolean forkChangeExecution, final boolean cancelable) throws InterruptedException, InvocationTargetException {
        final AtomicReference op = new AtomicReference();
        try {
            this.execContext.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringExecutionHelper.this.refactoring.getName(), (int)10);
                    final IJobManager manager = Job.getJobManager();
                    Thread workingThread = Thread.currentThread();
                    IWorkspaceRoot rule = RefactoringExecutionHelper.this.refactoring instanceof ScheduledRefactoring ? ((ScheduledRefactoring)RefactoringExecutionHelper.this.refactoring).getSchedulingRule() : ResourcesPlugin.getWorkspace().getRoot();
                    manager.beginRule((ISchedulingRule)rule, (IProgressMonitor)m.newChild(1));
                    PerformChangeOperation operation = null;
                    try {
                        if (cancelable && monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        RefactoringExecutionHelper.this.refactoring.setValidationContext((Object)RefactoringExecutionHelper.this.parent);
                        final RefactoringStatus status = RefactoringExecutionHelper.this.refactoring.checkAllConditions((IProgressMonitor)m.newChild(1, 0));
                        if (status.getSeverity() >= RefactoringExecutionHelper.this.stopSeverity) {
                            final AtomicBoolean canceled = new AtomicBoolean();
                            RefactoringExecutionHelper.this.parent.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)(this).RefactoringExecutionHelper.this.parent, (String)(this).RefactoringExecutionHelper.this.refactoring.getName(), (boolean)false);
                                    int selection = dialog.open();
                                    canceled.set(selection == 1);
                                }
                            });
                            if (canceled.get()) {
                                throw new OperationCanceledException();
                            }
                        }
                        Change change = RefactoringExecutionHelper.this.refactoring.createChange((IProgressMonitor)m.newChild(2, 0));
                        change.initializeValidationData((IProgressMonitor)m.newChild(1, 0));
                        SourceUnitChange insertTracker = RefactoringExecutionHelper.this.insertPositionSourceUnit != null ? RefactoringExecutionHelper.this.search(change) : null;
                        operation = new PerformChangeOperation(change);
                        operation.setUndoManager(RefactoringCore.getUndoManager(), RefactoringExecutionHelper.this.refactoring.getName());
                        operation.setSchedulingRule((ISchedulingRule)rule);
                        if (cancelable && monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        op.set(operation);
                        if (forkChangeExecution) {
                            operation.run((IProgressMonitor)m.newChild(4, 0));
                        } else {
                            AtomicReference opException = new AtomicReference();
                            Runnable runnable = new Runnable((ISchedulingRule)rule, workingThread, op, m, opException){
                                private final /* synthetic */ ISchedulingRule val$rule;
                                private final /* synthetic */ Thread val$workingThread;
                                private final /* synthetic */ AtomicReference val$op;
                                private final /* synthetic */ SubMonitor val$m;
                                private final /* synthetic */ AtomicReference val$opException;
                                {
                                    this.val$rule = iSchedulingRule;
                                    this.val$workingThread = thread;
                                    this.val$op = atomicReference;
                                    this.val$m = subMonitor;
                                    this.val$opException = atomicReference2;
                                }

                                @Override
                                public void run() {
                                    try {
                                        try {
                                            PerformChangeOperation operation = (PerformChangeOperation)this.val$op.get();
                                            operation.run((IProgressMonitor)this.val$m.newChild(4, 0));
                                        }
                                        catch (CoreException e) {
                                            this.val$opException.set(e);
                                            manager.transferRule(this.val$rule, this.val$workingThread);
                                        }
                                        catch (RuntimeException e) {
                                            this.val$opException.set(e);
                                            manager.transferRule(this.val$rule, this.val$workingThread);
                                        }
                                    }
                                    finally {
                                        manager.transferRule(this.val$rule, this.val$workingThread);
                                    }
                                }
                            };
                            Display display = RefactoringExecutionHelper.this.parent.getDisplay();
                            manager.transferRule((ISchedulingRule)rule, display.getThread());
                            display.syncExec(runnable);
                            if (opException.get() != null) {
                                Exception e = (Exception)opException.get();
                                if (e instanceof CoreException) {
                                    throw (CoreException)((Object)e);
                                }
                                if (e instanceof RuntimeException) {
                                    throw (RuntimeException)e;
                                }
                            }
                        }
                        RefactoringStatus validationStatus = operation.getValidationStatus();
                        if (validationStatus != null && validationStatus.hasFatalError()) {
                            MessageDialog.openError((Shell)RefactoringExecutionHelper.this.parent, (String)RefactoringExecutionHelper.this.refactoring.getName(), (String)NLS.bind((String)Messages.ExecutionHelper_CannotExecute_message, (Object)validationStatus.getMessageMatchingSeverity(4)));
                            return;
                        }
                        try {
                            if (insertTracker != null) {
                                RefactoringExecutionHelper.this.insertPosition = insertTracker.getInsertPosition();
                            }
                        }
                        catch (OperationCanceledException e) {
                            throw new InterruptedException(e.getMessage());
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (RuntimeException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        manager.endRule((ISchedulingRule)rule);
                        RefactoringExecutionHelper.this.refactoring.setValidationContext(null);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PerformChangeOperation operation = (PerformChangeOperation)op.get();
            if (operation != null && operation.changeExecutionFailed()) {
                ChangeExceptionHandler handler = new ChangeExceptionHandler(this.parent, this.refactoring);
                Throwable inner = e.getTargetException();
                if (inner instanceof RuntimeException) {
                    handler.handle(operation.getChange(), (RuntimeException)inner);
                }
                if (inner instanceof CoreException) {
                    handler.handle(operation.getChange(), (CoreException)inner);
                }
                throw e;
            }
            throw e;
        }
    }

    public void enableInsertPosition(SourceUnit su) {
        this.insertPositionSourceUnit = su;
    }

    public Position getInsertPosition() {
        return this.insertPosition;
    }

    private SourceUnitChange search(Change change) {
        if (change instanceof SourceUnitChange && ((SourceUnitChange)change).getSourceUnit() == this.insertPositionSourceUnit) {
            return (SourceUnitChange)change;
        }
        if (change instanceof CompositeChange) {
            Change[] children = ((CompositeChange)change).getChildren();
            int i = 0;
            while (i < children.length) {
                SourceUnitChange child = this.search(children[i]);
                if (child != null) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }
}

