/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.io.IOException;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartitioner;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;

public final class NIConsoleOutputStream {
    public static final String INFO_STREAM_ID = "org.eclipse.statet.nico.ui.InfoStream";
    public static final String STD_INPUT_STREAM_ID = "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM";
    public static final String STD_OUTPUT_STREAM_ID = "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM";
    public static final String STD_ERROR_STREAM_ID = "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM";
    public static final String SYSTEM_OUTPUT_STREAM_ID = "org.eclipse.statet.nico.ui.SystemOutputStream";
    public static final String OTHER_TASKS_STREAM_SUFFIX = "-OtherTasks";
    public static final String OTHER_TASKS_INFO_STREAM_ID = "org.eclipse.statet.nico.ui.InfoStream-OtherTasks";
    public static final String OTHER_TASKS_STD_INPUT_STREAM_ID = "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks";
    public static final String OTHER_TASKS_STD_OUTPUT_STREAM_ID = "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM-OtherTasks";
    public static final String OTHER_TASKS_STD_ERROR_STREAM_ID = "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks";
    private final NIConsole console;
    private NIConsolePartitioner partitioner;
    private final String id;
    private boolean closed = false;
    private Color color;
    private Color backgroundColor;
    private int fontStyle;
    private boolean prependCR;

    NIConsoleOutputStream(NIConsole console, String streamId) {
        this.console = console;
        this.partitioner = console.getPartitioner();
        this.id = streamId;
    }

    public String getId() {
        return this.id;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int newFontStyle) {
        if (newFontStyle != this.fontStyle) {
            int old = this.fontStyle;
            this.fontStyle = newFontStyle;
            this.console.firePropertyChange(this, IConsoleConstants.P_FONT_STYLE, new Integer(old), new Integer(this.fontStyle));
        }
    }

    public void setColor(Color newColor) {
        Color old = this.color;
        if (old == null || !old.equals((Object)newColor)) {
            this.color = newColor;
            this.console.firePropertyChange(this, IConsoleConstants.P_STREAM_COLOR, old, newColor);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setBackgroundColor(Color newColor) {
        Color old = this.color;
        if (old == null || !old.equals((Object)newColor)) {
            this.backgroundColor = newColor;
            this.console.firePropertyChange(this, IConsoleConstants.P_STREAM_COLOR, old, newColor);
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    synchronized void close() {
        if (this.prependCR) {
            this.prependCR = false;
            try {
                this.notifyParitioner("\r");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.closed = true;
        this.partitioner = null;
    }

    public synchronized void write(String text) throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        if (this.prependCR) {
            text = "\r" + text;
            this.prependCR = false;
        }
        if (text.endsWith("\r")) {
            this.prependCR = true;
            text = text.substring(0, text.length() - 1);
        }
        this.notifyParitioner(text);
    }

    private void notifyParitioner(String encodedString) throws IOException {
        this.partitioner.streamAppended(this, encodedString);
        ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange((IConsole)this.console);
    }
}

