/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RVectorDataAdapter;
import org.eclipse.statet.rj.ts.core.RToolService;

public class RVectorDataProvider
extends AbstractRDataProvider<RVector<?>> {
    public RVectorDataProvider(RDataTableInput input, RVector<?> struct) throws CoreException {
        super(input, new RVectorDataAdapter(), struct);
        this.reset();
    }

    @Override
    protected RDataTableContentDescription loadDescription(RElementName name, RVector<?> struct, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RDataTableContentDescription description = new RDataTableContentDescription(name, (RObject)struct, r.getTool());
        description.setRowHeaderColumns(this.createNamesColumn("names(" + this.getInput().getFullName() + ")", this.getAdapter().getRowCount(struct), r, m));
        RDataTableColumn dataColumn = this.createColumn(struct.getData(), this.getInput().getFullName(), BASE_NAME, 0L, this.getInput().getName(), r, m);
        description.setDataColumns(dataColumn);
        description.setVariables(dataColumn);
        description.setDefaultDataFormat(dataColumn.getDefaultFormat());
        return description;
    }

    @Override
    protected void appendOrderCmd(StringBuilder cmd, AbstractRDataProvider.SortColumn sortColumn) {
        cmd.append("order(");
        cmd.append(this.getInput().getFullName());
        cmd.append(",decreasing=");
        cmd.append(sortColumn.decreasing ? "TRUE" : "FALSE");
        cmd.append(')');
    }

    @Override
    protected Object getDataValue(LazyRStore.Fragment<RVector<?>> fragment, long rowIdx, long columnIdx) {
        return ((RVector)fragment.getRObject()).getData().get(fragment.toLocalRowIdx(rowIdx));
    }

    @Override
    public boolean hasRealColumns() {
        return false;
    }

    @Override
    public IDataProvider createColumnDataProvider() {
        return new AbstractRDataProvider.ColumnDataProvider(this){

            @Override
            public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
                return RVectorDataProvider.this.getInput().getName();
            }
        };
    }

    @Override
    protected Object getColumnName(LazyRStore.Fragment<RVector<?>> fragment, long columnIdx) {
        throw new UnsupportedOperationException();
    }
}

