/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import java.util.Objects;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.statet.internal.r.ui.datafilter.FilterListener;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public abstract class VariableFilter {
    protected static final RCharacter32Store NO_VALUES = new RCharacter32Store();
    private final FilterSet filterSet;
    private final RDataTableColumn column;
    private @Nullable FilterListener listener;
    private @Nullable String errorMessage;
    volatile boolean updateScheduled;
    private @Nullable String filterRExpression;
    private final BindingListener valueListener = new BindingListener();

    protected VariableFilter(FilterSet set, RDataTableColumn column) {
        this.filterSet = set;
        this.column = column;
    }

    public abstract FilterType getType();

    public FilterSet getSet() {
        return this.filterSet;
    }

    public RDataTableColumn getColumn() {
        return this.column;
    }

    public void load(VariableFilter filter) {
    }

    public void reset() {
    }

    protected void scheduleUpdate() {
        this.updateScheduled = true;
        this.filterSet.scheduleUpdate(false);
    }

    protected void registerObservable(IObservable observable) {
        if (observable instanceof IObservableValue) {
            ((IObservableValue)observable).addValueChangeListener((IValueChangeListener)this.valueListener);
        }
        if (observable instanceof IObservableSet) {
            ((IObservableSet)observable).addSetChangeListener((ISetChangeListener)this.valueListener);
        }
    }

    protected void updateFilter(int flag) {
        String rExpression = this.createFilter(this.getColumn().getRExpression());
        if (rExpression != null && rExpression.isEmpty()) {
            rExpression = null;
        }
        if (Objects.equals(this.filterRExpression, rExpression)) {
            return;
        }
        this.filterRExpression = rExpression;
        this.filterSet.updateFilter((flag & 1) == 1);
    }

    protected abstract @Nullable String createFilter(String var1);

    protected void runInRealm(Runnable runnable) {
        this.filterSet.runInRealm(runnable);
    }

    public void setListener(FilterListener listener) {
        this.listener = listener;
    }

    protected abstract void update(RToolService var1, ProgressMonitor var2) throws StatusException, UnexpectedRDataException;

    protected void notifyListeners() {
        FilterListener listener = this.listener;
        if (listener != null) {
            listener.filterChanged();
        }
    }

    protected abstract void setError(String var1);

    protected final void doSetError(String message) {
        this.errorMessage = message;
    }

    protected final void clearError() {
        this.errorMessage = null;
    }

    public @Nullable String getError() {
        return this.errorMessage;
    }

    public @Nullable String getFilterRExpression() {
        return this.filterRExpression;
    }

    public @Nullable String getFilterRExpression(String mainExpression, int nameFlags) {
        String varExpression = String.valueOf(mainExpression) + this.getColumn().getElementName().getDisplayName(nameFlags).substring(1);
        return this.createFilter(varExpression);
    }

    private class BindingListener
    implements IValueChangeListener<Object>,
    ISetChangeListener<Object> {
        private BindingListener() {
        }

        public void handleSetChange(SetChangeEvent<?> event) {
            VariableFilter.this.updateFilter(1);
        }

        public void handleValueChange(ValueChangeEvent<?> event) {
            VariableFilter.this.updateFilter(1);
        }
    }
}

