/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.dataeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.config.IConfiguration;
import org.eclipse.statet.ecommons.waltable.config.LayoutSizeConfig;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.copy.CopyToClipboardCommandHandler;
import org.eclipse.statet.ecommons.waltable.data.ControlData;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.ecommons.waltable.data.ISpanningDataProvider;
import org.eclipse.statet.ecommons.waltable.freeze.CompositeFreezeLayer;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.ecommons.waltable.grid.cell.AlternatingRowConfigLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.grid.data.DefaultCornerDataProvider;
import org.eclipse.statet.ecommons.waltable.grid.labeled.ExtColumnHeaderLayer;
import org.eclipse.statet.ecommons.waltable.grid.labeled.ExtGridLayer;
import org.eclipse.statet.ecommons.waltable.grid.labeled.ExtRowHeaderLayer;
import org.eclipse.statet.ecommons.waltable.grid.labeled.LabelCornerLayer;
import org.eclipse.statet.ecommons.waltable.grid.layer.ColumnHeaderLayer;
import org.eclipse.statet.ecommons.waltable.grid.layer.CornerLayer;
import org.eclipse.statet.ecommons.waltable.grid.layer.GridLayer;
import org.eclipse.statet.ecommons.waltable.grid.layer.RowHeaderLayer;
import org.eclipse.statet.ecommons.waltable.layer.DataLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerListener;
import org.eclipse.statet.ecommons.waltable.layer.SpanningDataLayer;
import org.eclipse.statet.ecommons.waltable.layer.cell.AggregrateConfigLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.IVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.RowUpdateEvent;
import org.eclipse.statet.ecommons.waltable.resize.InitializeAutoResizeCommandHandler;
import org.eclipse.statet.ecommons.waltable.selection.ISelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.SelectAllCommand;
import org.eclipse.statet.ecommons.waltable.selection.SelectDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.selection.SelectRelativeCommandHandler;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.sort.ClearSortCommand;
import org.eclipse.statet.ecommons.waltable.sort.ClearSortCommandHandler;
import org.eclipse.statet.ecommons.waltable.sort.ISortModel;
import org.eclipse.statet.ecommons.waltable.sort.SortDimPositionCommand;
import org.eclipse.statet.ecommons.waltable.sort.SortDirection;
import org.eclipse.statet.ecommons.waltable.sort.SortHeaderLayer;
import org.eclipse.statet.ecommons.waltable.sort.SortPositionCommandHandler;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.tickupdate.config.DefaultTickUpdateConfiguration;
import org.eclipse.statet.ecommons.waltable.ui.ITableUIContext;
import org.eclipse.statet.ecommons.waltable.viewport.IViewportDim;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportLayer;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.FTableDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.FindFilter;
import org.eclipse.statet.internal.r.ui.dataeditor.FindListener;
import org.eclipse.statet.internal.r.ui.dataeditor.FindTask;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatter;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatterConverter;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFrameDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.internal.r.ui.dataeditor.RMatrixDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RVectorDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.ResolveCellIndexes;
import org.eclipse.statet.internal.r.ui.intable.PresentationConfig;
import org.eclipse.statet.internal.r.ui.intable.RDataLayer;
import org.eclipse.statet.internal.r.ui.intable.TableLayers;
import org.eclipse.statet.internal.r.ui.intable.UIBindings;
import org.eclipse.statet.jcommons.collections.CopyOnWriteList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.ui.dataeditor.RDataTableCallbacks;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.r.ui.dataeditor.RDataTableListener;
import org.eclipse.statet.r.ui.dataeditor.RDataTableSelection;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class RDataTableComposite
extends Composite
implements ISelectionProvider {
    private final Display display;
    private final StackLayout layout;
    private final Label messageControl;
    private @Nullable Composite reloadControl;
    private final RDataTableCallbacks callbacks;
    private RDataTableInput input;
    private AbstractRDataProvider<?> dataProvider;
    private @Nullable TableLayers tableLayers;
    private boolean tableInitialized;
    private PositionCoordinate currentAnchor;
    private @Nullable PositionCoordinate currentLastSelectedCell;
    private @Nullable RDataTableSelection selection;
    private final Object selectionLock = new Object();
    private boolean selectionUpdateScheduled;
    private long selectionUpdateScheduleStamp;
    private boolean selectionCheckLabel;
    private final Runnable selectionUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            if (RDataTableComposite.this.isDisposed()) {
                return;
            }
            RDataTableComposite.this.updateSelection();
        }
    };
    private final CopyOnWriteList<ISelectionChangedListener> selectionListeners = new CopyOnWriteList();
    private final CopyOnWriteList<FindListener> findListeners = new CopyOnWriteList();
    private final CopyOnWriteList<RDataTableListener> tableListeners = new CopyOnWriteList();
    private final RDataFormatter formatter = new RDataFormatter();
    private @Nullable ResolveCellIndexes setAnchorByData;

    public RDataTableComposite(Composite parent, RDataTableCallbacks callbacks) {
        super(parent, 0);
        if (callbacks == null) {
            throw new NullPointerException("callbacks");
        }
        this.display = this.getDisplay();
        this.callbacks = callbacks;
        this.layout = new StackLayout();
        this.setLayout((Layout)this.layout);
        this.messageControl = new Label((Composite)this, 0);
        this.showDummy("Preparing...");
    }

    protected void initTable(final RDataTableInput input, final AbstractRDataProvider<? extends RObject> dataProvider) {
        GridLayer gridLayer;
        CornerLayer cornerLayer;
        IDataProvider headerDataProvider;
        this.input = input;
        this.dataProvider = dataProvider;
        final PresentationConfig presentation = PresentationConfig.getInstance(this.display);
        final TableLayers layers = new TableLayers();
        layers.dataLayer = new RDataLayer(dataProvider, presentation.getBaseSizeConfig());
        if (!this.dataProvider.getAllColumnsEqual()) {
            AggregrateConfigLabelAccumulator aggregrateConfigLabelAccumulator = new AggregrateConfigLabelAccumulator();
        }
        layers.selectionLayer = new SelectionLayer((ILayer)layers.dataLayer, false);
        layers.selectionLayer.addConfiguration((IConfiguration)new UIBindings.SelectionConfiguration());
        layers.selectionLayer.addConfiguration((IConfiguration)new DefaultTickUpdateConfiguration());
        layers.viewportLayer = new ViewportLayer((ILayer)layers.selectionLayer);
        FreezeLayer freezeLayer = new FreezeLayer((ILayer)layers.selectionLayer);
        CompositeFreezeLayer compositeFreezeLayer = new CompositeFreezeLayer(freezeLayer, layers.viewportLayer, layers.selectionLayer, true);
        layers.topBodyLayer = compositeFreezeLayer;
        IDataProvider headerDataProvider2 = dataProvider.getColumnDataProvider();
        layers.dataColumnHeaderLayer = headerDataProvider2 instanceof ISpanningDataProvider ? new SpanningDataLayer((ISpanningDataProvider)headerDataProvider2, 0x10000000000000L, 10, 0x20000000000000L, 10) : new DataLayer(headerDataProvider2, 0x10000000000000L, 10, 0x20000000000000L, 10);
        ColumnHeaderLayer layer = new ColumnHeaderLayer((ILayer)layers.dataColumnHeaderLayer, layers.topBodyLayer, layers.selectionLayer, false, presentation.getHeaderLayerPainter());
        layer.addConfiguration((IConfiguration)new UIBindings.ColumnHeaderConfiguration());
        layers.topColumnHeaderLayer = layer;
        ISortModel sortModel = dataProvider.getSortModel();
        if (sortModel != null) {
            SortHeaderLayer sortHeaderLayer = new SortHeaderLayer(layers.topColumnHeaderLayer, sortModel, false);
            sortHeaderLayer.addConfiguration((IConfiguration)new UIBindings.SortConfiguration());
            layers.topColumnHeaderLayer = sortHeaderLayer;
        }
        layers.dataRowHeaderLayer = (headerDataProvider = dataProvider.getRowDataProvider()) instanceof ISpanningDataProvider ? new SpanningDataLayer((ISpanningDataProvider)headerDataProvider, 0x20000000000000L, 10, 0x10000000000000L, 10) : new DataLayer(headerDataProvider, 0x20000000000000L, 10, 0x10000000000000L, 10);
        layers.topRowHeaderLayer = new RowHeaderLayer((ILayer)layers.dataRowHeaderLayer, layers.topBodyLayer, layers.selectionLayer, false, presentation.getHeaderLayerPainter());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider(layers.dataColumnHeaderLayer.getDataProvider(), layers.dataRowHeaderLayer.getDataProvider());
        if (dataProvider.getColumnLabelProvider() != null || dataProvider.getRowLabelProvider() != null) {
            layers.topColumnHeaderLayer = new ExtColumnHeaderLayer(layers.topColumnHeaderLayer);
            layers.topRowHeaderLayer = new ExtRowHeaderLayer(layers.topRowHeaderLayer);
            cornerLayer = new LabelCornerLayer((ILayer)new DataLayer((IDataProvider)cornerDataProvider, 0x20000000000000L, 10, 0x20000000000000L, 10), layers.topRowHeaderLayer, layers.topColumnHeaderLayer, dataProvider.getColumnLabelProvider(), dataProvider.getRowLabelProvider(), false, presentation.getHeaderLabelLayerPainter());
            gridLayer = new ExtGridLayer(layers.topBodyLayer, layers.topColumnHeaderLayer, layers.topRowHeaderLayer, (ILayer)cornerLayer, false);
        } else {
            cornerLayer = new CornerLayer((ILayer)new DataLayer((IDataProvider)cornerDataProvider, 0x20000000000000L), layers.topRowHeaderLayer, layers.topColumnHeaderLayer, false, presentation.getHeaderLayerPainter());
            gridLayer = new GridLayer(layers.topBodyLayer, layers.topColumnHeaderLayer, layers.topRowHeaderLayer, (ILayer)cornerLayer, false);
        }
        gridLayer.addConfigLabelAccumulatorForRegion("BODY", (IConfigLabelAccumulator)new AlternatingRowConfigLabelAccumulator());
        Runnable configRunnable = new Runnable(){

            @Override
            public void run() {
                TableLayers layers = RDataTableComposite.this.tableLayers;
                if (layers == null) {
                    return;
                }
                LayoutSizeConfig sizeConfig = presentation.getBaseSizeConfig();
                layers.dataLayer.setSizeConfig(sizeConfig);
                layers.dataColumnHeaderLayer.setDefaultRowHeight(sizeConfig.getRowHeight());
                layers.dataRowHeaderLayer.setDefaultColumnWidth(sizeConfig.getCharWidth() * 8 + sizeConfig.getDefaultSpace() * 2);
                if (layers.topColumnHeaderLayer instanceof ExtColumnHeaderLayer) {
                    ((ExtColumnHeaderLayer)layers.topColumnHeaderLayer).setSpaceSize(sizeConfig.getRowHeight());
                    ((ExtRowHeaderLayer)layers.topRowHeaderLayer).setSpaceSize(sizeConfig.getRowHeight());
                }
                presentation.configureRegistry(layers.table.getConfigRegistry());
                layers.table.updateResize();
            }
        };
        presentation.addListener(configRunnable);
        RUIContext uiContext = new RUIContext();
        SelectRelativeCommandHandler commandHandler = new SelectRelativeCommandHandler(layers.selectionLayer);
        layers.viewportLayer.registerCommandHandler((ILayerCommandHandler)commandHandler);
        layers.selectionLayer.registerCommandHandler((ILayerCommandHandler)commandHandler);
        commandHandler = new CopyToClipboardCommandHandler(layers.selectionLayer, (ITableUIContext)uiContext);
        layers.selectionLayer.registerCommandHandler((ILayerCommandHandler)commandHandler);
        commandHandler = new InitializeAutoResizeCommandHandler(layers.selectionLayer);
        gridLayer.registerCommandHandler((ILayerCommandHandler)commandHandler);
        if (sortModel != null) {
            commandHandler = new SortPositionCommandHandler(sortModel);
            layers.dataLayer.registerCommandHandler((ILayerCommandHandler)commandHandler);
        }
        if (sortModel != null) {
            commandHandler = new ClearSortCommandHandler(sortModel);
            layers.dataLayer.registerCommandHandler((ILayerCommandHandler)commandHandler);
        }
        layers.table = new NatTable((Composite)this, (ILayer)gridLayer, false);
        layers.table.addConfiguration((IConfiguration)presentation);
        layers.table.addConfiguration((IConfiguration)new UIBindings.HeaderContextMenuConfiguration(layers.table));
        layers.table.addConfiguration((IConfiguration)new UIBindings.BodyContextMenuConfiguration(layers.table, this.callbacks.getServiceLocator()));
        layers.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dataProvider.dispose();
            }
        });
        IConfigRegistry registry = layers.table.getConfigRegistry();
        registry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new RDataFormatterConverter(dataProvider));
        registry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new RDataFormatterConverter.RowHeader(dataProvider), DisplayMode.NORMAL, "ROW_HEADER");
        this.tableLayers = layers;
        this.tableInitialized = false;
        configRunnable.run();
        this.tableLayers.table.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof ISelectionEvent) {
                    RDataTableComposite.this.scheduleUpdateSelection(false, 100);
                    return;
                }
                if (event instanceof IVisualChangeEvent) {
                    RDataTableComposite.this.scheduleUpdateSelection(true, 100);
                    return;
                }
            }
        });
        dataProvider.addDataChangedListener(new AbstractRDataProvider.DataProviderListener(){

            @Override
            public void onInputInitialized(boolean structChanged) {
                if (layers != RDataTableComposite.this.tableLayers || layers.table.isDisposed()) {
                    return;
                }
                if (layers.table != RDataTableComposite.this.layout.topControl) {
                    layers.table.configure();
                }
                if (layers.table != RDataTableComposite.this.layout.topControl) {
                    RDataTableComposite.this.layout.topControl = layers.table;
                    RDataTableComposite.this.layout();
                }
                if (!RDataTableComposite.this.tableInitialized) {
                    layers.selectionLayer.setSelectedCell(0L, 0L);
                } else if (structChanged) {
                    layers.dataLayer.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)layers.dataLayer));
                } else {
                    layers.dataLayer.fireLayerEvent((ILayerEvent)new RowUpdateEvent((ILayer)layers.dataLayer, new LRange(0L, layers.dataLayer.getRowCount())));
                }
                RDataTableComposite.this.selection = null;
                RDataTableComposite.this.scheduleUpdateSelection(true, 0);
                for (RDataTableListener listener : RDataTableComposite.this.tableListeners.toList()) {
                    listener.inputChanged(input, dataProvider.getDescription());
                }
            }

            @Override
            public void onInputFailed(int error) {
                if (error == 1) {
                    RDataTableComposite.this.showReload();
                } else {
                    RDataTableComposite.this.showDummy("An error occurred when loading the table input.");
                    for (RDataTableListener listener : RDataTableComposite.this.tableListeners.toList()) {
                        listener.inputChanged(null, null);
                    }
                }
            }

            @Override
            public void onRowCountChanged() {
                TableLayers layers2 = RDataTableComposite.this.tableLayers;
                if (layers2 == null || layers2.table != layers2.table || layers2.table.isDisposed()) {
                    return;
                }
                layers2.dataLayer.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)layers2.dataLayer));
                RDataTableComposite.this.selection = null;
                RDataTableComposite.this.scheduleUpdateSelection(true, 0);
            }

            @Override
            public void onRowsChanged(final long beginIdx, final long endIdx) {
                RDataTableComposite.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TableLayers layers = (this).RDataTableComposite.this.tableLayers;
                        if (layers == null || layers.table != layers.table || layers.table.isDisposed()) {
                            return;
                        }
                        layers.dataLayer.fireLayerEvent((ILayerEvent)new RowUpdateEvent((ILayer)layers.dataLayer, new LRange(beginIdx, endIdx)));
                    }
                });
            }
        });
        dataProvider.addFindListener(this::handleFindEvent);
    }

    public @Nullable NatTable getTable() {
        TableLayers tableLayers = this.tableLayers;
        return tableLayers != null ? tableLayers.table : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleUpdateSelection(boolean checkLabel, int delay) {
        Object object = this.selectionLock;
        synchronized (object) {
            this.selectionUpdateScheduleStamp = System.nanoTime() + (long)delay * 1000000L;
            if (checkLabel) {
                this.selectionCheckLabel = true;
            }
            if (this.selectionUpdateScheduled) {
                return;
            }
            this.selectionUpdateScheduled = true;
        }
        this.display.asyncExec(this.selectionUpdateRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelection() {
        RDataTableSelection selection;
        boolean checkLabel;
        Object object = this.selectionLock;
        synchronized (object) {
            long diff = (this.selectionUpdateScheduleStamp - System.nanoTime()) / 1000000L;
            if (diff > 5L) {
                this.display.timerExec((int)diff, this.selectionUpdateRunnable);
                return;
            }
            checkLabel = this.selectionCheckLabel;
            this.selectionCheckLabel = false;
            this.selectionUpdateScheduled = false;
        }
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers == null) {
            selection = new RDataTableSelection(null, null, null, null);
        } else {
            boolean lastSelectedChanged;
            boolean anchorChanged;
            SelectionLayer selectionLayer = tableLayers.selectionLayer;
            PositionCoordinate anchor = selectionLayer.getSelectionAnchor();
            PositionCoordinate lastSelected = selectionLayer.getLastSelectedCellPosition();
            if (lastSelected.equals((Object)anchor)) {
                lastSelected = null;
            }
            if (anchorChanged = !anchor.equals((Object)this.currentAnchor)) {
                this.currentAnchor = new PositionCoordinate(anchor);
            }
            if ((lastSelected != null ? lastSelected.equals((Object)this.currentLastSelectedCell) : this.currentLastSelectedCell == null) ? false : (lastSelectedChanged = true)) {
                PositionCoordinate positionCoordinate = this.currentLastSelectedCell = lastSelected != null ? new PositionCoordinate(lastSelected) : null;
            }
            if (!(checkLabel || anchorChanged || lastSelectedChanged)) {
                return;
            }
            String anchorRowLabel = null;
            String anchorColumnLabel = null;
            if (this.currentAnchor.columnPosition >= 0L && this.currentAnchor.rowPosition >= 0L) {
                if (anchorChanged || checkLabel) {
                    anchorRowLabel = this.getRowLabel(this.currentAnchor.rowPosition);
                    if (anchorRowLabel != null && (anchorColumnLabel = this.getColumnLabel(this.currentAnchor.columnPosition)) == null) {
                        anchorRowLabel = null;
                    }
                } else if (this.selection != null) {
                    anchorRowLabel = this.selection.getAnchorRowLabel();
                    anchorColumnLabel = this.selection.getAnchorColumnLabel();
                }
            }
            if (anchorRowLabel == null) {
                return;
            }
            String lastSelectedRowLabel = null;
            String lastSelectedColumnLabel = null;
            PositionCoordinate lastSelectedCell = this.currentLastSelectedCell;
            if (lastSelectedCell != null && lastSelectedCell.columnPosition >= 0L && lastSelectedCell.rowPosition >= 0L) {
                if (lastSelectedChanged || checkLabel) {
                    lastSelectedRowLabel = this.getRowLabel(lastSelectedCell.rowPosition);
                    if (lastSelectedRowLabel != null && (lastSelectedColumnLabel = this.getColumnLabel(lastSelectedCell.columnPosition)) == null) {
                        lastSelectedRowLabel = null;
                    }
                } else if (this.selection != null) {
                    lastSelectedRowLabel = this.selection.getLastSelectedCellRowLabel();
                    lastSelectedColumnLabel = this.selection.getLastSelectedCellColumnLabel();
                }
            }
            selection = new RDataTableSelection(anchorRowLabel, anchorColumnLabel, lastSelectedRowLabel, lastSelectedColumnLabel);
        }
        if (selection.equals(this.selection)) {
            return;
        }
        this.selection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection);
        for (ISelectionChangedListener listener : this.selectionListeners.toList()) {
            listener.selectionChanged(event);
        }
    }

    protected @Nullable String getRowLabel(long row) {
        if (!this.dataProvider.hasRealRows()) {
            return "";
        }
        IDataProvider dataProvider = this.dataProvider.getRowDataProvider();
        if (dataProvider.getColumnCount() <= 1L) {
            return this.getHeaderLabel(dataProvider.getDataValue(0L, row, 0, null));
        }
        StringBuilder sb = new StringBuilder();
        long i = 0L;
        while (i < dataProvider.getColumnCount()) {
            String label = this.getHeaderLabel(dataProvider.getDataValue(i, row, 0, null));
            if (label == null) {
                return null;
            }
            sb.append(label);
            sb.append(", ");
            ++i;
        }
        return sb.substring(0, sb.length() - 2);
    }

    protected @Nullable String getColumnLabel(long column) {
        if (!this.dataProvider.hasRealColumns()) {
            return "";
        }
        IDataProvider dataProvider = this.dataProvider.getColumnDataProvider();
        if (dataProvider.getRowCount() <= 1L) {
            return this.getHeaderLabel(dataProvider.getDataValue(column, 0L, 0, null));
        }
        StringBuilder sb = new StringBuilder();
        long i = 0L;
        while (i < dataProvider.getRowCount()) {
            String label = this.getHeaderLabel(dataProvider.getDataValue(column, i, 0, null));
            if (label == null) {
                return null;
            }
            sb.append(label);
            sb.append(", ");
            ++i;
        }
        return sb.substring(0, sb.length() - 2);
    }

    private @Nullable String getHeaderLabel(@Nullable Object value) {
        if (value != null) {
            if (value instanceof ControlData && value != AbstractRDataProvider.NA) {
                return null;
            }
            Object displayValue = this.formatter.modelToDisplayValue(value);
            if (displayValue.getClass() == String.class) {
                return (String)displayValue;
            }
            if (displayValue == AbstractRDataProvider.DUMMY) {
                return "";
            }
            return null;
        }
        return this.formatter.modelToDisplayValue(null).toString();
    }

    protected void showDummy(String message) {
        if (this.isDisposed()) {
            return;
        }
        this.messageControl.setText(message);
        this.layout.topControl = this.messageControl;
        this.layout();
    }

    public long @Nullable [] getTableDimension() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            return new long[]{this.dataProvider.getRowCount(), this.dataProvider.getColumnCount()};
        }
        return null;
    }

    public boolean isOK() {
        TableLayers tableLayers = this.tableLayers;
        return tableLayers != null && this.layout.topControl == tableLayers.table;
    }

    public IViewportDim getViewport(Orientation orientation) {
        return this.tableLayers.viewportLayer.getDim(orientation);
    }

    public @Nullable ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void find(String expression, boolean selectedOnly, boolean firstInRow, boolean forward) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            PositionCoordinate anchor = tableLayers.selectionLayer.getSelectionAnchor();
            FindTask task = new FindTask(expression, anchor.getRowPosition(), anchor.getColumnPosition(), firstInRow, forward, selectedOnly ? new SelectionFindFilter() : null);
            this.dataProvider.find(task);
        }
    }

    public void addFindListener(FindListener listener) {
        this.findListeners.add((Object)listener);
    }

    public void removeFindListener(FindListener listener) {
        this.findListeners.remove((Object)listener);
    }

    private void handleFindEvent(FindListener.FindEvent event) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            if (event.rowIdx >= 0L) {
                tableLayers.setAnchor(event.colIdx, event.rowIdx, true);
            }
            for (FindListener listener : this.findListeners.toList()) {
                listener.handleFindEvent(event);
            }
        }
    }

    public void setInput(final RDataTableInput input) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            this.showDummy("");
            tableLayers.table.dispose();
            tableLayers.table = null;
            this.dataProvider = null;
            this.setAnchorByData = null;
        }
        if (input != null) {
            this.showDummy("Preparing (" + input.getName() + ")...");
            try {
                SystemRunnable runnable = new SystemRunnable(){

                    public String getTypeId() {
                        return "r/dataeditor/init";
                    }

                    public String getLabel() {
                        return "Prepare Data Viewer (" + input.getName() + ")";
                    }

                    public boolean canRunIn(Tool tool) {
                        return true;
                    }

                    public boolean changed(int event, Tool process) {
                        return event != 289;
                    }

                    public void run(ToolService service, ProgressMonitor m) throws StatusException {
                        org.eclipse.core.runtime.Status status;
                        RToolService r = (RToolService)service;
                        AtomicReference<AbstractRDataProvider> dataProvider = new AtomicReference<AbstractRDataProvider>();
                        Throwable error = null;
                        try {
                            RObject struct = r.evalData(input.getFullName(), null, 1, 1, m);
                            RCharacterStore classNames = null;
                            FunctionCall call = r.createFunctionCall("class");
                            call.add(input.getFullName());
                            classNames = (RCharacterStore)RDataUtils.checkRCharVector((RObject)call.evalData(m)).getData();
                            switch (struct.getRObjectType()) {
                                case 2: {
                                    dataProvider.set(new RVectorDataProvider(input, (RVector)struct));
                                    break;
                                }
                                case 3: {
                                    RArray array = (RArray)struct;
                                    if (array.getDim().getLength() == 2L) {
                                        if (classNames.contains("ftable")) {
                                            dataProvider.set(new FTableDataProvider(input, array));
                                            break;
                                        }
                                        dataProvider.set(new RMatrixDataProvider(input, array));
                                    }
                                    break;
                                }
                                case 6: {
                                    dataProvider.set(new RDataFrameDataProvider(input, (RDataFrame)struct));
                                    break;
                                }
                            }
                        }
                        catch (CoreException e) {
                            error = e;
                        }
                        catch (UnexpectedRDataException e) {
                            error = e;
                        }
                        if (error != null) {
                            status = new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", "An error occurred when preparing the R data viewer.", error);
                            StatusManager.getManager().handle((IStatus)status);
                        } else {
                            status = dataProvider.get() == null ? new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", "This R element type is not supported.", null) : null;
                        }
                        RDataTableComposite.this.display.asyncExec(new Runnable((IStatus)status, input, dataProvider){
                            private final /* synthetic */ IStatus val$status;
                            private final /* synthetic */ RDataTableInput val$input;
                            private final /* synthetic */ AtomicReference val$dataProvider;
                            {
                                this.val$status = iStatus;
                                this.val$input = rDataTableInput;
                                this.val$dataProvider = atomicReference;
                            }

                            @Override
                            public void run() {
                                (this).RDataTableComposite.this.dataProvider = null;
                                if (!UIAccess.isOkToUse((Control)RDataTableComposite.this)) {
                                    return;
                                }
                                if (this.val$status == null) {
                                    RDataTableComposite.this.initTable(this.val$input, (AbstractRDataProvider)this.val$dataProvider.get());
                                } else {
                                    RDataTableComposite.this.showDummy(this.val$status.getMessage());
                                }
                            }
                        });
                    }
                };
                Status status = input.getTool().getQueue().add((ToolRunnable)runnable);
                if (status.getSeverity() >= 4) {
                    throw new StatusException(status);
                }
            }
            catch (StatusException e) {
                this.showDummy(e.getLocalizedMessage());
            }
        }
    }

    protected void showReload() {
        Composite reloadControl = this.reloadControl;
        if (reloadControl == null) {
            reloadControl = new Composite((Composite)this, 0);
            reloadControl.setLayout((Layout)LayoutUtils.newCompositeGrid((int)4));
            Label label = new Label(reloadControl, 64);
            label.setText("The structure of the R element is changed (columns / data type).");
            label.setLayoutData((Object)new GridData(4, 128, true, false, 4, 1));
            Button button = new Button(reloadControl, 8);
            button.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, false, false), (Button)button));
            button.setText("Refresh");
            button.setToolTipText("Refresh table with old structure");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RDataTableComposite.this.refresh();
                }
            });
            button = new Button(reloadControl, 8);
            button.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, false, false), (Button)button));
            button.setText("Reopen");
            button.setToolTipText("Reopen table with new structure");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RDataTableComposite.this.setInput(RDataTableComposite.this.input);
                }
            });
            if (this.callbacks.isCloseSupported()) {
                button = new Button(reloadControl, 8);
                button.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, false, false), (Button)button));
                button.setText("Close");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        RDataTableComposite.this.callbacks.close();
                    }
                });
            }
            LayoutUtils.addSmallFiller((Composite)reloadControl, (boolean)true);
            this.reloadControl = reloadControl;
        }
        this.layout.topControl = reloadControl;
        this.layout(true);
    }

    public void setFilter(@Nullable String filter) {
        this.dataProvider.setFilter(filter);
    }

    public RDataTableContentDescription getDescription() {
        return this.dataProvider.getDescription();
    }

    public void addTableListener(RDataTableListener listener) {
        this.tableListeners.add((Object)listener);
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            listener.inputChanged(this.input, this.dataProvider.getDescription());
        }
    }

    public void removeTableListener(RDataTableListener listener) {
        this.tableListeners.remove((Object)listener);
    }

    public boolean setFocus() {
        if (this.layout == null || this.layout.topControl == null) {
            return false;
        }
        return this.layout.topControl.forceFocus();
    }

    public void revealColumn(long index) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.viewportLayer.getDim(Orientation.HORIZONTAL).movePositionIntoViewport(index);
        }
    }

    public void selectColumns(Collection<LRange> indexes) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            LRangeList columns = LRangeList.toRangeList(indexes);
            long rowIndex = 0L;
            tableLayers.table.doCommand((ILayerCommand)new SelectDimPositionsCommand(tableLayers.selectionLayer.getDim(Orientation.HORIZONTAL), 0L, (Collection)columns, 0L, 0, !columns.isEmpty() ? columns.values().first() : Long.MIN_VALUE));
        }
    }

    public void setAnchorViewIdxs(long columnIndex, long rowIndex) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.selectionLayer.setSelectionAnchor(columnIndex, rowIndex, true);
        }
    }

    public long @Nullable [] getAnchorDataIdxs() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            PositionCoordinate coordinate = tableLayers.selectionLayer.getSelectionAnchor();
            if (coordinate.columnPosition < 0L || coordinate.rowPosition < 0L) {
                return null;
            }
            return this.dataProvider.toDataIdxs(coordinate.columnPosition, coordinate.rowPosition);
        }
        return null;
    }

    public void setAnchorDataIdxs(long columnIdx, long rowIdx) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            ResolveCellIndexes data = this.setAnchorByData;
            if (data == null) {
                this.setAnchorByData = data = new SetAnchorByDataIndexes(this.dataProvider);
            }
            data.resolve(columnIdx, rowIdx);
        }
    }

    public void selectAll() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.table.doCommand((ILayerCommand)new SelectAllCommand());
        }
    }

    public void sortByColumn(long index, boolean increasing) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.dataLayer.doCommand((ILayerCommand)new SortDimPositionCommand(tableLayers.dataLayer.getDim(Orientation.HORIZONTAL), index, increasing ? SortDirection.ASC : SortDirection.DESC, false));
        }
    }

    public void clearSorting() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.table.doCommand((ILayerCommand)new ClearSortCommand());
        }
    }

    public void refresh() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            this.dataProvider.reset();
            tableLayers.table.redraw();
        }
    }

    private class RUIContext
    implements ITableUIContext {
        public void run(boolean fork, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            IRunnableContext runnableContext = (IRunnableContext)RDataTableComposite.this.callbacks.getServiceLocator().getService(IProgressService.class);
            runnableContext.run(fork, cancelable, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ((RUIContext)RUIContext.this).RDataTableComposite.this.dataProvider.beginOperation(this);
                    try {
                        runnable.run(monitor);
                    }
                    finally {
                        ((RUIContext)RUIContext.this).RDataTableComposite.this.dataProvider.endOperation(this);
                    }
                }
            });
        }

        public void show(IStatus status) {
            StatusManager.getManager().handle(status, 2);
        }
    }

    private class SelectionFindFilter
    implements FindFilter {
        private SelectionFindFilter() {
        }

        @Override
        public boolean match(long rowIdx, long columnIdx) {
            TableLayers tableLayers = RDataTableComposite.this.tableLayers;
            if (tableLayers != null) {
                if (columnIdx >= 0L) {
                    return tableLayers.selectionLayer.isCellPositionSelected(columnIdx, rowIdx);
                }
                return tableLayers.selectionLayer.isRowPositionSelected(rowIdx);
            }
            return false;
        }
    }

    private class SetAnchorByDataIndexes
    extends ResolveCellIndexes {
        public SetAnchorByDataIndexes(AbstractRDataProvider<?> dataProvider) {
            super(dataProvider);
        }

        @Override
        protected void execute(final long columnIndex, final long rowIndex) {
            RDataTableComposite.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SetAnchorByDataIndexes.this.getDataProvider() != ((SetAnchorByDataIndexes)SetAnchorByDataIndexes.this).RDataTableComposite.this.dataProvider) {
                        return;
                    }
                    RDataTableComposite.this.setAnchorViewIdxs(columnIndex, rowIndex);
                }
            });
        }
    }
}

