/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsStatus;

public abstract class GDCmdItem
extends MainCmdItem {
    public static final byte SET_CLIP = 1;
    public static final byte SET_COLOR = 2;
    public static final byte SET_FILL = 3;
    public static final byte SET_LINE = 4;
    public static final byte SET_FONT = 5;
    public static final byte DRAW_LINE = 17;
    public static final byte DRAW_RECTANGLE = 18;
    public static final byte DRAW_POLYLINE = 19;
    public static final byte DRAW_POLYGON = 20;
    public static final byte DRAW_PATH = 21;
    public static final byte DRAW_CIRCLE = 22;
    public static final byte DRAW_TEXT = 23;
    public static final byte DRAW_RASTER = 24;
    public static final byte CAPTURE = 28;
    public static final byte C_NEW_PAGE = 33;
    public static final byte C_CLOSE_DEVICE = 34;
    public static final byte C_GET_SIZE = 35;
    public static final byte C_SET_ACTIVE_OFF = 36;
    public static final byte C_SET_ACTIVE_ON = 37;
    public static final byte C_SET_MODE = 38;
    public static final byte C_GET_FONTMETRIC = 39;
    public static final byte C_GET_STRINGWIDTH = 40;
    public static final byte U_LOCATOR = 49;
    private static final double[] NO_DATA = new double[0];
    protected int devId;

    protected GDCmdItem() {
    }

    @Override
    public final byte getCmdType() {
        return 7;
    }

    @Override
    public byte getOp() {
        return 0;
    }

    @Override
    public final boolean isOK() {
        return (this.options & 0xF00000) == 0;
    }

    @Override
    public final RjsStatus getStatus() {
        return null;
    }

    public final int getDeviceId() {
        return this.devId;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        throw new UnsupportedOperationException();
    }

    public double[] getDoubleData() {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getDataText() {
        return null;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (!(other instanceof GDCmdItem)) {
            return false;
        }
        GDCmdItem otherItem = (GDCmdItem)other;
        if (this.options != otherItem.options) {
            return false;
        }
        return this.getDeviceId() == otherItem.getDeviceId();
    }

    public static final class Answer
    extends GDCmdItem {
        private static final int OM_WITHDATA = 0x7000000;
        private static final int OV_WITHDOUBLE = 0x1000000;
        private static final int OV_WITHBYTE = 0x2000000;
        private final Object data;

        public Answer(byte requestId, int devId, byte[] data) {
            this.options = data != null ? -2113929216 : Integer.MIN_VALUE;
            this.devId = devId;
            this.data = data;
            this.requestId = requestId;
        }

        public Answer(byte requestId, int devId, RjsStatus status) {
            this.options = Integer.MIN_VALUE | status.getSeverity() << 20;
            this.devId = devId;
            this.data = NO_DATA;
            this.requestId = requestId;
        }

        public Answer(RJIO io) throws IOException, ClassNotFoundException {
            this.options = io.readInt();
            this.devId = io.readInt();
            this.requestId = io.readByte();
            switch (this.options & 0x7000000) {
                case 0x1000000: {
                    double[] d = new double[io.readInt()];
                    io.readDoubleData(d, d.length);
                    this.data = d;
                    break;
                }
                case 0x2000000: {
                    byte[] b = new byte[io.readInt()];
                    io.readByteData(b, b.length);
                    this.data = b;
                    break;
                }
                default: {
                    this.data = null;
                }
            }
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.options);
            io.writeInt(this.devId);
            io.writeByte(this.requestId);
            switch (this.options & 0x7000000) {
                case 0x1000000: {
                    double[] d = (double[])this.data;
                    io.writeInt(d.length);
                    io.writeDoubleData(d, d.length);
                    break;
                }
                case 0x2000000: {
                    byte[] b = (byte[])this.data;
                    io.writeInt(b.length);
                    io.writeByteData(b, b.length);
                }
            }
        }

        @Override
        public double[] getDoubleData() {
            return (double[])this.data;
        }

        @Override
        public byte[] getByteData() {
            return (byte[])this.data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=ANSWER");
            sb.append(")");
            sb.append("\n<GD-DATA>\n");
            switch (this.options & 0x7000000) {
                case 0x1000000: {
                    sb.append(Arrays.toString((double[])this.data));
                }
            }
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class CCloseDevice
    extends GDCmdItem {
        public CCloseDevice(int devId, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)34);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(34);
            sb.append(")\n<GD-DATA />");
            return sb.toString();
        }
    }

    public static final class CGetFontMetric
    extends GDCmdItem {
        private final int c;

        public CGetFontMetric(int devId, int c, byte slot) {
            this.options = Integer.MIN_VALUE;
            this.devId = devId;
            this.c = c;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(Integer.MIN_VALUE | this.devId);
            io.writeByte((byte)39);
            io.writeByte(this.requestId);
            io.writeInt(this.c);
        }

        @Override
        public void setAnswer(RjsStatus status) {
            this.options = this.options & 0xF00FFFFF | status.getSeverity() << 20;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(39);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class CGetSize
    extends GDCmdItem {
        public CGetSize(int devId, byte slot) {
            this.options = Integer.MIN_VALUE;
            this.devId = devId;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(Integer.MIN_VALUE | this.devId);
            io.writeByte((byte)35);
            io.writeByte(this.requestId);
        }

        @Override
        public void setAnswer(RjsStatus status) {
            this.options = this.options & 0xF00FFFFF | status.getSeverity() << 20;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(35);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class CGetStrWidth
    extends GDCmdItem {
        private final String text;

        public CGetStrWidth(int devId, String text, byte slot) {
            this.options = Integer.MIN_VALUE;
            this.devId = devId;
            this.text = text;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(Integer.MIN_VALUE | this.devId);
            io.writeByte((byte)40);
            io.writeByte(this.requestId);
            io.writeString(this.text);
        }

        @Override
        public void setAnswer(RjsStatus status) {
            this.options = this.options & 0xF00FFFFF | status.getSeverity() << 20;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(40);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class CInit
    extends GDCmdItem {
        private final double w;
        private final double h;
        private final int canvasColor;
        private final boolean active;

        public CInit(int devId, double w, double h, int canvasColor, boolean activate, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.w = w;
            this.h = h;
            this.canvasColor = canvasColor;
            this.active = activate;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)33);
            io.writeDouble(this.w);
            io.writeDouble(this.h);
            io.writeInt(this.canvasColor);
            io.writeBoolean(this.active);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(33);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class CSetActiveOff
    extends GDCmdItem {
        public CSetActiveOff(int devId, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)36);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(36);
            sb.append(")\n<GD-DATA />");
            return sb.toString();
        }
    }

    public static final class CSetActiveOn
    extends GDCmdItem {
        public CSetActiveOn(int devId, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)37);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(37);
            sb.append(")\n<GD-DATA />");
            return sb.toString();
        }
    }

    public static final class CSetMode
    extends GDCmdItem {
        private final byte mode;

        public CSetMode(int devId, int mode, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.mode = (byte)mode;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)38);
            io.writeByte(this.mode);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(38);
            sb.append(")<GD-DATA>\nmode= ");
            sb.append(this.mode);
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class Capture
    extends GDCmdItem {
        private final int w;
        private final int h;

        public Capture(int devId, int w, int h, byte slot) {
            this.options = Integer.MIN_VALUE;
            this.devId = devId;
            this.w = w;
            this.h = h;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)28);
            io.writeByte(this.requestId);
            io.writeInt(this.w);
            io.writeInt(this.h);
        }

        @Override
        public void setAnswer(RjsStatus status) {
            this.options = this.options & 0xF00FFFFF | status.getSeverity() << 20;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(28);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DoubleAnswer
    extends GDCmdItem {
        private final double[] data;

        public DoubleAnswer(byte requestId, int devId, double[] data) {
            this.options = data != null ? -2130706432 : Integer.MIN_VALUE;
            this.devId = devId;
            this.data = data;
            this.requestId = requestId;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.options);
            io.writeInt(this.devId);
            io.writeByte(this.requestId);
            if (this.data != null) {
                int length = this.data.length;
                io.writeInt(length);
                io.writeDoubleData(this.data, length);
            }
        }

        @Override
        public double[] getDoubleData() {
            return this.data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=ANSWER");
            sb.append(")");
            sb.append("\n<GD-DATA>\n");
            sb.append(Arrays.toString(this.data));
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DrawCircle
    extends GDCmdItem {
        private final double x;
        private final double y;
        private final double r;

        public DrawCircle(int devId, double x, double y, double r, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.x = x;
            this.y = y;
            this.r = r;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)22);
            io.writeDouble(this.x);
            io.writeDouble(this.y);
            io.writeDouble(this.r);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(22);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DrawLine
    extends GDCmdItem {
        private final double x0;
        private final double y0;
        private final double x1;
        private final double y1;

        public DrawLine(int devId, double x0, double y0, double x1, double y1, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)17);
            io.writeDouble(this.x0);
            io.writeDouble(this.y0);
            io.writeDouble(this.x1);
            io.writeDouble(this.y1);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(17);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DrawPath
    extends GDCmdItem {
        private final int[] n;
        private final double[] x;
        private final double[] y;
        private final int mode;

        public DrawPath(int devId, int[] n, double[] x, double[] y, int mode, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.n = n;
            this.x = x;
            this.y = y;
            this.mode = mode;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)21);
            io.writeIntArray(this.n, this.n.length);
            int length = this.x.length;
            io.writeInt(length);
            io.writeDoubleData(this.x, length);
            io.writeDoubleData(this.y, length);
            io.writeInt(this.mode);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(21);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DrawPolygon
    extends GDCmdItem {
        private final double[] x;
        private final double[] y;

        public DrawPolygon(int devId, double[] x, double[] y, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.x = x;
            this.y = y;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)20);
            int length = this.x.length;
            io.writeInt(length);
            io.writeDoubleData(this.x, length);
            io.writeDoubleData(this.y, length);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(20);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DrawPolyline
    extends GDCmdItem {
        private final double[] x;
        private final double[] y;

        public DrawPolyline(int devId, double[] x, double[] y, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.x = x;
            this.y = y;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)19);
            int length = this.x.length;
            io.writeInt(length);
            io.writeDoubleData(this.x, length);
            io.writeDoubleData(this.y, length);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(19);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DrawRaster
    extends GDCmdItem {
        private final byte[] imgData;
        private final boolean imgAlpha;
        private final int imgW;
        private final int imgH;
        private final double x;
        private final double y;
        private final double w;
        private final double h;
        private final double rDeg;
        private final boolean interpolate;

        public DrawRaster(int devId, byte[] imgData, boolean imgAlpha, int imgW, int imgH, double x, double y, double w, double h, double rDeg, boolean interpolate, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.imgData = imgData;
            this.imgAlpha = imgAlpha;
            this.imgW = imgW;
            this.imgH = imgH;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.rDeg = rDeg;
            this.interpolate = interpolate;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)24);
            io.writeInt(this.imgData.length);
            io.writeByteData(this.imgData, this.imgData.length);
            io.writeBoolean(this.imgAlpha);
            io.writeInt(this.imgW);
            io.writeInt(this.imgH);
            io.writeDouble(this.x);
            io.writeDouble(this.y);
            io.writeDouble(this.w);
            io.writeDouble(this.h);
            io.writeDouble(this.rDeg);
            io.writeBoolean(this.interpolate);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(24);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DrawRect
    extends GDCmdItem {
        private final double x0;
        private final double y0;
        private final double x1;
        private final double y1;

        public DrawRect(int devId, double x0, double y0, double x1, double y1, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)18);
            io.writeDouble(this.x0);
            io.writeDouble(this.y0);
            io.writeDouble(this.x1);
            io.writeDouble(this.y1);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(18);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class DrawText
    extends GDCmdItem {
        private final String text;
        private final double x;
        private final double y;
        private final double rDeg;
        private final double hAdj;

        public DrawText(int devId, String text, double x, double y, double rDeg, double hAdj, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.text = text;
            this.x = x;
            this.y = y;
            this.rDeg = rDeg;
            this.hAdj = hAdj;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)23);
            io.writeString(this.text);
            io.writeDouble(this.x);
            io.writeDouble(this.y);
            io.writeDouble(this.rDeg);
            io.writeDouble(this.hAdj);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(23);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class Locator
    extends GDCmdItem {
        public Locator(int devId, byte slot) {
            this.options = Integer.MIN_VALUE;
            this.devId = devId;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(Integer.MIN_VALUE | this.devId);
            io.writeByte((byte)49);
            io.writeByte(this.requestId);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(49);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class SetClip
    extends GDCmdItem {
        private final double x0;
        private final double y0;
        private final double x1;
        private final double y1;

        public SetClip(int devId, double x0, double y0, double x1, double y1, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)1);
            io.writeDouble(this.x0);
            io.writeDouble(this.y0);
            io.writeDouble(this.x1);
            io.writeDouble(this.y1);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(1);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class SetColor
    extends GDCmdItem {
        private final int cc;

        public SetColor(int devId, int cc, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.cc = cc;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)2);
            io.writeInt(this.cc);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(2);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class SetFill
    extends GDCmdItem {
        private final int cc;

        public SetFill(int devId, int cc, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.cc = cc;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)3);
            io.writeInt(this.cc);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(3);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class SetFont
    extends GDCmdItem {
        private final String family;
        private final int face;
        private final float pointSize;
        private final float lineHeight;

        public SetFont(int devId, String family, int face, float pointSize, float lineHeight, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.family = family;
            this.face = face;
            this.pointSize = pointSize;
            this.lineHeight = lineHeight;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)5);
            io.writeString(this.family);
            io.writeInt(this.face);
            io.writeFloat(this.pointSize);
            io.writeFloat(this.lineHeight);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(5);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }

    public static final class SetLine
    extends GDCmdItem {
        private final int type;
        private final float width;
        private final byte cap;
        private final byte join;
        private final float joinMiterLimit;

        public SetLine(int devId, int type, float width, byte cap, byte join, float joinMiterLimit, byte slot) {
            this.options = 0;
            this.devId = devId;
            this.type = type;
            this.width = width;
            this.cap = cap;
            this.join = join;
            this.joinMiterLimit = joinMiterLimit;
            this.slot = slot;
        }

        @Override
        public void writeExternal(RJIO io) throws IOException {
            io.writeInt(this.devId);
            io.writeByte((byte)4);
            io.writeInt(this.type);
            io.writeFloat(this.width);
            io.writeByte(this.cap);
            io.writeByte(this.join);
            io.writeFloat(this.joinMiterLimit);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GDCmdItem (options=0x");
            sb.append(Integer.toHexString(this.options));
            sb.append(", device=");
            sb.append(this.devId);
            sb.append(", commandId=");
            sb.append(4);
            sb.append(")\n<GD-DATA>\n");
            sb.append("\n</GD-DATA>");
            return sb.toString();
        }
    }
}

