/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srvext.auth;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.server.srvext.ServerAuthMethod;

public abstract class JaasAuthMethod
extends ServerAuthMethod
implements CallbackHandler,
Runnable {
    private static String JAAS_NAME = "org.eclipse.statet.rj.server";
    private static final int STARTED = 1;
    private static final int CALLBACK = 2;
    private static final int PERFORM = 3;
    private static final int LOGGED_IN = 4;
    private static final int CANCEL = -1;
    private static final int FAILED = -2;
    private Configuration configuration;
    private LoginContext context;
    private ImList<Callback> pendingLoginCallback;
    private int pendingLogin;
    private String pendingLoginMsg;
    private final Thread loginThread = new Thread(this);

    protected JaasAuthMethod(String id) {
        super(id, true);
    }

    @Override
    public void doInit(@Nullable String arg) throws RjException {
        this.configuration = Configuration.getConfiguration();
        if (this.configuration.getAppConfigurationEntry(JAAS_NAME) == null) {
            this.configuration = new JaasConfig(arg);
        }
        try {
            this.context = new LoginContext(JAAS_NAME, new Subject(), this, this.configuration);
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ImList<Callback> doCreateLogin() throws RjException {
        this.cancel();
        this.loginThread.start();
        JaasAuthMethod jaasAuthMethod = this;
        synchronized (jaasAuthMethod) {
            while (this.pendingLogin >= 0 && this.pendingLogin < 2) {
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.pendingLogin == -2) {
            throw new SecurityException("failed to init login", null);
        }
        return this.pendingLoginCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doPerformLogin(ImList<Callback> callbacks) throws LoginException, RjException {
        this.pendingLoginCallback = callbacks;
        this.pendingLogin = 3;
        JaasAuthMethod jaasAuthMethod = this;
        synchronized (jaasAuthMethod) {
            while (this.loginThread.isAlive()) {
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.pendingLogin == 4) {
            return null;
        }
        if (this.pendingLoginMsg != null) {
            throw new LoginException(this.pendingLoginMsg);
        }
        throw new SecurityException("", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancel() {
        this.pendingLoginCallback = null;
        this.pendingLoginMsg = null;
        this.pendingLogin = -1;
        JaasAuthMethod jaasAuthMethod = this;
        synchronized (jaasAuthMethod) {
            while (this.loginThread.isAlive()) {
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.pendingLogin = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            this.pendingLogin = 1;
            try {
                this.context.login();
                this.pendingLogin = 4;
                this.context.logout();
            }
            catch (LoginException e) {
                this.pendingLogin = -2;
                this.pendingLoginMsg = e.getLocalizedMessage();
                JaasAuthMethod jaasAuthMethod = this;
                synchronized (jaasAuthMethod) {
                    this.notifyAll();
                    break block18;
                }
            }
            catch (Throwable e) {
                JaasAuthMethod jaasAuthMethod;
                try {
                    this.pendingLogin = -2;
                    jaasAuthMethod = this;
                }
                catch (Throwable throwable) {
                    JaasAuthMethod jaasAuthMethod2 = this;
                    synchronized (jaasAuthMethod2) {
                        this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (jaasAuthMethod) {
                    this.notifyAll();
                    break block18;
                }
            }
            JaasAuthMethod jaasAuthMethod = this;
            synchronized (jaasAuthMethod) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.pendingLogin != 1) {
            if (callbacks.length <= 0) return;
            this.pendingLogin = -2;
            throw new UnsupportedCallbackException(callbacks[0]);
        }
        this.pendingLogin = 2;
        this.pendingLoginCallback = ImCollections.newList((Object[])callbacks);
        JaasAuthMethod jaasAuthMethod = this;
        synchronized (jaasAuthMethod) {
            while (this.pendingLogin == 2) {
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.pendingLogin != 3) {
            throw new IOException();
        }
        JaasAuthMethod.copyAnswer(this.pendingLoginCallback, callbacks);
    }

    private class JaasConfig
    extends Configuration {
        private final AppConfigurationEntry entry;

        JaasConfig(String clazz) {
            this.entry = new AppConfigurationEntry(clazz, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return null;
        }

        @Override
        public void refresh() {
        }
    }
}

