/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers.breadcrumb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbViewerRow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class BreadcrumbViewer
extends StructuredViewer {
    private static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());
    private final Composite container;
    private final ArrayList<BreadcrumbItem> breadcrumbItems = new ArrayList();
    private final ListenerList menuListeners = new ListenerList();
    private Image gradientBackground;
    private BreadcrumbItem selectedItem;
    private ILabelProvider toolTipLabelProvider;

    static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = BreadcrumbViewer.blend(c1.red, c2.red, ratio);
        int g = BreadcrumbViewer.blend(c1.green, c2.green, ratio);
        int b = BreadcrumbViewer.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    public BreadcrumbViewer(Composite parent, int style) {
        this.container = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 128, true, false);
        this.container.setLayoutData((Object)layoutData);
        this.container.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        this.container.setBackgroundMode(1);
        this.container.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int height = BreadcrumbViewer.this.container.getClientArea().height;
                if (BreadcrumbViewer.this.gradientBackground == null || BreadcrumbViewer.this.gradientBackground.getBounds().height != height) {
                    Image image = height > 0 ? BreadcrumbViewer.this.createGradientImage(height, event.display) : null;
                    BreadcrumbViewer.this.container.setBackgroundImage(image);
                    if (BreadcrumbViewer.this.gradientBackground != null) {
                        BreadcrumbViewer.this.gradientBackground.dispose();
                    }
                    BreadcrumbViewer.this.gradientBackground = image;
                }
            }
        });
        this.hookControl((Control)this.container);
        int columns = 1000;
        if ((0x200 & style) != 0) {
            columns = 1;
        }
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.container.setLayout((Layout)gridLayout);
        this.container.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                BreadcrumbViewer.this.refresh();
            }
        });
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.gradientBackground != null && !this.gradientBackground.isDisposed()) {
            this.gradientBackground.dispose();
            this.gradientBackground = null;
        }
        if (this.toolTipLabelProvider != null) {
            this.toolTipLabelProvider.dispose();
            this.toolTipLabelProvider = null;
        }
        if (this.breadcrumbItems != null) {
            for (BreadcrumbItem item : this.breadcrumbItems) {
                item.dispose();
            }
            this.breadcrumbItems.clear();
        }
        super.handleDispose(event);
    }

    public void setToolTipLabelProvider(ILabelProvider toolTipLabelProvider) {
        this.toolTipLabelProvider = toolTipLabelProvider;
    }

    public Control getControl() {
        return this.container;
    }

    protected Object getRoot() {
        if (this.breadcrumbItems.isEmpty()) {
            return null;
        }
        return this.breadcrumbItems.get(0).getData();
    }

    public void reveal(Object element) {
    }

    public void setFocus() {
        this.container.setFocus();
        if (this.selectedItem != null) {
            this.selectedItem.setFocus(true);
        } else {
            if (this.breadcrumbItems.size() == 0) {
                return;
            }
            BreadcrumbItem item = this.breadcrumbItems.get(this.breadcrumbItems.size() - 1);
            if (item.getData() == null) {
                if (this.breadcrumbItems.size() < 2) {
                    return;
                }
                item = this.breadcrumbItems.get(this.breadcrumbItems.size() - 2);
            }
            item.setFocus(true);
        }
    }

    public boolean isDropDownOpen() {
        int i = 0;
        int size = this.breadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = this.breadcrumbItems.get(i);
            if (item.isMenuShown()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Shell getDropDownShell() {
        int i = 0;
        int size = this.breadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = this.breadcrumbItems.get(i);
            if (item.isMenuShown()) {
                return item.getDropDownShell();
            }
            ++i;
        }
        return null;
    }

    public ISelectionProvider getDropDownSelectionProvider() {
        int i = 0;
        int size = this.breadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = this.breadcrumbItems.get(i);
            if (item.isMenuShown()) {
                return item.getDropDownSelectionProvider();
            }
            ++i;
        }
        return null;
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.menuListeners.add((Object)listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.menuListeners.remove((Object)listener);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        super.assertContentProviderType(provider);
        Assert.isTrue((boolean)(provider instanceof ITreeContentProvider));
    }

    protected void inputChanged(Object fInput, Object oldInput) {
        if (this.container.isDisposed()) {
            return;
        }
        this.disableRedraw();
        try {
            int lastIndex;
            if (this.breadcrumbItems.size() > 0) {
                BreadcrumbItem last = this.breadcrumbItems.get(this.breadcrumbItems.size() - 1);
                last.setIsLastItem(false);
            }
            if ((lastIndex = this.buildItemChain(fInput)) > 0) {
                BreadcrumbItem last = this.breadcrumbItems.get(lastIndex - 1);
                last.setIsLastItem(true);
            }
            while (lastIndex < this.breadcrumbItems.size()) {
                BreadcrumbItem item = this.breadcrumbItems.remove(this.breadcrumbItems.size() - 1);
                if (item == this.selectedItem) {
                    this.selectItem(null);
                }
                if (item.getData() != null) {
                    this.unmapElement(item.getData());
                }
                item.dispose();
            }
            this.updateSize();
            this.container.layout(true, true);
        }
        finally {
            this.enableRedraw();
        }
    }

    protected Widget doFindInputItem(Object element) {
        if (element == null) {
            return null;
        }
        if (element == this.getInput() || element.equals(this.getInput())) {
            return this.doFindItem(element);
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element == null) {
            return null;
        }
        int i = 0;
        int size = this.breadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = this.breadcrumbItems.get(i);
            if (item.getData() == element || element.equals(item.getData())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof BreadcrumbItem) {
            BreadcrumbItem item = (BreadcrumbItem)widget;
            if (fullMap) {
                this.associate(element, item);
            } else {
                Object data = item.getData();
                if (data != null) {
                    this.unmapElement(data, (Widget)item);
                }
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            BreadcrumbViewerRow row = new BreadcrumbViewerRow(this, item);
            ViewerCell cell = row.getCell(0);
            ((CellLabelProvider)this.getLabelProvider()).update(cell);
            item.refreshArrow();
            if (this.toolTipLabelProvider != null) {
                item.setToolTip(this.toolTipLabelProvider.getText(item.getData()));
            } else {
                item.setToolTip(cell.getText());
            }
        }
    }

    protected List getSelectionFromWidget() {
        if (this.selectedItem == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.selectedItem.getData() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.selectedItem.getData());
        return result;
    }

    protected void internalRefresh(Object element) {
        this.disableRedraw();
        try {
            BreadcrumbItem item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null) {
                int i = 0;
                int size = this.breadcrumbItems.size();
                while (i < size) {
                    BreadcrumbItem item1 = this.breadcrumbItems.get(i);
                    item1.refresh();
                    ++i;
                }
            } else {
                item.refresh();
            }
            if (this.updateSize()) {
                this.container.layout(true, true);
            }
        }
        finally {
            this.enableRedraw();
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        BreadcrumbItem item;
        BreadcrumbItem focusItem = null;
        int i = 0;
        int size = this.breadcrumbItems.size();
        while (i < size) {
            item = this.breadcrumbItems.get(i);
            if (item.hasFocus()) {
                focusItem = item;
            }
            item.setSelected(false);
            ++i;
        }
        if (l == null) {
            return;
        }
        for (Object element : l) {
            item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null) continue;
            item.setSelected(true);
            this.selectedItem = item;
            if (item != focusItem) continue;
            item.setFocus(true);
        }
    }

    void selectItem(BreadcrumbItem item) {
        if (this.selectedItem != null) {
            this.selectedItem.setSelected(false);
        }
        this.selectedItem = item;
        this.setSelectionToWidget(this.getSelection(), false);
        if (item != null) {
            this.setFocus();
        } else {
            int i = 0;
            int size = this.breadcrumbItems.size();
            while (i < size) {
                BreadcrumbItem listItem = this.breadcrumbItems.get(i);
                listItem.setFocus(false);
                ++i;
            }
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    int getItemCount() {
        return this.breadcrumbItems.size();
    }

    BreadcrumbItem getItem(int index) {
        return this.breadcrumbItems.get(index);
    }

    int getIndexOfItem(BreadcrumbItem item) {
        int i = 0;
        int size = this.breadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem pItem = this.breadcrumbItems.get(i);
            if (pItem == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void fireDoubleClick() {
        this.fireDoubleClick(new DoubleClickEvent((Viewer)this, this.getSelection()));
    }

    void fireOpen() {
        this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
    }

    void fireMenuSelection(Object element) {
        this.fireOpen(new OpenEvent((Viewer)this, (ISelection)new StructuredSelection(element)));
    }

    void fireMenuDetect(MenuDetectEvent event) {
        Object[] listeners = this.menuListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((MenuDetectListener)listeners[i]).menuDetected(event);
            ++i;
        }
    }

    void doTraverse(boolean next) {
        if (this.selectedItem == null) {
            return;
        }
        int index = this.breadcrumbItems.indexOf((Object)this.selectedItem);
        if (next) {
            if (index == this.breadcrumbItems.size() - 1) {
                BreadcrumbItem current = this.breadcrumbItems.get(index);
                ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
                if (!contentProvider.hasChildren(current.getData())) {
                    return;
                }
                current.openDropDownMenu();
                current.getDropDownShell().setFocus();
            } else {
                BreadcrumbItem nextItem = this.breadcrumbItems.get(index + 1);
                this.selectItem(nextItem);
            }
        } else if (index == 1) {
            BreadcrumbItem root = this.breadcrumbItems.get(0);
            root.openDropDownMenu();
            root.getDropDownShell().setFocus();
        } else {
            this.selectItem(this.breadcrumbItems.get(index - 1));
        }
    }

    private int buildItemChain(Object element) {
        BreadcrumbItem item;
        if (element == null) {
            return 0;
        }
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        Object parent = contentProvider.getParent(element);
        int index = this.buildItemChain(parent);
        if (index < this.breadcrumbItems.size()) {
            item = this.breadcrumbItems.get(index);
            if (item.getData() != null) {
                this.unmapElement(item.getData());
            }
        } else {
            item = this.createItem();
            this.breadcrumbItems.add(item);
        }
        if (this.equals(element, item.getData())) {
            this.update(element, null);
        } else {
            item.setData(element);
            item.refresh();
        }
        if (parent == null) {
            item.setDetailsVisible(false);
        }
        this.mapElement(element, (Widget)item);
        return index + 1;
    }

    private BreadcrumbItem createItem() {
        BreadcrumbItem result = new BreadcrumbItem(this, this.container);
        result.setLabelProvider((ILabelProvider)this.getLabelProvider());
        if (this.toolTipLabelProvider != null) {
            result.setToolTipLabelProvider(this.toolTipLabelProvider);
        } else {
            result.setToolTipLabelProvider((ILabelProvider)this.getLabelProvider());
        }
        result.setContentProvider((ITreeContentProvider)this.getContentProvider());
        return result;
    }

    private boolean updateSize() {
        boolean requiresLayout;
        block7: {
            int currentWidth;
            int width;
            block6: {
                width = this.container.getClientArea().width;
                currentWidth = this.getCurrentWidth();
                requiresLayout = false;
                if (currentWidth <= width) break block6;
                int index = 0;
                while (currentWidth > width && index < this.breadcrumbItems.size() - 1) {
                    BreadcrumbItem viewer = this.breadcrumbItems.get(index);
                    if (viewer.isShowText()) {
                        viewer.setShowText(false);
                        currentWidth = this.getCurrentWidth();
                        requiresLayout = true;
                    }
                    ++index;
                }
                break block7;
            }
            if (currentWidth >= width) break block7;
            int index = this.breadcrumbItems.size() - 1;
            while (currentWidth < width && index >= 0) {
                BreadcrumbItem viewer = this.breadcrumbItems.get(index);
                if (!viewer.isShowText()) {
                    viewer.setShowText(true);
                    currentWidth = this.getCurrentWidth();
                    if (currentWidth > width) {
                        viewer.setShowText(false);
                        index = 0;
                    } else {
                        requiresLayout = true;
                    }
                }
                --index;
            }
        }
        return requiresLayout;
    }

    private int getCurrentWidth() {
        int result = 0;
        int i = 0;
        int size = this.breadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem viewer = this.breadcrumbItems.get(i);
            result += viewer.getWidth();
            ++i;
        }
        return result;
    }

    private void enableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.container.setRedraw(true);
    }

    private void disableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.container.setRedraw(false);
    }

    private Image createGradientImage(int height, Display display) {
        int width = 50;
        Image result = new Image((Device)display, 50, height);
        GC gc = new GC((Drawable)result);
        Color colorC = this.createColor(22, 25, 35, display);
        Color colorD = this.createColor(22, 25, 45, display);
        Color colorE = this.createColor(22, 25, 80, display);
        Color colorF = this.createColor(22, 25, 70, display);
        Color colorG = this.createColor(22, 1, 45, display);
        Color colorH = this.createColor(18, 25, 35, display);
        try {
            this.drawLine(50, 0, colorC, gc);
            this.drawLine(50, 1, colorC, gc);
            gc.setForeground(colorD);
            gc.setBackground(colorE);
            gc.fillGradientRectangle(0, 2, 50, 10, true);
            gc.setBackground(colorE);
            gc.fillRectangle(0, 11, 50, height - 4);
            this.drawLine(50, height - 3, colorF, gc);
            this.drawLine(50, height - 2, colorG, gc);
            this.drawLine(50, height - 1, colorH, gc);
        }
        finally {
            gc.dispose();
            colorC.dispose();
            colorD.dispose();
            colorE.dispose();
            colorF.dispose();
            colorG.dispose();
            colorH.dispose();
        }
        return result;
    }

    private void drawLine(int width, int position, Color color, GC gc) {
        gc.setForeground(color);
        gc.drawLine(0, position, width, position);
    }

    private Color createColor(int color1, int color2, int ratio, Display display) {
        RGB rgb1 = display.getSystemColor(color1).getRGB();
        RGB rgb2 = display.getSystemColor(color2).getRGB();
        RGB blend = BreadcrumbViewer.blend(rgb2, rgb1, ratio);
        return new Color((Device)display, blend);
    }

    protected abstract void configureDropDownViewer(TreeViewer var1, Object var2);

    public void fillDropDownContextMenu(IMenuManager manager, Object selection) {
    }
}

