/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.internal.r.debug.ui.RDebugUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.input.SourceFragment;
import org.eclipse.statet.ltk.ui.sourceediting.SourceFragmentEditorInput;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.r.debug.core.sourcelookup.RRuntimeSourceFragment;
import org.eclipse.ui.IPersistableElement;

@NonNullByDefault
public class RRuntimeSourceEditorInput
implements SourceFragmentEditorInput {
    private final RRuntimeSourceFragment fragment;

    public RRuntimeSourceEditorInput(RRuntimeSourceFragment fragment) {
        this.fragment = (RRuntimeSourceFragment)ObjectUtils.nonNullAssert((Object)fragment);
    }

    public SourceFragment getSourceFragment() {
        return this.fragment;
    }

    public @Nullable ImageDescriptor getImageDescriptor() {
        return RDebugUIPlugin.getInstance().getImageRegistry().getDescriptor("org.eclipse.statet.r.images/obj/r_source.runtime");
    }

    public String getName() {
        return this.fragment.getName();
    }

    public boolean exists() {
        return !this.fragment.getProcess().isTerminated();
    }

    public String getToolTipText() {
        return String.valueOf(this.fragment.getFullName()) + '\n' + this.fragment.getProcess().getLabel(1);
    }

    public @Nullable IPersistableElement getPersistable() {
        return null;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == ToolProcess.class) {
            return (T)this.fragment.getProcess();
        }
        return null;
    }

    public int hashCode() {
        return this.fragment.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RRuntimeSourceEditorInput) {
            RRuntimeSourceEditorInput other = (RRuntimeSourceEditorInput)obj;
            return this.fragment.equals((Object)other.fragment);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.fragment.getFullName()) + " - " + this.fragment.getProcess().getLabel(1);
    }
}

