/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.correction;

import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CommandAssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.LinkedNamesAssistProposal;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAsts;

@NonNullByDefault
public class RLinkedNamesAssistProposal
extends LinkedNamesAssistProposal<AssistInvocationContext> {
    public static final int IN_FILE = 1;
    public static final int IN_FILE_PRECEDING = 2;
    public static final int IN_FILE_FOLLOWING = 3;
    public static final int IN_CHUNK = 4;
    private final int mode;
    private final @Nullable TextRegion region;
    private final RElementAccess access;
    private final boolean isReplFName;

    public RLinkedNamesAssistProposal(int mode, AssistInvocationContext invocationContext, RElementAccess access) {
        super(RLinkedNamesAssistProposal.init(invocationContext, mode, false));
        this.mode = mode;
        this.region = null;
        this.access = access;
        this.isReplFName = this.checkReplFName();
    }

    public RLinkedNamesAssistProposal(int mode, AssistInvocationContext invocationContext, RElementAccess access, TextRegion region) {
        super(RLinkedNamesAssistProposal.init(invocationContext, mode, true));
        this.mode = mode;
        this.region = (TextRegion)ObjectUtils.nonNullAssert((Object)region);
        this.access = access;
        this.isReplFName = this.checkReplFName();
    }

    private static CommandAssistProposal.ProposalParameters<AssistInvocationContext> init(AssistInvocationContext invocationContext, int mode, boolean withRegion) {
        switch (mode) {
            case 1: {
                return new CommandAssistProposal.ProposalParameters(invocationContext, "org.eclipse.statet.ltk.commands.QuickAssistRenameInFile", RUIMessages.Proposal_RenameInFile_label, RUIMessages.Proposal_RenameInFile_description, 90);
            }
            case 2: {
                return new CommandAssistProposal.ProposalParameters(invocationContext, "NO_COMMAND", RUIMessages.Proposal_RenameInFilePrecending_label, RUIMessages.Proposal_RenameInFilePrecending_description, 85);
            }
            case 3: {
                return new CommandAssistProposal.ProposalParameters(invocationContext, "NO_COMMAND", RUIMessages.Proposal_RenameInFileFollowing_label, RUIMessages.Proposal_RenameInFileFollowing_description, 84);
            }
            case 4: {
                if (!withRegion) {
                    throw new IllegalArgumentException();
                }
                return new CommandAssistProposal.ProposalParameters(invocationContext, "NO_COMMAND", RUIMessages.Proposal_RenameInChunk_label, RUIMessages.Proposal_RenameInChunk_description, 89);
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean checkReplFName() {
        if (this.access.getNextSegment() != null) {
            return false;
        }
        String segmentName = this.access.getSegmentName();
        return segmentName != null && segmentName.length() > 2 && segmentName.endsWith("<-");
    }

    private TextRegion getChunkRegion() {
        if (this.mode != 4) {
            throw new RuntimeException();
        }
        return (TextRegion)ObjectUtils.nonNullAssert((Object)this.region);
    }

    protected void collectPositions(IDocument document, LinkedPositionGroup group) throws BadLocationException {
        block16: {
            RAstNode nameNode;
            int idx;
            int current;
            ImIdentityList allAccess;
            block15: {
                RAstNode nameNode2;
                allAccess = ImCollections.toIdentityList((Collection)this.access.getAllInUnit(false));
                current = allAccess.indexOf((Object)this.access);
                if (current < 0) {
                    return;
                }
                idx = 0;
                RAstNode nameNode3 = (RAstNode)ObjectUtils.nonNullAssert((Object)this.access.getNameNode());
                idx = this.addPosition(group, document, nameNode3, idx);
                if (idx == 0) {
                    return;
                }
                if (this.mode == 1 || this.mode == 3) {
                    int i = current + 1;
                    while (i < allAccess.size()) {
                        nameNode2 = ((RElementAccess)allAccess.get(i)).getNameNode();
                        if (nameNode2 != null) {
                            idx = this.addPosition(group, document, nameNode2, idx);
                        }
                        ++i;
                    }
                } else if (this.mode == 4) {
                    int regionOffset = this.getChunkRegion().getEndOffset();
                    int i = current + 1;
                    while (i < allAccess.size()) {
                        nameNode = ((RElementAccess)allAccess.get(i)).getNameNode();
                        if (nameNode != null) {
                            if (regionOffset <= nameNode.getStartOffset()) break;
                            idx = this.addPosition(group, document, nameNode, idx);
                        }
                        ++i;
                    }
                }
                if (this.mode != 1 && this.mode != 2) break block15;
                int i = 0;
                while (i < current) {
                    nameNode2 = ((RElementAccess)allAccess.get(i)).getNameNode();
                    if (nameNode2 != null) {
                        idx = this.addPosition(group, document, nameNode2, idx);
                    }
                    ++i;
                }
                break block16;
            }
            if (this.mode != 4) break block16;
            int regionOffset = this.getChunkRegion().getStartOffset();
            int i = 0;
            while (i < current) {
                nameNode = ((RElementAccess)allAccess.get(i)).getNameNode();
                if (nameNode != null && regionOffset <= nameNode.getStartOffset()) {
                    idx = this.addPosition(group, document, nameNode, idx);
                }
                ++i;
            }
        }
    }

    protected int addPosition(LinkedPositionGroup group, IDocument document, RAstNode nameNode, int idx) throws BadLocationException {
        TextRegion position = RAsts.getElementNameRegion((RAstNode)nameNode);
        if (this.isReplFName && position != null && document.get(position.getStartOffset(), position.getLength()).endsWith("<-")) {
            position = new BasicTextRegion(position.getStartOffset(), position.getEndOffset() - 2);
        }
        return super.addPosition(group, document, position, idx);
    }
}

