/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.nio.file.Path;
import java.rmi.RemoteException;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.internal.rj.servi.server.RServiBackend;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.servi.node.RServiNode;

@NonNullByDefault
public abstract class NodeHandler {
    String nodeId = (String)ObjectUtils.nonNullLateInit();
    RMIAddress address = (RMIAddress)ObjectUtils.nonNullLateInit();
    Path dir = (Path)ObjectUtils.nonNullLateInit();
    protected @Nullable RServiNode node;
    @Nullable Process process;
    private @Nullable String clientLabel;
    private @Nullable RServiBackend clientHandler;
    boolean isConsoleEnabled;
    private long shutdownTime = -1L;

    public boolean isConsoleEnabled() {
        return this.isConsoleEnabled;
    }

    public void enableConsole(@Nullable String authConfig) throws RjException {
        try {
            RServiNode node = (RServiNode)ObjectUtils.nonNullAssert((Object)this.node);
            this.isConsoleEnabled = node.setConsole(authConfig);
        }
        catch (Exception e) {
            Utils.logError("An error occurred when configuring the debug console.", e);
            throw new RjException("An error occurred when configuring the debug console. See server log for detail.");
        }
    }

    public void disableConsole() throws RjException {
        this.enableConsole(null);
    }

    public @Nullable RMIAddress getAddress() {
        return this.address;
    }

    void init1(String id, RMIAddress address, Path dirPath) {
        this.nodeId = (String)ObjectUtils.nonNullAssert((Object)id);
        this.address = (RMIAddress)ObjectUtils.nonNullAssert((Object)address);
        this.dir = (Path)ObjectUtils.nonNullAssert((Object)dirPath);
    }

    void init2(RServiNode node, Process process) {
        this.node = node;
        this.process = process;
    }

    void bindClient(String name, String host) throws RemoteException {
        RServiNode node = (RServiNode)ObjectUtils.nonNullAssert((Object)this.node);
        StringBuilder sb = new StringBuilder(80);
        if (name != null) {
            sb.append(name);
        }
        sb.append('@');
        sb.append(host);
        String client = sb.toString();
        this.clientHandler = node.bindClient(client);
        this.setClientLabel(client);
    }

    void unbindClient() throws RemoteException {
        RServiNode node = (RServiNode)ObjectUtils.nonNullAssert((Object)this.node);
        this.clientHandler = null;
        this.setClientLabel(null);
        node.unbindClient();
    }

    void shutdown() throws RemoteException {
        this.shutdownTime = System.currentTimeMillis();
        this.clientHandler = null;
        this.setClientLabel(null);
        RServiNode node = this.node;
        this.node = null;
        if (node != null) {
            node.shutdown();
        }
    }

    RServiBackend getClientHandler() {
        RServiBackend clientHandler = this.clientHandler;
        if (clientHandler == null) {
            throw new IllegalStateException();
        }
        return clientHandler;
    }

    void setClientLabel(@Nullable String clientLabel) {
        this.clientLabel = clientLabel;
    }

    public @Nullable String getClientLabel() {
        return this.clientLabel;
    }

    public long getShutdownTime() {
        return this.shutdownTime;
    }
}

