/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.mpbv.ManagedPageBookView;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookSession;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.ERGraphicsManager;
import org.eclipse.statet.rj.eclient.graphics.RGraphicPage;
import org.eclipse.statet.rj.graphic.core.RGraphic;
import org.eclipse.statet.rj.ts.core.AbstractRToolRunnable;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IViewDescriptor;

@NonNullByDefault
public abstract class PageBookRGraphicView
extends ManagedPageBookView<RGraphicSession> {
    private static @Nullable ERGraphic newViewGraphic;
    private ERGraphicsManager manager;
    private final ERGraphicsManager.ListenerShowExtension managerListener = new ERGraphicsManager.ListenerShowExtension(){
        private @Nullable ERGraphic toShow;

        @Override
        public int canShowGraphic(ERGraphic graphic) {
            return PageBookRGraphicView.this.canShowGraphic(graphic);
        }

        @Override
        public void showGraphic(ERGraphic graphic) {
            this.toShow = graphic;
            IViewSite site = PageBookRGraphicView.this.getViewSite();
            try {
                site.getPage().showView(site.getId(), site.getSecondaryId(), 2);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }

        @Override
        public void graphicAdded(ERGraphic graphic) {
            PageBookRGraphicView.this.add(graphic, graphic == this.toShow || graphic.isActive() && (!PageBookRGraphicView.this.pinPage || PageBookRGraphicView.this.getCurrentSession() == null));
            this.toShow = null;
        }

        @Override
        public void graphicRemoved(ERGraphic graphic) {
            RGraphicSession session = PageBookRGraphicView.this.getSession(graphic);
            if (session != null) {
                PageBookRGraphicView.super.closePage(session);
            }
        }
    };
    private boolean pinPage;
    private final RGraphic.Listener graphicListener = new ERGraphic.ListenerLocatorExtension(){

        public void activated() {
            PageBookRGraphicView.this.updateTitle();
        }

        public void deactivated() {
            PageBookRGraphicView.this.updateTitle();
        }

        public void drawingStarted() {
        }

        public void drawingStopped() {
        }

        @Override
        public void locatorStarted() {
            PageBookRGraphicView.this.updateTitle();
        }

        @Override
        public void locatorStopped() {
            PageBookRGraphicView.this.updateTitle();
        }
    };
    private StatusLineContributionItem positionStatusLineItem;

    public void init(IViewSite site, @Nullable IMemento memento) throws PartInitException {
        this.setSessionComparator(new RGraphicComparator());
        super.init(site, memento);
        this.manager = this.loadManager();
    }

    protected abstract ERGraphicsManager loadManager();

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.manager != null) {
            RGraphicSession session;
            List<? extends ERGraphic> graphics;
            this.manager.addListener(this.managerListener);
            ERGraphic active = newViewGraphic;
            if (active != null) {
                graphics = this.manager.getAllGraphics();
                for (ERGraphic eRGraphic : graphics) {
                    this.add(eRGraphic, false);
                }
            } else {
                graphics = this.manager.getAllGraphics();
                for (ERGraphic eRGraphic : graphics) {
                    this.add(eRGraphic, false);
                    if (!eRGraphic.isActive()) continue;
                    active = eRGraphic;
                }
                if (active == null && !graphics.isEmpty()) {
                    active = graphics.get(graphics.size() - 1);
                }
            }
            if (active != null && (session = this.getSession(active)) != null) {
                this.showPage(session);
            }
        }
    }

    public @Nullable RGraphicSession getSession(ERGraphic graphic) {
        ImList sessions = this.getSessions();
        for (RGraphicSession session : sessions) {
            if (session.getGraphic() != graphic) continue;
            return session;
        }
        return null;
    }

    protected int canShowGraphic(ERGraphic graphic) {
        int canShow;
        RGraphicSession session = (RGraphicSession)this.getCurrentSession();
        if (session != null && session.getGraphic() == graphic) {
            canShow = this.pinPage ? 20 : 10;
        } else {
            if (this.pinPage && session != null) {
                return -1;
            }
            canShow = 1;
        }
        if (this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            canShow += 2;
        }
        return canShow;
    }

    protected void add(ERGraphic graphic, boolean show) {
        super.newPage((PageBookSession)new RGraphicSession(graphic), show);
    }

    protected String getNoPageTitle() {
        return "No graphics at this time.";
    }

    protected @Nullable IHandler2 createNewPageHandler() {
        return null;
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        super.initActions(serviceLocator, handlers);
        OpenAdditionalViewHandler openViewHandler = new OpenAdditionalViewHandler(this.getViewSite());
        handlers.add(".OpenView", (IHandler2)openViewHandler);
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IContributionItem)new Separator("view"));
        IViewDescriptor viewDescriptor = PlatformUI.getWorkbench().getViewRegistry().find(this.getViewSite().getId());
        menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, viewDescriptor.getImageDescriptor(), null, null, NLS.bind((String)"Open Additional {0} View", (Object)viewDescriptor.getLabel()), "O", null, 8, null, false), handlers.get(".OpenView")));
        menuManager.add((IContributionItem)new Separator("save"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.add((IContributionItem)new SimpleContributionItem("Preferences...", "P"){

            protected void execute() throws ExecutionException {
                Shell shell = PageBookRGraphicView.this.getViewSite().getShell();
                String[] preferencePages = PageBookRGraphicView.this.collectContextMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, null).open();
                }
            }
        });
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.insertAfter("page_control.change_page", (IContributionItem)new PinPageAction());
        IStatusLineManager lineManager = actionBars.getStatusLineManager();
        this.positionStatusLineItem = new StatusLineContributionItem("position", 20);
        lineManager.add((IContributionItem)this.positionStatusLineItem);
    }

    private String[] collectContextMenuPreferencePages() {
        ArrayList<String> pageIds = new ArrayList<String>();
        this.collectContextMenuPreferencePages(pageIds);
        return pageIds.toArray(new String[pageIds.size()]);
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
    }

    protected RGraphicPage doCreatePage(RGraphicSession session) {
        return new RGraphicPage(session.getGraphic());
    }

    protected void initPage(IPageBookViewPage page) {
        super.initPage(page);
        if (page instanceof RGraphicPage) {
            ((RGraphicPage)page).init(this.positionStatusLineItem);
        }
    }

    public void closePage(RGraphicSession session) {
        Status status = session.getGraphic().close();
        if (status != null && status.getSeverity() < 4) {
            return;
        }
        super.closePage((PageBookSession)session);
    }

    protected void onPageShowing(IPageBookViewPage page, RGraphicSession session) {
        if (session != null) {
            session.getGraphic().addListener(this.graphicListener);
        }
        super.onPageShowing(page, (PageBookSession)session);
    }

    protected void onPageHiding(IPageBookViewPage page, RGraphicSession session) {
        if (session != null) {
            session.getGraphic().removeListener(this.graphicListener);
        }
        if (this.positionStatusLineItem != null) {
            this.positionStatusLineItem.setText("");
        }
        super.onPageHiding(page, (PageBookSession)session);
    }

    public void dispose() {
        RGraphicSession session;
        if (this.manager != null) {
            this.manager.removeListener(this.managerListener);
        }
        if ((session = (RGraphicSession)this.getCurrentSession()) != null) {
            session.getGraphic().removeListener(this.graphicListener);
        }
        super.dispose();
    }

    protected static abstract class NewDevHandler
    extends AbstractHandler {
        protected abstract RTool getTool() throws CoreException;

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            block3: {
                try {
                    RTool tool = this.getTool();
                    if (tool != null) {
                        tool.getQueue().add((ToolRunnable)new AbstractRToolRunnable("r/rj/gd/new", "New R Graphic"){

                            public void run(RToolService r, ProgressMonitor m) throws StatusException {
                                r.evalVoid("rj::rj.GD()", m);
                            }
                        });
                    }
                }
                catch (CoreException e) {
                    if (e.getStatus().getSeverity() == 8) break block3;
                    StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.rj.eclient.graphics", "An error occurrend when creating a new graphic device.", (Throwable)e), 3);
                }
            }
            return null;
        }
    }

    private static class OpenAdditionalViewHandler
    extends AbstractHandler {
        private final IViewSite viewSite;

        public OpenAdditionalViewHandler(IViewSite viewSite) {
            this.viewSite = viewSite;
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            try {
                String secondaryId = "t" + System.currentTimeMillis();
                this.viewSite.getWorkbenchWindow().getActivePage().showView(this.viewSite.getId(), secondaryId, 1);
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.rj.eclient.graphics", "An error occurred when opening an additional R graphics view.", (Throwable)e));
            }
            return null;
        }
    }

    private class PinPageAction
    extends SimpleContributionItem {
        public PinPageAction() {
            super("Pin Graphic Page", "P", SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/pin_page"), SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctoold/pin_page"), 32);
            this.setChecked(PageBookRGraphicView.this.pinPage);
        }

        protected void execute() throws ExecutionException {
            PageBookRGraphicView.this.pinPage = !PageBookRGraphicView.this.pinPage;
            this.setChecked(PageBookRGraphicView.this.pinPage);
        }
    }

    private static class RGraphicComparator
    implements Comparator<RGraphicSession> {
        @Override
        public int compare(RGraphicSession o1, RGraphicSession o2) {
            int diff;
            RTool handle1 = o1.graphic.getRHandle();
            RTool handle2 = o2.graphic.getRHandle();
            if (handle1 == null) {
                if (handle2 == null) {
                    return 0;
                }
                return Integer.MIN_VALUE;
            }
            if (handle2 == null) {
                return Integer.MAX_VALUE;
            }
            if (handle1 != handle2 && (diff = handle1.getLabel(1).compareTo(handle2.getLabel(1))) != 0) {
                return diff;
            }
            return o1.graphic.getDevId() - o2.graphic.getDevId();
        }
    }

    public class RGraphicSession
    implements PageBookSession {
        private final ERGraphic graphic;

        public RGraphicSession(ERGraphic graphic) {
            this.graphic = graphic;
        }

        public String getLabel() {
            return this.graphic.getLabel();
        }

        public @Nullable ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromImage((Image)PageBookRGraphicView.this.getTitleImage());
        }

        public ERGraphic getGraphic() {
            return this.graphic;
        }
    }

    public static class ShowRequiredViewListener
    implements ERGraphicsManager.ListenerShowExtension {
        private final String viewId;

        public ShowRequiredViewListener(String viewId) {
            this.viewId = viewId;
        }

        @Override
        public int canShowGraphic(ERGraphic graphic) {
            return 0;
        }

        private static String getId(IViewReference ref) {
            String id = ref.getId();
            int idx = id.indexOf(58);
            return idx >= 0 ? id.substring(0, idx) : id;
        }

        @Override
        public void showGraphic(ERGraphic graphic) {
            try {
                try {
                    IWorkbenchPage page = this.getBestPage(graphic);
                    String secondaryId = "";
                    IViewReference[] refs = page.getViewReferences();
                    int i = 0;
                    while (i < refs.length) {
                        if (this.viewId.equals(ShowRequiredViewListener.getId(refs[i])) && refs[i].getView(false) == null) {
                            if (refs[i].getSecondaryId() == null) {
                                secondaryId = null;
                                break;
                            }
                            if (secondaryId == "") {
                                secondaryId = refs[i].getSecondaryId();
                            }
                        }
                        ++i;
                    }
                    if (secondaryId == "") {
                        secondaryId = "t" + System.currentTimeMillis();
                    }
                    newViewGraphic = graphic;
                    page.showView(this.viewId, secondaryId, 2);
                }
                catch (PartInitException e) {
                    StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.rj.eclient.graphics", "An error occurred when opening a new R Graphics view.", (Throwable)e));
                    newViewGraphic = null;
                }
            }
            finally {
                newViewGraphic = null;
            }
        }

        protected IWorkbenchPage getBestPage(ERGraphic graphic) {
            return UIAccess.getActiveWorkbenchPage((boolean)true);
        }

        @Override
        public void graphicAdded(ERGraphic graphic) {
        }

        @Override
        public void graphicRemoved(ERGraphic graphic) {
        }
    }
}

