/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.rdata;

import java.io.IOException;
import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.internal.r.rdata.CombinedFactory;
import org.eclipse.statet.internal.r.rdata.RListVar;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;

@NonNullByDefault
public final class RDataFrameVar
extends RListVar
implements RDataFrame,
ExternalizableRObject {
    private final long rowCount;

    public RDataFrameVar(RJIO io, CombinedFactory factory, int options, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) throws IOException {
        super(io, factory, options, parent, name);
        this.rowCount = io.readLong();
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        boolean options = false;
        super.doWriteExternal(io, factory, 0);
        io.writeLong(this.rowCount);
    }

    @Override
    public byte getRObjectType() {
        return 6;
    }

    @Override
    protected String getDefaultRClassName() {
        return "data.frame";
    }

    public long getColumnCount() {
        return this.getLength();
    }

    public RCharacterStore getColumnNames() {
        return this.getNames();
    }

    public RStore<?> getColumn(int idx) {
        return this.get(idx).getData();
    }

    public RStore<?> getColumn(long idx) {
        return this.get(idx).getData();
    }

    public @Nullable RStore getColumn(String name) {
        CombinedRElement obj = this.get(name);
        return obj != null ? obj.getData() : null;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public @Nullable RStore<?> getRowNames() {
        return null;
    }
}

