/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.renv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.internal.r.core.Messages;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.renv.ActualREnv;
import org.eclipse.statet.internal.r.core.renv.AliasREnv;
import org.eclipse.statet.internal.r.core.renv.REnvConfigurationImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.core.renv.IREnvManager;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.rsetups.RSetup;
import org.eclipse.statet.rj.rsetups.RSetupUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class REnvManagerImpl
implements IREnvManager {
    private static final String USER_ENV_PREFIX = "user-";
    private static final String USER_LOCAL_ID_PREFIX = "user-local-";
    private static final String USER_REMOTE_ID_PREFIX = "user-remote-";
    private static final String CONTRIB_TEMP_REMOTE_ENV_ID_PREFIX = "contrib.temp-remote-";
    private static final Preference.StringPref PREF_DEFAULT_CONFIGURATION_NAME = new Preference.StringPref("org.eclipse.statet.r.core/r.environments", "default_configuration.name");
    private static final Preference.IntPref PREF_VERSION = new Preference.IntPref("org.eclipse.statet.r.core/r.environments", "version");
    private static final Preference.LongPref STAMP_PREF = new Preference.LongPref("org.eclipse.statet.r.core/r.environments", "stamp");
    private volatile int state = 0;
    private final ReadWriteLock lock;
    private Map<String, REnvConfigurationImpl> idMap;
    private final AliasREnv defaultEnv = new AliasREnv("default-workbench");

    private static @Nullable REnv getActualREnv(REnv rEnv) {
        IREnvConfiguration config = (IREnvConfiguration)rEnv.get(IREnvConfiguration.class);
        return config != null ? config.getREnv() : null;
    }

    public REnvManagerImpl() {
        this.lock = new ReentrantReadWriteLock(true);
    }

    @Override
    public Lock getReadLock() {
        return this.lock.readLock();
    }

    public void dispose() {
        this.lock.writeLock().lock();
        try {
            this.state = 2;
            if (this.idMap != null) {
                this.idMap.clear();
                this.idMap = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndLock(boolean writeLock) {
        if (this.state < 1) {
            REnvManagerImpl rEnvManagerImpl = this;
            synchronized (rEnvManagerImpl) {
                try {
                    if (this.state < 1) {
                        this.load();
                        this.state = 1;
                    }
                }
                catch (BackingStoreException e) {
                    this.state = 101;
                    RCorePlugin.logError(Messages.REnvManager_error_Accessing_message, e);
                }
            }
        }
        if (writeLock) {
            this.lock.writeLock().lock();
        } else {
            this.lock.readLock().lock();
        }
        if (this.state > 1) {
            throw new IllegalStateException(Messages.REnvManager_error_Dispose_message);
        }
    }

    private boolean update(ImList<IREnvConfiguration> configs, String defaultREnvId) {
        HashSet<String> newREnvs = new HashSet<String>();
        for (IREnvConfiguration config : configs) {
            newREnvs.add(config.getREnv().getId());
        }
        HashSet<String> oldIds = new HashSet<String>(this.idMap.keySet());
        boolean changed = false;
        for (IREnvConfiguration config : configs) {
            changed = this.doAdd(config, changed);
            REnv rEnv = config.getREnv();
            oldIds.remove(rEnv.getId());
        }
        for (String id : oldIds) {
            changed = this.doDelete(id, changed);
        }
        changed = this.doSetDefault(defaultREnvId, changed);
        return changed;
    }

    private boolean doAdd(IREnvConfiguration config, boolean changed) {
        REnvConfigurationImpl newConfig = new REnvConfigurationImpl(config);
        ActualREnv rEnv = (ActualREnv)newConfig.getREnv();
        IREnvConfiguration oldConfig = this.idMap.put(rEnv.getId(), newConfig);
        rEnv.name = newConfig.getName();
        rEnv.config = newConfig;
        if (!changed && !Objects.equals(oldConfig, newConfig)) {
            changed = true;
        }
        return changed;
    }

    private boolean doDelete(String id, boolean changed) {
        REnvConfigurationImpl rEnvConfig = this.idMap.remove(id);
        if (rEnvConfig != null) {
            ActualREnv rEnv = (ActualREnv)rEnvConfig.getREnv();
            rEnv.isDeleted = true;
            changed |= true;
        }
        return changed;
    }

    private boolean doSetDefault(String id, boolean changed) {
        REnv oldDefault = REnvManagerImpl.getActualREnv(this.defaultEnv);
        this.updateDefault(id);
        REnv newDefault = REnvManagerImpl.getActualREnv(this.defaultEnv);
        if (!changed && !Objects.equals(oldDefault, newDefault)) {
            changed = true;
        }
        return changed;
    }

    private boolean doRefreshDefault(boolean changed) {
        REnv oldDefault = REnvManagerImpl.getActualREnv(this.defaultEnv);
        this.updateDefault(oldDefault != null ? oldDefault.getId() : null);
        REnv newDefault = REnvManagerImpl.getActualREnv(this.defaultEnv);
        if (!changed && !Objects.equals(oldDefault, newDefault)) {
            changed = true;
        }
        return changed;
    }

    private void updateDefault(String defaultConfigId) {
        REnv rEnv;
        String name;
        IREnvConfiguration rEnvConfig = null;
        if (defaultConfigId != null && !defaultConfigId.isEmpty()) {
            rEnvConfig = this.idMap.get(defaultConfigId);
        }
        if (rEnvConfig != null) {
            name = rEnvConfig.getName();
            rEnv = rEnvConfig.getREnv();
        } else if (this.idMap.size() > 0) {
            name = Messages.REnvManager_status_NoDefault_label;
            rEnv = null;
        } else {
            name = Messages.REnvManager_status_NotAny_label;
            rEnv = null;
        }
        this.defaultEnv.name = name;
        this.defaultEnv.link = rEnv;
    }

    private void load() throws BackingStoreException {
        this.idMap = new HashMap<String, REnvConfigurationImpl>();
        this.loadFromRegistry();
        this.loadFromWorkspace();
    }

    private void loadFromWorkspace() throws BackingStoreException {
        PreferenceAccess prefs = PreferenceUtils.getInstancePrefs();
        ArrayList configs = new ArrayList();
        Integer version = (Integer)prefs.getPreferenceValue((Preference)PREF_VERSION);
        if (version == null || version == 0) {
            Iterator iter = prefs.getPreferenceContexts().iterator();
            while (configs.isEmpty() && iter.hasNext()) {
                String[] names;
                IEclipsePreferences prefNode = ((IScopeContext)iter.next()).getNode("org.eclipse.statet.r.core/r.environments");
                if (prefNode == null) continue;
                String[] stringArray = names = prefNode.childrenNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    ActualREnv rEnv;
                    REnvConfigurationImpl config;
                    String name = stringArray[n2];
                    Preferences node = prefNode.node(name);
                    String id = node.get("id", null);
                    if (id != null && id.length() > 0 && id.startsWith(USER_ENV_PREFIX) && (config = new REnvConfigurationImpl(null, rEnv = new ActualREnv(id), prefs, name)).getName() != null) {
                        config.upgradePref();
                        rEnv.name = config.getName();
                        rEnv.config = config;
                        this.idMap.put(id, config);
                    }
                    ++n2;
                }
            }
        } else if (version == 2) {
            Iterator iter = prefs.getPreferenceContexts().iterator();
            while (configs.isEmpty() && iter.hasNext()) {
                String[] names;
                IEclipsePreferences prefNode = ((IScopeContext)iter.next()).getNode("org.eclipse.statet.r.core/r.environments");
                if (prefNode == null) continue;
                String[] stringArray = names = prefNode.childrenNames();
                int n = names.length;
                int n3 = 0;
                while (n3 < n) {
                    ActualREnv rEnv;
                    REnvConfigurationImpl config;
                    String id = stringArray[n3];
                    if (id != null && id.length() > 0 && id.startsWith(USER_ENV_PREFIX) && (config = new REnvConfigurationImpl(null, rEnv = new ActualREnv(id), prefs, null)).getName() != null) {
                        rEnv.name = config.getName();
                        rEnv.config = config;
                        this.idMap.put(id, config);
                    }
                    ++n3;
                }
            }
        }
        this.updateDefault((String)prefs.getPreferenceValue((Preference)PREF_DEFAULT_CONFIGURATION_NAME));
    }

    private void saveToWorkspace(boolean envPrefs) throws BackingStoreException {
        REnv rEnv;
        IScopeContext context = (IScopeContext)PreferenceUtils.getInstancePrefs().getPreferenceContexts().get(0);
        IEclipsePreferences node = context.getNode("org.eclipse.statet.r.core/r.environments");
        HashMap map = new HashMap();
        map.put((Preference<?>)PREF_VERSION, 2);
        map.put((Preference<?>)STAMP_PREF, System.currentTimeMillis());
        if (envPrefs) {
            ArrayList<String> oldNames = new ArrayList<String>(Arrays.asList(node.childrenNames()));
            oldNames.removeAll(this.idMap.keySet());
            for (String string : oldNames) {
                if (!node.nodeExists(string)) continue;
                node.node(string).removeNode();
            }
            for (IREnvConfiguration iREnvConfiguration : this.idMap.values()) {
                if (!(iREnvConfiguration instanceof REnvConfigurationImpl) || iREnvConfiguration.getType().startsWith("contrib.temp-")) continue;
                ((REnvConfigurationImpl)iREnvConfiguration).deliverToPreferencesMap(map);
            }
        }
        map.put((Preference<?>)PREF_DEFAULT_CONFIGURATION_NAME, (rEnv = REnvManagerImpl.getActualREnv(this.defaultEnv)) != null ? rEnv.getId() : null);
        PreferenceUtils.setPrefValues((IScopeContext)InstanceScope.INSTANCE, map);
        node.flush();
    }

    private void loadFromRegistry() {
        PreferenceAccess prefs = PreferenceUtils.getInstancePrefs();
        List setups = RSetupUtil.loadAvailableSetups(null);
        for (RSetup setup : setups) {
            ActualREnv rEnv = new ActualREnv("eplugin-local-" + setup.getId());
            REnvConfigurationImpl config = new REnvConfigurationImpl("eplugin-local", rEnv, setup, prefs);
            rEnv.name = config.getName();
            rEnv.config = config;
            this.idMap.put(rEnv.getId(), config);
        }
    }

    private void onChanged(boolean envPrefs) throws BackingStoreException {
        PreferenceSetService preferenceSetService = PreferenceUtils.getPreferenceSetService();
        String sourceId = "REnv" + System.identityHashCode(this);
        boolean resume = preferenceSetService.pause(sourceId);
        try {
            this.saveToWorkspace(envPrefs);
            return;
        }
        finally {
            if (resume) {
                preferenceSetService.resume(sourceId);
            }
        }
    }

    @Override
    public void set(ImList<IREnvConfiguration> configs, String defaultConfigId) throws CoreException {
        this.checkAndLock(true);
        try {
            boolean changed = this.update(configs, defaultConfigId);
            if (!changed) {
                return;
            }
            try {
                this.onChanged(true);
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, Messages.REnvManager_error_Saving_message, (Throwable)e));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void add(@NonNull REnvConfiguration rEnvConfig) {
        REnv rEnv = rEnvConfig.getREnv();
        if (!rEnv.getId().startsWith(CONTRIB_TEMP_REMOTE_ENV_ID_PREFIX)) {
            throw new IllegalArgumentException();
        }
        this.checkAndLock(true);
        try {
            boolean changed = false;
            changed = this.doAdd((IREnvConfiguration)rEnvConfig, changed);
            if (!changed) {
                return;
            }
            try {
                changed = this.doRefreshDefault(changed);
                this.onChanged(false);
            }
            catch (BackingStoreException e) {
                RCorePlugin.logError(Messages.REnvManager_error_Saving_message, e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void delete(@NonNull REnv rEnv) {
        if (!rEnv.getId().startsWith(CONTRIB_TEMP_REMOTE_ENV_ID_PREFIX)) {
            throw new IllegalArgumentException();
        }
        this.checkAndLock(true);
        try {
            boolean changed = false;
            changed = this.doDelete(rEnv.getId(), changed);
            if (!changed) {
                return;
            }
            try {
                changed = this.doRefreshDefault(changed);
                this.onChanged(false);
            }
            catch (BackingStoreException e) {
                RCorePlugin.logError(Messages.REnvManager_error_Saving_message, e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ImList<REnv> list() {
        ArrayList<REnvConfigurationImpl> configList;
        this.checkAndLock(false);
        try {
            configList = new ArrayList<REnvConfigurationImpl>(this.idMap.values());
        }
        finally {
            this.lock.readLock().unlock();
        }
        Object[] list = new REnv[configList.size()];
        int i = 0;
        for (IREnvConfiguration iREnvConfiguration : configList) {
            REnv rEnv = iREnvConfiguration.getREnv();
            if (rEnv.isDeleted()) continue;
            list[i++] = rEnv;
        }
        return ImCollections.newList((Object[])list, (int)0, (int)i);
    }

    @Override
    public List<IREnvConfiguration> getConfigurations() {
        ArrayList<IREnvConfiguration> list;
        this.checkAndLock(false);
        try {
            list = new ArrayList<IREnvConfiguration>(this.idMap.values());
        }
        finally {
            this.lock.readLock().unlock();
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!((IREnvConfiguration)iter.next()).getREnv().isDeleted()) continue;
            iter.remove();
        }
        return list;
    }

    public String[] getIds() {
        this.checkAndLock(false);
        try {
            Set<String> keys = this.idMap.keySet();
            String[] stringArray = keys.toArray(new String[keys.size()]);
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public synchronized @Nullable REnv get(String id, String name) {
        this.checkAndLock(false);
        try {
            REnv rEnv;
            if (id != null && (rEnv = this.getEnv(id)) != null) {
                REnv rEnv2 = rEnv;
                return rEnv2;
            }
            if (name != null) {
                REnv rEnv3 = this.getEnvByName(name);
                return rEnv3;
            }
            return null;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private @Nullable REnv getEnv(String id) {
        if (id.equals("default-workbench")) {
            return this.defaultEnv;
        }
        IREnvConfiguration config = this.idMap.get(id);
        if (config == null) {
            config = this.idMap.get(id);
        }
        if (config != null) {
            return config.getREnv();
        }
        return null;
    }

    private @Nullable REnv getEnvByName(String name) {
        for (REnvConfiguration rEnvConfiguration : this.idMap.values()) {
            if (!rEnvConfiguration.getName().equals(name)) continue;
            return rEnvConfiguration.getREnv();
        }
        return null;
    }

    @Override
    public REnv getDefault() {
        this.checkAndLock(false);
        try {
            AliasREnv aliasREnv = this.defaultEnv;
            return aliasREnv;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public IREnvConfiguration.WorkingCopy newConfiguration(String type) {
        return new REnvConfigurationImpl.Editable(type, this.newLink(type));
    }

    private ActualREnv newLink(String type) {
        return new ActualREnv(String.valueOf(type) + '-' + Long.toString((long)System.getProperty("user.name").hashCode() << 32 | System.currentTimeMillis(), 36));
    }
}

