/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.statet.internal.r.debug.ui.launcher.RSourceCodeAdapter;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.launching.ICodeSubmitContentHandler;
import org.eclipse.statet.r.launching.RCodeLaunching;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class SubmitUptoSelectionHandler
extends AbstractHandler
implements IElementUpdater {
    private final boolean fGotoConsole;
    private RRefactoringAdapter fModelUtil;

    public SubmitUptoSelectionHandler() {
        this(false);
    }

    protected SubmitUptoSelectionHandler(boolean gotoConsole) {
        this.fGotoConsole = gotoConsole;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    protected String appendVariant(String label) {
        return label;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SourceStructElement[] elements;
        IProgressMonitor progress;
        String contentTypeId;
        ISelection selection;
        block7: {
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
            contentTypeId = LTKWorkbenchUIUtil.getContentTypeId((IWorkbenchPart)activePart);
            try {
                progress = null;
                if (!(selection instanceof ITextSelection)) break block7;
                ITextSelection textSelection = (ITextSelection)selection;
                List<String> lines = null;
                AbstractDocument document = LTKWorkbenchUIUtil.getDocument((IWorkbenchPart)activePart);
                if (document != null) {
                    ICodeSubmitContentHandler contentHandler = RCodeLaunching.getCodeSubmitContentHandler(contentTypeId);
                    lines = contentHandler.getCodeLines((IDocument)document, 0, textSelection.getOffset());
                } else {
                    lines = LaunchShortcutUtil.getSelectedCodeLines(event);
                }
                if (lines != null) {
                    RCodeLaunching.runRCodeDirect(lines, this.fGotoConsole, progress);
                }
                return null;
            }
            catch (Exception e) {
                LaunchShortcutUtil.handleRLaunchException(e, RLaunchingMessages.RSelectionLaunch_error_message, event);
                return null;
            }
        }
        if (selection instanceof IStructuredSelection && (elements = LTKSelectionUtils.getSelectedSourceStructElements((ISelection)selection)) != null && elements.length == 1) {
            List<String> lines = this.getCodeLinesUpto(elements[0], contentTypeId, progress);
            RCodeLaunching.runRCodeDirect(lines, this.fGotoConsole, progress);
            return null;
        }
        LaunchShortcutUtil.handleUnsupportedExecution(event);
        return null;
    }

    protected List<String> getCodeLinesUpto(SourceStructElement element, String contentTypeId, IProgressMonitor monitor) throws BadLocationException, BadPartitioningException, CoreException {
        SourceUnit su = element.getSourceUnit();
        if (su == null) {
            return null;
        }
        if (this.fModelUtil == null) {
            this.fModelUtil = new RSourceCodeAdapter();
        }
        su.connect(monitor);
        try {
            AbstractDocument document = su.getDocument(monitor);
            RHeuristicTokenScanner scanner = this.fModelUtil.getScanner(su);
            TextRegion range = this.fModelUtil.expandElementRange((SourceElement)element, document, (BasicHeuristicTokenScanner)scanner);
            if (range == null) {
                return null;
            }
            ICodeSubmitContentHandler contentHandler = RCodeLaunching.getCodeSubmitContentHandler(contentTypeId);
            List<String> list = contentHandler.getCodeLines((IDocument)document, 0, range.getStartOffset());
            return list;
        }
        finally {
            su.disconnect(monitor);
        }
    }
}

