/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.math.MathContext;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;
import org.eclipse.statet.ecommons.waltable.data.ControlData;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.rj.data.RCharacterStore;

public class RDataFormatter {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;
    private final StringBuilder fCurrentText = new StringBuilder();
    private DecimalFormat fNumFormat;
    private int fNumMaxExpDigits;
    private MathContext fMathContext;
    private DateFormat fDateFormat;
    private long fDateValueMillis;
    private RCharacterStore fFactorLevels;
    private int fAutoWidth = -1;

    protected void clean() {
        this.fNumFormat = null;
        this.fMathContext = null;
        this.fDateFormat = null;
        this.fFactorLevels = null;
    }

    protected void appendByteHexFormat(int b) {
        this.fCurrentText.append(HEX_CHARS[b >> 2 & 0xF]);
        this.fCurrentText.append(HEX_CHARS[b & 0xF]);
    }

    protected void appendNum(double num) {
        if (Double.isNaN(num) || Double.isInfinite(num)) {
            this.fCurrentText.append(this.fNumFormat.format(num));
            return;
        }
        BigDecimal decimal = new BigDecimal(num);
        if (this.fMathContext != null) {
            decimal = decimal.multiply(BigDecimal.ONE, this.fMathContext);
        }
        this.fCurrentText.append(this.fNumFormat.format(decimal));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object modelToDisplayValue(Object modelValue) {
        if (modelValue == null) {
            return AbstractRDataProvider.NA;
        }
        Class<?> clazz = modelValue.getClass();
        if (clazz == ControlData.class) {
            return modelValue;
        }
        if (clazz == Double.class) {
            if (this.fNumFormat != null) {
                this.fCurrentText.setLength(0);
                this.appendNum((Double)modelValue);
                return this.fCurrentText.toString();
            }
            if (this.fDateFormat != null) {
                return this.fDateFormat.format(new Date((long)((Double)modelValue).doubleValue() * this.fDateValueMillis));
            }
        }
        if (clazz == Boolean.class) {
            if ((Boolean)modelValue == false) return "FALSE";
            return "TRUE";
        }
        if (clazz == Integer.class) {
            if (this.fFactorLevels != null) {
                int value = (Integer)modelValue - 1;
                if (value < 0) return new ControlData(1, "?" + modelValue + "?");
                if ((long)value >= this.fFactorLevels.getLength()) return new ControlData(1, "?" + modelValue + "?");
                modelValue = this.fFactorLevels.getChar(value);
            } else {
                if (this.fDateFormat == null) return modelValue.toString();
                return this.fDateFormat.format(new Date((long)((Integer)modelValue).intValue() * this.fDateValueMillis));
            }
        }
        if (clazz == String.class) {
            String text = (String)modelValue;
            this.fCurrentText.setLength(0);
            int beginIdx = 0;
            int i = 0;
            int length = text.length();
            while (i < length) {
                char c = text.charAt(i);
                switch (c) {
                    case '\n': {
                        if (i > beginIdx) {
                            this.fCurrentText.append(text, beginIdx, i);
                        }
                        this.fCurrentText.append("\\n");
                        beginIdx = ++i;
                        break;
                    }
                    case '\r': {
                        if (i > beginIdx) {
                            this.fCurrentText.append(text, beginIdx, i);
                        }
                        this.fCurrentText.append("\\r");
                        beginIdx = ++i;
                        break;
                    }
                    case '\t': {
                        if (i > beginIdx) {
                            this.fCurrentText.append(text, beginIdx, i);
                        }
                        this.fCurrentText.append("\\t");
                        beginIdx = ++i;
                        break;
                    }
                    case '\b': {
                        if (i > beginIdx) {
                            this.fCurrentText.append(text, beginIdx, i);
                        }
                        this.fCurrentText.append("\\b");
                        beginIdx = ++i;
                        break;
                    }
                    case '\u0007': {
                        if (i > beginIdx) {
                            this.fCurrentText.append(text, beginIdx, i);
                        }
                        this.fCurrentText.append("\\a");
                        beginIdx = ++i;
                        break;
                    }
                    case '\f': {
                        if (i > beginIdx) {
                            this.fCurrentText.append(text, beginIdx, i);
                        }
                        this.fCurrentText.append("\\f");
                        beginIdx = ++i;
                        break;
                    }
                    case '\u000b': {
                        if (i > beginIdx) {
                            this.fCurrentText.append(text, beginIdx, i);
                        }
                        this.fCurrentText.append("\\v");
                        beginIdx = ++i;
                        break;
                    }
                    case '\\': {
                        if (i > beginIdx) {
                            this.fCurrentText.append(text, beginIdx, i);
                        }
                        this.fCurrentText.append("\\\\");
                        beginIdx = ++i;
                        break;
                    }
                    default: {
                        if (c < ' ') {
                            if (i > beginIdx) {
                                this.fCurrentText.append(text, beginIdx, i);
                            }
                            this.fCurrentText.append("\\0x");
                            this.appendByteHexFormat(c);
                            beginIdx = ++i;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (beginIdx <= 0) return text;
            if (beginIdx >= length) return this.fCurrentText.toString();
            this.fCurrentText.append(text, beginIdx, length);
            return this.fCurrentText.toString();
        }
        if (clazz != Byte.class) return modelValue;
        this.fCurrentText.setLength(0);
        this.appendByteHexFormat(((Byte)modelValue).intValue());
        return this.fCurrentText.toString();
    }

    public boolean hasNumFormat() {
        return this.fNumFormat != null;
    }

    public int getMaxFractionalDigits() {
        return this.fNumFormat.getMaximumFractionDigits();
    }

    public int getMaxExponentDigits() {
        return this.fNumMaxExpDigits;
    }

    public void initNumFormat(int maxFractionalDigits, int maxExponentDigits) {
        DecimalFormat decimalFormat;
        this.clean();
        this.fNumMaxExpDigits = maxExponentDigits;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
        symbols.setExponentSeparator("e");
        symbols.setNaN("NaN");
        symbols.setInfinity("Inf");
        this.fNumFormat = decimalFormat = new DecimalFormat("0.", symbols);
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setExponentSignAlwaysShown(true);
        decimalFormat.setSignificantDigitsUsed(false);
        decimalFormat.setMinimumFractionDigits(maxFractionalDigits);
        decimalFormat.setMaximumFractionDigits(maxFractionalDigits);
        if (maxExponentDigits > 0) {
            this.fMathContext = new MathContext(maxFractionalDigits + 1, 1, false, 4);
            decimalFormat.setScientificNotation(true);
            decimalFormat.setMinimumExponentDigits((byte)maxExponentDigits);
        } else {
            decimalFormat.setScientificNotation(false);
            decimalFormat.setRoundingMode(4);
            decimalFormat.setRoundingIncrement(BigDecimal.valueOf((long)1L, (int)maxFractionalDigits));
        }
    }

    public void initDateFormat(int millis) {
        this.clean();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.fDateFormat = dateFormat;
        this.fDateValueMillis = millis;
        this.fDateFormat.setCalendar(Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"UTC"), (ULocale)ULocale.ENGLISH));
    }

    public void initDateTimeFormat(int millis) {
        this.clean();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zz");
        this.fDateFormat = dateFormat;
        this.fDateValueMillis = millis;
    }

    public void setDateTimeZone(TimeZone zone) {
        if (this.fDateFormat == null) {
            throw new IllegalStateException();
        }
        this.fDateFormat.setTimeZone(zone);
    }

    public void initFactorLevels(RCharacterStore levels) {
        this.clean();
        this.fFactorLevels = levels;
    }

    public RCharacterStore getFactorLevels() {
        return this.fFactorLevels;
    }

    public void setAutoWidth(int width) {
        this.fAutoWidth = width;
    }

    public int getAutoWidth() {
        return this.fAutoWidth;
    }
}

