/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

@NonNullByDefault
public class ExtStyledText
extends StyledText {
    private @Nullable Color customBackgroundColor;
    private @Nullable Color customForegroundColor;
    private boolean inSetEnabled;

    public ExtStyledText(Composite parent, int style) {
        super(parent, style);
    }

    public void setEnabled(boolean enabled) {
        this.inSetEnabled = true;
        try {
            if (enabled) {
                super.setEnabled(true);
                this.applyCustomBackgroundColor();
                this.applyCustomForegroundColor();
            } else {
                super.setBackground(null);
                super.setForeground(null);
                super.setEnabled(false);
            }
        }
        finally {
            this.inSetEnabled = false;
        }
    }

    public void setBackground(@Nullable Color color) {
        if (this.inSetEnabled) {
            super.setBackground(color);
        } else {
            this.customBackgroundColor = color;
            if (this.isEnabled()) {
                this.applyCustomBackgroundColor();
            }
        }
    }

    private void applyCustomBackgroundColor() {
        super.setBackground(this.customBackgroundColor);
        if (this.customBackgroundColor == null) {
            super.setBackground(this.getBackground());
        }
    }

    public void setForeground(@Nullable Color color) {
        if (this.inSetEnabled) {
            super.setForeground(color);
        } else {
            this.customForegroundColor = color;
            if (this.isEnabled()) {
                this.applyCustomForegroundColor();
            }
        }
    }

    private void applyCustomForegroundColor() {
        super.setForeground(this.customForegroundColor);
        if (this.customForegroundColor == null) {
            super.setForeground(this.getForeground());
        }
    }
}

