/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;

abstract class TableOperatorNode
extends FromTable {
    ResultSetNode leftResultSet;
    ResultSetNode rightResultSet;
    Optimizer leftOptimizer;
    Optimizer rightOptimizer;
    private boolean leftModifyAccessPathsDone;
    private boolean rightModifyAccessPathsDone;

    TableOperatorNode(ResultSetNode resultSetNode, ResultSetNode resultSetNode2, Properties properties, ContextManager contextManager) throws StandardException {
        super(null, properties, contextManager);
        this.leftResultSet = resultSetNode;
        this.rightResultSet = resultSetNode2;
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        this.leftResultSet.bindUntypedNullsToResultColumns(resultColumnList);
        this.rightResultSet.bindUntypedNullsToResultColumns(resultColumnList);
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        boolean bl = false;
        if (this.leftResultSet instanceof FromTable) {
            if (this.leftOptimizer != null) {
                this.leftOptimizer.modifyAccessPaths();
                this.leftResultSet = (ResultSetNode)((Object)this.leftOptimizer.getOptimizable(0));
            } else {
                this.leftResultSet = (ResultSetNode)((Object)((FromTable)this.leftResultSet).modifyAccessPath(jBitSet));
            }
            this.leftModifyAccessPathsDone = true;
        } else {
            bl = true;
        }
        if (this.rightResultSet instanceof FromTable) {
            if (this.rightOptimizer != null) {
                this.rightOptimizer.modifyAccessPaths();
                this.rightResultSet = (ResultSetNode)((Object)this.rightOptimizer.getOptimizable(0));
            } else {
                this.rightResultSet = (ResultSetNode)((Object)((FromTable)this.rightResultSet).modifyAccessPath(jBitSet));
            }
            this.rightModifyAccessPathsDone = true;
        } else {
            bl = true;
        }
        if (bl) {
            return (Optimizable)((Object)this.modifyAccessPaths());
        }
        return this;
    }

    @Override
    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        if (this.leftResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.leftResultSet)).verifyProperties(dataDictionary);
        }
        if (this.rightResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.rightResultSet)).verifyProperties(dataDictionary);
        }
        super.verifyProperties(dataDictionary);
    }

    @Override
    public void updateBestPlanMap(short s, Object object) throws StandardException {
        super.updateBestPlanMap(s, object);
        if (this.leftResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.leftResultSet)).updateBestPlanMap(s, object);
        } else if (this.leftResultSet.getOptimizerImpl() != null) {
            this.leftResultSet.getOptimizerImpl().updateBestPlanMaps(s, object);
        }
        if (this.rightResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.rightResultSet)).updateBestPlanMap(s, object);
        } else if (this.rightResultSet.getOptimizerImpl() != null) {
            this.rightResultSet.getOptimizerImpl().updateBestPlanMaps(s, object);
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    ResultSetNode getLeftResultSet() {
        return this.leftResultSet;
    }

    ResultSetNode getRightResultSet() {
        return this.rightResultSet;
    }

    ResultSetNode getLeftmostResultSet() {
        if (this.leftResultSet instanceof TableOperatorNode) {
            return ((TableOperatorNode)this.leftResultSet).getLeftmostResultSet();
        }
        return this.leftResultSet;
    }

    void setLeftmostResultSet(ResultSetNode resultSetNode) {
        if (this.leftResultSet instanceof TableOperatorNode) {
            ((TableOperatorNode)this.leftResultSet).setLeftmostResultSet(resultSetNode);
        } else {
            this.leftResultSet = resultSetNode;
        }
    }

    @Override
    void setLevel(int n) {
        super.setLevel(n);
        if (this.leftResultSet instanceof FromTable) {
            ((FromTable)this.leftResultSet).setLevel(n);
        }
        if (this.rightResultSet instanceof FromTable) {
            ((FromTable)this.rightResultSet).setLevel(n);
        }
    }

    @Override
    String getExposedName() {
        return null;
    }

    void setNestedInParens(boolean bl) {
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        this.leftResultSet = this.leftResultSet.bindNonVTITables(dataDictionary, fromList);
        this.rightResultSet = this.rightResultSet.bindNonVTITables(dataDictionary, fromList);
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    @Override
    ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        this.leftResultSet = this.leftResultSet.bindVTITables(fromList);
        this.rightResultSet = this.rightResultSet.bindVTITables(fromList);
        return this;
    }

    @Override
    void bindExpressions(FromList fromList) throws StandardException {
        if (!(this instanceof UnionNode) || !((UnionNode)this).tableConstructor()) {
            this.leftResultSet.rejectParameters();
            this.rightResultSet.rejectParameters();
        }
        this.leftResultSet.bindExpressions(fromList);
        this.rightResultSet.bindExpressions(fromList);
    }

    @Override
    void rejectParameters() throws StandardException {
        this.leftResultSet.rejectParameters();
        this.rightResultSet.rejectParameters();
    }

    @Override
    void bindExpressionsWithTables(FromList fromList) throws StandardException {
        if (!(this instanceof UnionNode) || !((UnionNode)this).tableConstructor()) {
            this.leftResultSet.rejectParameters();
            this.rightResultSet.rejectParameters();
        }
        this.leftResultSet.bindExpressionsWithTables(fromList);
        this.rightResultSet.bindExpressionsWithTables(fromList);
    }

    @Override
    void bindResultColumns(FromList fromList) throws StandardException {
        this.leftResultSet.bindResultColumns(fromList);
        this.rightResultSet.bindResultColumns(fromList);
    }

    @Override
    void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        this.leftResultSet.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
        this.rightResultSet.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
    }

    @Override
    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        FromTable fromTable = this.leftResultSet.getFromTableByName(string, string2, bl);
        if (fromTable == null) {
            fromTable = this.rightResultSet.getFromTableByName(string, string2, bl);
        }
        return fromTable;
    }

    @Override
    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.leftResultSet = this.leftResultSet.preprocess(n, groupByList, fromList);
        if (this.leftResultSet instanceof FromSubquery) {
            this.leftResultSet = ((FromSubquery)this.leftResultSet).extractSubquery(n);
        }
        this.rightResultSet = this.rightResultSet.preprocess(n, groupByList, fromList);
        if (this.rightResultSet instanceof FromSubquery) {
            this.rightResultSet = ((FromSubquery)this.rightResultSet).extractSubquery(n);
        }
        this.setReferencedTableMap((JBitSet)this.leftResultSet.getReferencedTableMap().clone());
        this.getReferencedTableMap().or(this.rightResultSet.getReferencedTableMap());
        this.getReferencedTableMap().set(this.tableNumber);
        if (this.isFlattenableJoinNode()) {
            return this;
        }
        this.projectResultColumns();
        return this.genProjectRestrict(n);
    }

    @Override
    void projectResultColumns() throws StandardException {
        this.getResultColumns().doProjection();
    }

    void setReferencedColumns() {
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.leftResultSet = this.leftResultSet.optimize(dataDictionary, predicateList, d);
        this.rightResultSet = this.rightResultSet.optimize(dataDictionary, predicateList, d);
        this.getCostEstimate().setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        this.getCostEstimate().add(this.rightResultSet.getCostEstimate(), this.getCostEstimate());
        return this;
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        SetOperatorNode setOperatorNode;
        if (!this.leftModifyAccessPathsDone) {
            if (this.leftOptimizer != null) {
                this.leftOptimizer.modifyAccessPaths();
                this.leftResultSet = (ResultSetNode)((Object)this.leftOptimizer.getOptimizable(0));
            } else if (this instanceof SetOperatorNode) {
                setOperatorNode = (SetOperatorNode)this;
                this.leftResultSet = this.leftResultSet.modifyAccessPaths(setOperatorNode.getLeftOptPredicateList());
            } else {
                this.leftResultSet = this.leftResultSet.modifyAccessPaths();
            }
        }
        if (!this.rightModifyAccessPathsDone) {
            if (this.rightOptimizer != null) {
                this.rightOptimizer.modifyAccessPaths();
                this.rightResultSet = (ResultSetNode)((Object)this.rightOptimizer.getOptimizable(0));
            } else if (this instanceof SetOperatorNode) {
                setOperatorNode = (SetOperatorNode)this;
                this.rightResultSet = this.rightResultSet.modifyAccessPaths(setOperatorNode.getRightOptPredicateList());
            } else {
                this.rightResultSet = this.rightResultSet.modifyAccessPaths();
            }
        }
        return this;
    }

    @Override
    boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.leftResultSet.referencesTarget(string, bl) || this.rightResultSet.referencesTarget(string, bl);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.leftResultSet.referencesSessionSchema() || this.rightResultSet.referencesSessionSchema();
    }

    protected ResultSetNode optimizeSource(Optimizer optimizer, ResultSetNode resultSetNode, PredicateList predicateList, CostEstimate costEstimate) throws StandardException {
        ResultSetNode resultSetNode2;
        if (resultSetNode instanceof FromTable) {
            FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), (FromTable)resultSetNode, this.getContextManager());
            if (predicateList == null) {
                predicateList = new PredicateList(this.getContextManager());
            }
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
            OptimizerFactory optimizerFactory = languageConnectionContext.getOptimizerFactory();
            optimizer = optimizerFactory.getOptimizer(fromList, predicateList, this.getDataDictionary(), null, this.getCompilerContext().getNumTables(), null, languageConnectionContext);
            optimizer.prepForNextRound();
            if (resultSetNode == this.leftResultSet) {
                this.leftOptimizer = optimizer;
            } else if (resultSetNode == this.rightResultSet) {
                this.rightOptimizer = optimizer;
            }
            optimizer.setOuterRows(costEstimate.rowCount());
            while (optimizer.getNextPermutation()) {
                while (optimizer.getNextDecoratedPermutation()) {
                    optimizer.costPermutation();
                }
            }
            resultSetNode2 = resultSetNode;
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceEndQueryBlock();
            }
        } else {
            resultSetNode2 = resultSetNode.optimize(this.getDataDictionary(), predicateList, costEstimate.rowCount());
        }
        return resultSetNode2;
    }

    @Override
    void decrementLevel(int n) {
        this.leftResultSet.decrementLevel(n);
        this.rightResultSet.decrementLevel(n);
    }

    @Override
    void adjustForSortElimination() {
        this.leftResultSet.adjustForSortElimination();
        this.rightResultSet.adjustForSortElimination();
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering requiredRowOrdering) throws StandardException {
        this.leftResultSet.adjustForSortElimination(requiredRowOrdering);
        this.rightResultSet.adjustForSortElimination(requiredRowOrdering);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.leftResultSet != null) {
            this.leftResultSet = (ResultSetNode)this.leftResultSet.accept(visitor);
        }
        if (this.rightResultSet != null) {
            this.rightResultSet = (ResultSetNode)this.rightResultSet.accept(visitor);
        }
    }

    @Override
    boolean needsSpecialRCLBinding() {
        return true;
    }
}

