/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.ui.sourceediting;

import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.statet.docmlet.tex.core.TexCodeStyleSettings;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.docmlet.tex.core.source.LtxDocumentSetupParticipant;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.LtxSourceViewerConfiguration;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;

@NonNullByDefault
public class LtxSourceViewerConfigurator
extends SourceEditorViewerConfigurator
implements TexCoreAccess,
PropertyChangeListener {
    private static final Set<String> RESET_GROUP_IDS = ImCollections.newSet((Object)"tex/tex.codestyle/indent");
    private TexCoreAccess sourceCoreAccess = (TexCoreAccess)ObjectUtils.nonNullLateInit();
    private final TexCodeStyleSettings texCodeStyleCopy = new TexCodeStyleSettings(1);

    public LtxSourceViewerConfigurator(@Nullable TexCoreAccess coreAccess, LtxSourceViewerConfiguration config) {
        super((SourceEditorViewerConfiguration)config);
        config.setCoreAccess(this);
        this.setSource(coreAccess);
        this.texCodeStyleCopy.load(this.sourceCoreAccess.getTexCodeStyle());
        this.texCodeStyleCopy.resetDirty();
        this.texCodeStyleCopy.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new LtxDocumentSetupParticipant();
    }

    protected Set<String> getResetGroupIds() {
        return RESET_GROUP_IDS;
    }

    public void setSource(@Nullable TexCoreAccess newAccess) {
        if (newAccess == null) {
            newAccess = TexCore.getWorkbenchAccess();
        }
        if (this.sourceCoreAccess != newAccess) {
            this.sourceCoreAccess = newAccess;
            this.handleSettingsChanged(null, null);
        }
    }

    public void handleSettingsChanged(@Nullable Set<String> groupIds, @Nullable Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        this.texCodeStyleCopy.resetDirty();
    }

    protected void checkSettingsChanges(Set<String> groupIds, Map<String, Object> options) {
        super.checkSettingsChanges(groupIds, options);
        if (groupIds.contains("tex/tex.codestyle/indent")) {
            this.texCodeStyleCopy.load(this.sourceCoreAccess.getTexCodeStyle());
        }
        if (groupIds.contains("org.eclipse.statet.docmlet.tex.ui/editor/editing")) {
            this.updateCompleteConfig = true;
        }
    }

    public PreferenceAccess getPrefs() {
        return this.sourceCoreAccess.getPrefs();
    }

    public TexCommandSet getTexCommandSet() {
        return this.sourceCoreAccess.getTexCommandSet();
    }

    public TexCodeStyleSettings getTexCodeStyle() {
        return this.texCodeStyleCopy;
    }
}

