/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceElement;
import org.eclipse.statet.docmlet.wikitext.core.model.build.EmbeddingReconcileTask;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainerEmbeddedExtension;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.yaml.core.ast.SourceComponent;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.ast.YamlParser;
import org.eclipse.statet.yaml.core.model.YamlChunkElement;
import org.eclipse.statet.yaml.core.model.YamlElementName;
import org.eclipse.statet.yaml.core.model.YamlModel;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.yaml.core.model.build.YamlProblemReporter;

@NonNullByDefault
public class YamlReconcilerExtension
implements WikidocSourceUnitModelContainerEmbeddedExtension {
    private static final YamlElementName METADATA_ELEMENT_NAME = YamlElementName.create((int)15, (String)"Metadata (YAML)");
    private final YamlParser parser = new YamlParser();
    private final YamlProblemReporter problemReporter = new YamlProblemReporter();

    @Override
    public Object getSourceConfig() {
        return "Yaml";
    }

    @Override
    public void reconcileEmbeddedAst(SourceContent content, List<Embedded> list, WikitextMarkupLanguage markupLanguage, Object sourceConfig, int level, IProgressMonitor monitor) {
        for (EmbeddingAstNode embeddingAstNode : list) {
            if (embeddingAstNode.getForeignTypeId() != "Yaml") continue;
            String text = content.getString();
            int offset = embeddingAstNode.getStartOffset();
            while (offset < text.length() && Character.isWhitespace(text.charAt(offset))) {
                ++offset;
            }
            SourceComponent component = this.parser.parse(text.substring(offset, embeddingAstNode.getEndOffset()), (AstNode)embeddingAstNode, offset);
            embeddingAstNode.setForeignNode((AstNode)component);
        }
    }

    @Override
    public void reconcileEmbeddedModel(SourceContent content, WikidocSourceUnitModelInfo wikitextModel, List<EmbeddingReconcileTask> list, int level, IProgressMonitor monitor) {
        WikitextSourceElement sourceElement = wikitextModel.getSourceElement();
        int metadataCount = 0;
        ArrayList<YamlChunkElement> chunkElements = new ArrayList<YamlChunkElement>();
        for (EmbeddingReconcileTask item : list) {
            YamlAstNode astNode;
            if (item.getForeignTypeId() != "Yaml" || (astNode = (YamlAstNode)item.getAstNode().getForeignNode()) == null) continue;
            YamlChunkElement element = new YamlChunkElement((SourceStructElement)item.getEmbeddingElement(), astNode, METADATA_ELEMENT_NAME, metadataCount++);
            item.setEmbeddedElement((SourceStructElement)element);
            chunkElements.add(element);
        }
        if (metadataCount == 0) {
            return;
        }
        YamlSourceUnitModelInfo modelInfo = YamlModel.getYamlModelManager().reconcile(sourceElement.getSourceUnit(), (SourceUnitModelInfo)wikitextModel, chunkElements, level, monitor);
        if (modelInfo != null) {
            wikitextModel.addAttachment(modelInfo);
        }
    }

    @Override
    public void reportEmbeddedProblems(SourceContent content, WikidocSourceUnitModelInfo wikitextModel, ProblemRequestor problemRequestor, int level, IProgressMonitor monitor) {
        YamlSourceUnitModelInfo yamlModel = YamlModel.getYamlModelInfo((SourceUnitModelInfo)wikitextModel);
        if (yamlModel == null) {
            return;
        }
        this.problemReporter.run(yamlModel, content, problemRequestor, level, monitor);
    }
}

