/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.Messages;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.builder.RBuilder;
import org.eclipse.statet.r.core.RProject;

public class RSupportBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.statet.r.resourceProjects.RBuilder";
    private RProject rProject;
    private SettingsListener settingsListener;
    private ExceptionCollector exceptions;
    private boolean startupSuccessfull = false;
    private boolean initialized = false;
    private RBuilder rBuilder;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
    }

    protected void startupOnInitialize() {
        this.startupSuccessfull = false;
        super.startupOnInitialize();
        try {
            this.settingsListener = new SettingsListener();
            this.rProject = (RProject)this.getProject().getNature("org.eclipse.statet.r.resourceProjects.R");
            if (this.rProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "R Project Nature is missing", null));
            }
            this.rProject.addPreferenceNodeListener("org.eclipse.statet.ide.core/managment", this.settingsListener);
            this.rBuilder = new RBuilder();
            this.startupSuccessfull = true;
        }
        catch (CoreException e) {
            RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"Error occured while initizalizing the builder (''{0}'').", (Object)ID), (Throwable)e));
        }
    }

    private void init() throws CoreException {
        if (!this.startupSuccessfull) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, Messages.Builder_error_OnStartup_message, null));
        }
        this.exceptions = new ExceptionCollector();
        this.initialized = true;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!this.initialized) {
            this.init();
        }
        if (kind == 6) {
            this.doFullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.doFullBuild(monitor);
            } else {
                this.doIncrementalBuild(delta, monitor);
            }
        }
        monitor.done();
        return null;
    }

    protected void doFullBuild(IProgressMonitor monitor) throws CoreException {
        this.exceptions.reset();
        IStatus status = this.rBuilder.buildFull(this.rProject, monitor);
        if (!status.isOK()) {
            this.exceptions.add(status);
        }
        this.exceptions.checkException();
    }

    protected void doIncrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.exceptions.reset();
        IStatus status = this.rBuilder.buildIncremental(this.rProject, delta, monitor);
        if (!status.isOK()) {
            this.exceptions.add(status);
        }
        this.exceptions.checkException();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.init();
        this.rBuilder.clean(this.getProject(), monitor);
    }

    static class ExceptionCollector {
        private final ArrayList<IStatus> exceptionList = new ArrayList(20);

        ExceptionCollector() {
        }

        public void reset() {
            this.exceptionList.clear();
            if (this.exceptionList.size() > 20) {
                this.exceptionList.trimToSize();
            }
        }

        private void add(IStatus e) {
            this.exceptionList.add(e);
        }

        void checkException() throws CoreException {
            if (this.exceptionList != null && this.exceptionList.size() > 0) {
                IStatus[] allStatus = this.exceptionList.toArray(new IStatus[this.exceptionList.size()]);
                MultiStatus status = new MultiStatus("org.eclipse.statet.r.core", 0, allStatus, NLS.bind((String)Messages.Builder_error_MultipleErrors_message, (Object)Integer.toString(allStatus.length)), null);
                throw new CoreException((IStatus)status);
            }
        }
    }

    private class SettingsListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private SettingsListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            RSupportBuilder.this.initialized = false;
        }
    }
}

