/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.regex.Matcher;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonRegex;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ToStringHelper;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class Line
implements TextRegion {
    private static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    "};
    private final int startOffset;
    private final int column;
    private final String text;
    private int indentColumns = -1;
    private int indentLength = -1;
    private final int lineNumber;
    private final String lineDelimiter;

    public Line(int lineNumber, int offset, int column, String text, String lineDelimiter) {
        if (lineNumber < 0) {
            throw new IllegalArgumentException("lineNumber= " + lineNumber);
        }
        if (offset < 0) {
            throw new IllegalArgumentException("startOffset= " + offset);
        }
        if (column < 0) {
            throw new IllegalArgumentException("column= " + column);
        }
        this.lineNumber = lineNumber;
        this.startOffset = offset;
        this.column = column;
        this.text = (String)ObjectUtils.nonNullAssert((Object)text);
        this.lineDelimiter = (String)ObjectUtils.nonNullAssert((Object)lineDelimiter);
        this.computeIndent();
    }

    private Line(int lineNumber, int offset, int column, String text, String lineDelimiter, int indentColumns, int indentLength) {
        this.lineNumber = lineNumber;
        this.startOffset = offset;
        this.column = column;
        this.text = text;
        this.lineDelimiter = lineDelimiter;
        this.indentColumns = indentColumns;
        this.indentLength = indentLength;
    }

    public boolean isBlank() {
        return this.text.length() == this.indentLength;
    }

    public String getText() {
        return this.text;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.startOffset + this.getLength();
    }

    public int getLength() {
        return this.text.length() + this.lineDelimiter.length();
    }

    public int getColumn() {
        return this.column;
    }

    public int getColumn(int offset) {
        if (offset == 0) {
            return this.column;
        }
        if (offset == this.indentLength) {
            return this.column + this.indentColumns;
        }
        return this.computeColumn(offset);
    }

    public int getIndent() {
        return this.indentColumns;
    }

    public int getIndentLength() {
        return this.indentLength;
    }

    public String getTextContent(boolean trimEnd) {
        return trimEnd ? this.text.substring(this.indentLength, this.computeTrimEnd()) : this.text.substring(this.indentLength);
    }

    public int getTextContentOffset() {
        return this.startOffset + this.indentLength;
    }

    public int getTextContentLength() {
        return this.text.length() - this.indentLength;
    }

    public String getCodeContent() {
        if (this.text.isEmpty() || this.indentLength == 0 || this.column % 4 == 0 || this.text.charAt(0) != '\t') {
            return this.text;
        }
        return String.valueOf(SPACES[this.column % 4]) + this.text.substring(1);
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Line segment(int offset, int length) {
        if (offset < 0 || offset > this.text.length()) {
            throw new IllegalArgumentException("offset= " + offset);
        }
        if (length < 0 || length > this.text.length() - offset) {
            throw new IllegalArgumentException("length= " + length);
        }
        int offsetColumn = this.getColumn(offset);
        return new Line(this.lineNumber, this.startOffset + offset, offsetColumn, this.text.substring(offset, offset + length), offset + length == this.text.length() ? this.lineDelimiter : "");
    }

    public Line segmentByIndent(int indent) {
        int indentLength;
        int n = indentLength = indent == this.indentColumns ? this.indentLength : this.computeLength(indent);
        if (indentLength == -1) {
            return this.segment(this.text.length(), 0);
        }
        if (indent <= this.indentColumns) {
            return new Line(this.lineNumber, this.startOffset + indentLength, this.column + indent, this.text.substring(indentLength), this.lineDelimiter, this.indentColumns - indent, this.indentLength - indentLength);
        }
        return new Line(this.lineNumber, this.startOffset + indentLength, this.column + indent, this.text.substring(indentLength), this.lineDelimiter);
    }

    public Line trimWhitespace(boolean leadingWhitespace, boolean trailingWhitespace) {
        int offset = 0;
        int end = this.text.length();
        if (leadingWhitespace) {
            while (offset < end && CommonRegex.isWhitespace(this.text.charAt(offset))) {
                ++offset;
            }
        }
        if (trailingWhitespace) {
            while (end > offset && CommonRegex.isWhitespace(this.text.charAt(end - 1))) {
                --end;
            }
        }
        if (offset == 0 && end == this.text.length()) {
            return this;
        }
        int offsetColumn = this.getColumn(offset);
        return new Line(this.lineNumber, this.startOffset + offset, offsetColumn, this.text.substring(offset, end), offset < end && !trailingWhitespace ? this.lineDelimiter : "");
    }

    public boolean isLazy() {
        return false;
    }

    public Line lazy() {
        return new LazyLine(this.lineNumber, this.startOffset, this.column, this.text, this.lineDelimiter, this.indentColumns, this.indentLength);
    }

    public Matcher setup(Matcher matcher, int start, int end) {
        matcher.reset(this.text);
        if (start != 0 || end != this.text.length()) {
            matcher.region(start, end);
        }
        return matcher;
    }

    public Matcher setup(Matcher matcher) {
        return matcher.reset(this.text);
    }

    public Matcher setupIndent(Matcher matcher) {
        return this.setup(matcher, true, false);
    }

    public Matcher setup(Matcher matcher, boolean trimIndent, boolean trimEnd) {
        if (trimIndent || trimEnd) {
            int start = trimIndent ? this.getIndentLength() : 0;
            int end = trimEnd && start < this.text.length() ? this.computeTrimEnd() : this.text.length();
            return this.setup(matcher, start, end);
        }
        return this.setup(matcher);
    }

    private void computeIndent() {
        String text = this.text;
        int column = this.column;
        int idx = 0;
        block4: while (idx < text.length()) {
            char c = text.charAt(idx);
            switch (c) {
                case ' ': {
                    ++column;
                    ++idx;
                    break;
                }
                case '\t': {
                    column += 4 - column % 4;
                    ++idx;
                    break;
                }
                default: {
                    break block4;
                }
            }
        }
        this.indentColumns = column - this.column;
        this.indentLength = idx;
    }

    private int computeLength(int indent) {
        if (indent == 0) {
            return 0;
        }
        String text = this.text;
        int column = this.column;
        int idx = 0;
        while (idx < text.length()) {
            char c = text.charAt(idx);
            switch (c) {
                case '\t': {
                    column += 4 - column % 4;
                    if (column - this.column > indent) {
                        return idx;
                    }
                    if (column - this.column >= indent) {
                        return idx + 1;
                    }
                    ++idx;
                    break;
                }
                default: {
                    if (++column - this.column >= indent) {
                        return idx + 1;
                    }
                    ++idx;
                }
            }
        }
        return -1;
    }

    private int computeColumn(int offset) {
        assert (offset <= this.text.length());
        String text = this.text;
        int column = this.column;
        int idx = 0;
        while (idx < offset) {
            char c = text.charAt(idx);
            switch (c) {
                case '\t': {
                    column += 4 - column % 4;
                    ++idx;
                    break;
                }
                default: {
                    ++column;
                    ++idx;
                }
            }
        }
        return column;
    }

    private int computeTrimEnd() {
        String text = this.text;
        int idx = text.length() - 1;
        while (idx >= 0) {
            switch (text.charAt(idx)) {
                case '\t': 
                case ' ': {
                    break;
                }
                default: {
                    return idx + 1;
                }
            }
            --idx;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Line");
        sb.append(" (lineNumber= ").append(this.lineNumber);
        sb.append(", startOffset= ").append(this.startOffset);
        sb.append(", column= ").append(this.column);
        sb.append(")");
        sb.append("\n\ttext= ").append(ToStringHelper.toStringValue(this.text));
        return sb.toString();
    }

    private static class LazyLine
    extends Line {
        public LazyLine(int lineNumber, int offset, int column, String text, String lineDelimiter, int indentColumns, int indentLength) {
            super(lineNumber, offset, column, text, lineDelimiter, indentColumns, indentLength);
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public LazyLine lazy() {
            return this;
        }
    }
}

