/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source.extdoc;

import java.util.List;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.tex.core.source.doc.LtxPartitionNodeScanner;
import org.eclipse.statet.docmlet.tex.core.source.doc.LtxPartitionNodeType;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.EmbeddingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikitextPartitionNodeType;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikitextWeavePartitionNodeScanner;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.ExtdocMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.HtmlPartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.yaml.core.source.doc.YamlPartitionNodeScanner;

public class WikidocPartitionNodeScanner
extends WikitextWeavePartitionNodeScanner {
    private static final List<HtmlPartitionNodeType.Default> HTML_DEFAULT_HTML_TYPES = ImCollections.newList((Object[])new HtmlPartitionNodeType.Default[]{new HtmlPartitionNodeType.Default(), new HtmlPartitionNodeType.Default(), new HtmlPartitionNodeType.Default(), new HtmlPartitionNodeType.Default(), new HtmlPartitionNodeType.Default(), new HtmlPartitionNodeType.Default(), new HtmlPartitionNodeType.Default(), new HtmlPartitionNodeType.Default()});
    private static final HtmlPartitionNodeType HTML_COMMENT_HTML_TYPE = HtmlPartitionNodeType.COMMENT;
    private static final WikitextPartitionNodeType YAML_CHUNK_WIKITEXT_TYPE = new WikitextPartitionNodeType();
    public static final LtxPartitionNodeType TEX_BASE_TEX_TYPE = new LtxPartitionNodeType(){

        public String getPartitionType() {
            return "Wikitext.Default";
        }

        public byte getScannerState() {
            return LtxPartitionNodeType.DEFAULT_ROOT.getScannerState();
        }
    };
    public static final WikitextPartitionNodeType TEX_MATH_WIKITEXT_TYPE = new WikitextPartitionNodeType();
    private YamlPartitionNodeScanner yamlScanner;
    private LtxPartitionNodeScanner ltxScanner;

    public WikidocPartitionNodeScanner(WikitextMarkupLanguage markupLanguage) {
        this(markupLanguage, 0);
    }

    public WikidocPartitionNodeScanner(WikitextMarkupLanguage markupLanguage, int markupLanguageMode) {
        super(markupLanguage, markupLanguageMode);
    }

    private TreePartitionNodeScanner getYamlScanner() {
        if (this.yamlScanner == null) {
            this.yamlScanner = new YamlPartitionNodeScanner();
        }
        return this.yamlScanner;
    }

    private TreePartitionNodeScanner getLtxScanner() {
        if (this.ltxScanner == null) {
            this.ltxScanner = new LtxPartitionNodeScanner(this.isTemplateMode());
        }
        return this.ltxScanner;
    }

    @Override
    protected void beginEmbeddingBlock(DocumentBuilder.BlockType type, WikitextWeavePartitionNodeScanner.Embedding embedding) {
        if (type == DocumentBuilder.BlockType.CODE && embedding.getForeignType() == "Html") {
            EmbeddingAttributes attributes = embedding.getAttributes();
            HtmlPartitionNodeType htmlType = (attributes.getEmbedDescr() & 0x80) != 0 ? HTML_COMMENT_HTML_TYPE : (HtmlPartitionNodeType)HTML_DEFAULT_HTML_TYPES.get((attributes.getEmbedDescr() & 0x70) >> ExtdocMarkupLanguage.EMBEDDED_HTML_DISTINCT_SHIFT);
            this.addNode((TreePartitionNodeType)htmlType, this.getEventBeginOffset());
            return;
        }
        if (type == DocumentBuilder.BlockType.CODE && embedding.getForeignType() == "Yaml") {
            this.addNode((TreePartitionNodeType)YAML_CHUNK_WIKITEXT_TYPE, this.getEventBeginOffset());
            embedding.init(this.getNode());
            return;
        }
        super.beginEmbeddingBlock(type, embedding);
    }

    @Override
    protected void endEmbeddingBlock(TreePartitionNodeType type, WikitextWeavePartitionNodeScanner.Embedding embedding) {
        if (type == YAML_CHUNK_WIKITEXT_TYPE) {
            embedding.executeForeignScanner(this.getYamlScanner());
            this.exitNode(this.getEventEndOffset(), this.getEventFlags(embedding.getAttributes()));
            return;
        }
        if (type instanceof HtmlPartitionNodeType) {
            this.exitNode(this.getEventEndOffset(), this.getEventFlags(embedding.getAttributes()));
            return;
        }
        super.endEmbeddingBlock(type, embedding);
    }

    @Override
    protected void beginEmbeddingSpan(DocumentBuilder.SpanType type, WikitextWeavePartitionNodeScanner.Embedding embedding) {
        if (type == DocumentBuilder.SpanType.CODE && embedding.getForeignType() == "Ltx") {
            this.addNode((TreePartitionNodeType)TEX_BASE_TEX_TYPE, this.getEventBeginOffset());
            embedding.init(this.getNode());
            return;
        }
        super.beginEmbeddingSpan(type, embedding);
    }

    @Override
    protected void endEmbeddingSpan(TreePartitionNodeType type, WikitextWeavePartitionNodeScanner.Embedding embedding) {
        if (type == TEX_BASE_TEX_TYPE) {
            embedding.executeForeignScanner(this.getLtxScanner());
            this.exitNode(this.getEventEndOffset(), this.getEventFlags(embedding.getAttributes()));
            return;
        }
        super.endEmbeddingSpan(type, embedding);
    }
}

