/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.prefs.BackingStoreException;

@NonNullByDefault
public abstract class ConfigurationBlock {
    public static final int SAVE_STORE = 16;
    private Shell shell;
    private final @Nullable String title;
    private IWorkbenchPreferenceContainer container;
    private boolean useProjectSettings = true;

    public static GridData applyWrapWidth(GridData gd) {
        gd.widthHint = 300;
        return gd;
    }

    public static void scheduleChangeNotification(IWorkbenchPreferenceContainer container, @Nullable ImCollection<String> groupIds, boolean directly) {
        if (groupIds != null) {
            String source = directly ? null : container.toString();
            Job job = PreferencesUtil.getSettingsChangeNotifier().getNotifyJob(source, groupIds);
            if (job == null) {
                return;
            }
            if (directly) {
                job.schedule();
            } else {
                container.registerUpdateJob(job);
            }
        }
    }

    protected ConfigurationBlock() {
        this(null);
    }

    protected ConfigurationBlock(@Nullable String title) {
        this.title = title;
    }

    public IWorkbenchPreferenceContainer getContainer() {
        return this.container;
    }

    public void createContents(Composite pageComposite, IWorkbenchPreferenceContainer container, IPreferenceStore preferenceStore) {
        this.shell = pageComposite.getShell();
        this.container = container;
        this.createBlockArea(pageComposite);
    }

    protected abstract void createBlockArea(Composite var1);

    public void dispose() {
    }

    protected @Nullable String getTitle() {
        return this.title;
    }

    protected @Nullable String getHelpContext() {
        return null;
    }

    public abstract boolean performOk(int var1);

    public abstract void performDefaults();

    public void performCancel() {
    }

    public void setUseProjectSpecificSettings(boolean enable) {
        this.useProjectSettings = enable;
    }

    public boolean isUseProjectSpecificSettings() {
        return this.useProjectSettings;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void addLinkHeader(Composite pageComposite, String text) {
        Link link = this.addLinkControl(pageComposite, text);
        link.setLayoutData((Object)ConfigurationBlock.applyWrapWidth(new GridData(4, 4, false, false)));
        LayoutUtils.addSmallFiller(pageComposite, false);
    }

    protected Link addLinkControl(Composite composite, String text) {
        return this.addLinkControl(composite, text, new LinkSelectionListener());
    }

    protected Link addLinkControl(Composite composite, String text, LinkSelectionListener listener) {
        Link link = new Link(composite, 0);
        link.setText(text);
        link.addSelectionListener((SelectionListener)listener);
        return link;
    }

    protected void scheduleChangeNotification(Set<String> groupIds, boolean directly) {
        ConfigurationBlock.scheduleChangeNotification(this.container, (ImCollection<String>)ImCollections.toList(groupIds), directly);
    }

    protected void logSaveError(BackingStoreException e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.osgi.service.prefs", 0, "An error occurred when saving preferences to backing store.", (Throwable)e));
    }

    protected class LinkSelectionListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            TreeViewer treeViewer;
            Object element;
            String pageId = e.text;
            boolean expand = false;
            if (pageId != null && pageId.endsWith("+")) {
                pageId = pageId.substring(0, pageId.length() - 1);
                expand = true;
            }
            PreferenceDialog dialog = org.eclipse.ui.dialogs.PreferencesUtil.createPreferenceDialogOn((Shell)ConfigurationBlock.this.getShell(), (String)pageId, null, (Object)this.getData(e));
            if (expand && (element = ((IStructuredSelection)(treeViewer = dialog.getTreeViewer()).getSelection()).getFirstElement()) != null) {
                treeViewer.setExpandedState(element, true);
            }
        }

        protected @Nullable Object getData(SelectionEvent e) {
            return null;
        }
    }
}

