/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates.config;

import java.io.IOException;
import java.util.List;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.templates.config.ITemplateContribution;
import org.eclipse.text.templates.TemplatePersistenceData;

@NonNullByDefault
public class TemplateStoreContribution
implements ITemplateContribution {
    private final TemplateStore templateStore;

    public TemplateStoreContribution(TemplateStore store) {
        this.templateStore = store;
    }

    public List<TemplatePersistenceData> getTemplates(String categoryId) {
        return ImCollections.newList((Object[])this.templateStore.getTemplateData(false));
    }

    @Override
    public @Nullable Template findTemplate(String contextTypeId, String name) {
        return this.templateStore.findTemplate(name, contextTypeId);
    }

    @Override
    public void add(String categoryId, TemplatePersistenceData data) {
        this.templateStore.add(data);
    }

    @Override
    public void delete(TemplatePersistenceData data) {
        this.templateStore.delete(data);
    }

    @Override
    public void revertEdits() throws IOException {
        this.templateStore.load();
    }

    @Override
    public void saveEdits() throws IOException {
        this.templateStore.save();
    }

    @Override
    public boolean hasDeleted() {
        return this.templateStore.getTemplateData(true).length != this.templateStore.getTemplateData(false).length;
    }

    @Override
    public void restoreDeleted() {
        this.templateStore.restoreDeleted();
    }

    @Override
    public void restoreDefaults() {
        this.templateStore.restoreDefaults(false);
    }

    public int hashCode() {
        return this.templateStore.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            TemplateStoreContribution other = (TemplateStoreContribution)obj;
            return this.templateStore == other.templateStore;
        }
        return false;
    }
}

