/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.actions.AbstractToolHandler;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class PauseHandler
extends AbstractToolHandler<ToolProcess>
implements IElementUpdater,
IDebugEventSetListener {
    private boolean isChecked;

    public PauseHandler(ToolProvider toolProvider, IServiceLocator serviceLocator) {
        super(null, null, toolProvider, serviceLocator);
        this.init();
    }

    @Override
    protected void init() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        super.init();
    }

    @Override
    public void dispose() {
        DebugPlugin debugManager = DebugPlugin.getDefault();
        if (debugManager != null) {
            debugManager.removeDebugEventListener((IDebugEventSetListener)this);
        }
        super.dispose();
    }

    private void setChecked(boolean isChecked) {
        if (isChecked != this.isChecked) {
            this.isChecked = isChecked;
            this.refreshUI();
        }
    }

    @Override
    public void setEnabled(@Nullable Object evaluationContext) {
        super.setEnabled(evaluationContext);
        ToolProcess enabledTool = (ToolProcess)this.getActiveTool();
        this.setChecked(enabledTool != null ? enabledTool.getQueue().isRequested((byte)5) : false);
    }

    protected void refreshUI() {
        WorkbenchUIUtils.refreshCommandElements((String)"org.eclipse.statet.nico.commands.PauseTool", (IHandler2)this, null);
    }

    public void updateElement(UIElement element, Map parameters) {
        WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
        try {
            element.setChecked(this.isChecked);
        }
        finally {
            WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        ToolProcess tool = (ToolProcess)this.getActiveTool();
        if (tool == null) {
            return;
        }
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() == tool) {
                if (event.getKind() == 8) {
                    this.update(tool);
                }
            } else if (event.getSource() == tool.getQueue()) {
                Queue.StateDelta delta;
                if (Queue.isStateRequest((DebugEvent)event)) {
                    delta = (Queue.StateDelta)event.getData();
                    if (delta.newState == 5) {
                        this.updateChecked(tool, true);
                    } else {
                        this.updateChecked(tool, false);
                    }
                } else if (Queue.isStateChange((DebugEvent)event)) {
                    delta = (Queue.StateDelta)event.getData();
                    if (delta.newState == 5) {
                        this.updateChecked(tool, true);
                    }
                }
            }
            ++n2;
        }
    }

    private void update(ToolProcess tool) {
        UIAccess.getDisplay().asyncExec(() -> {
            if (this.getState() != 1 || this.getActiveTool() != tool) {
                return;
            }
            this.setEnabled(null);
        });
    }

    private void updateChecked(ToolProcess tool, boolean isChecked) {
        UIAccess.getDisplay().asyncExec(() -> {
            if (this.getState() != 1 || this.getActiveTool() != tool) {
                return;
            }
            this.setChecked(isChecked);
        });
    }

    @Override
    protected @Nullable Object execute(ToolProcess tool, ExecutionEvent event) {
        boolean success;
        boolean wasChecked = this.isChecked;
        boolean bl = success = !wasChecked ? tool.getQueue().pause() : tool.getQueue().resume();
        this.setChecked(success ? !wasChecked : false);
        return null;
    }
}

