/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;

@NonNullByDefault
abstract class StdBinary
extends RAstNode {
    final Expression leftExpr = new Expression();
    final Expression rightExpr = new Expression();

    StdBinary() {
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.leftExpr.node;
            }
            case 1: {
                return this.rightExpr.node;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public final RAstNode getLeftChild() {
        return this.leftExpr.node;
    }

    public final RAstNode getRightChild() {
        return this.rightExpr.node;
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.leftExpr.node == child) {
            return 0;
        }
        if (this.rightExpr.node == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.leftExpr.node.acceptInR(visitor);
        this.rightExpr.node.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.leftExpr.node);
        visitor.visit((AstNode)this.rightExpr.node);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.rightExpr.node == child) {
            return this.rightExpr;
        }
        if (this.leftExpr.node == child) {
            return this.leftExpr;
        }
        return null;
    }

    @Override
    final Expression getLeftExpr() {
        return this.leftExpr;
    }

    @Override
    final Expression getRightExpr() {
        return this.rightExpr;
    }

    @Override
    int getMissingExprStatus(Expression expr) {
        if (this.leftExpr == expr) {
            return 4195090;
        }
        if (this.rightExpr == expr) {
            return 4195091;
        }
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        this.startOffset = this.leftExpr.node.startOffset;
        this.endOffset = this.rightExpr.node.endOffset;
    }
}

