/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInformationProposal;
import org.eclipse.statet.r.core.rmodel.Parameters;
import org.eclipse.statet.r.core.rmodel.RLangMethod;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class RArgumentListContextInformation
implements AssistInformationProposal,
IContextInformationExtension {
    private final int fCallArgsOffset;
    private final @Nullable FCall fCallNode;
    private final @Nullable Parameters parameters;
    private final String information;
    private final ImIntList informationParameterIndexes;

    public RArgumentListContextInformation(int fCallArgsOffset, @Nullable FCall fCallNode, RLangMethod method) {
        this.fCallArgsOffset = fCallArgsOffset;
        this.fCallNode = fCallNode;
        this.parameters = method.getParameters();
        StringBuilder sb = new StringBuilder();
        IntArrayList idxs = new IntArrayList();
        new RLabelProvider().appendArgumentInformation(sb, (IntList)idxs, this.parameters);
        this.information = sb.toString();
        this.informationParameterIndexes = ImCollections.toIntList((IntList)idxs);
    }

    public @Nullable FCall getFCallNode() {
        return this.fCallNode;
    }

    public int getFCallArgsOffset() {
        return this.fCallArgsOffset;
    }

    public @Nullable Parameters getParameters() {
        return this.parameters;
    }

    public String getContextDisplayString() {
        return this.getInformationDisplayString();
    }

    public @Nullable Image getImage() {
        return null;
    }

    public int getContextInformationPosition() {
        return Math.max(this.fCallArgsOffset, 0);
    }

    public String getInformationDisplayString() {
        return this.information;
    }

    public ImIntList getInformationDisplayStringParameterIndexes() {
        return this.informationParameterIndexes;
    }

    public boolean equals(@Nullable Object obj) {
        return true;
    }
}

