/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RStore;

@NonNullByDefault
public abstract class AbstractRStore<P>
implements RStore<P> {
    protected static final long NA_numeric_LONG = 9221120237041092514L;
    protected static final long NA_numeric_LONG_MASK = 0x7FF00000FFFFFFFFL;
    protected static final long NA_numeric_LONG_MATCH = 9218868437227407266L;
    protected static final int NA_numeric_INT_MATCH = 1954;
    protected static final double NA_numeric_DOUBLE = Double.longBitsToDouble(9221120237041092514L);
    protected static final long NaN_numeric_LONG = Double.doubleToLongBits(Double.NaN);
    protected static final double NaN_numeric_DOUBLE = Double.NaN;
    protected static final int NA_integer_INT = Integer.MIN_VALUE;
    protected static final byte NA_byte_BYTE = 0;
    protected static final byte NA_logical_BYTE = 2;
    protected static final int NA_logical_INT = Integer.MIN_VALUE;
    protected static final int WITH_NAMES = 1;
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected static final byte[] @NonNull [] EMPTY_BYTE_2dARRAY = new byte[0][];
    protected static final int[] EMPTY_INT_ARRAY = new int[0];
    protected static final int[] @NonNull [] EMPTY_INT_2dARRAY = new int[0][];
    protected static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    protected static final double[] @NonNull [] EMPTY_DOUBLE_2dARRAY = new double[0][];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String[] @NonNull [] EMPTY_STRING_2dARRAY = new String[0][];
    protected static final int DEFAULT_LONG_DATA_SEGMENT_LENGTH = 0x10000000;
    private static final boolean gIsBSupported = AbstractRStore.checkIsBSupported();

    public static boolean isBforNASupported() {
        return gIsBSupported;
    }

    private static boolean checkIsBSupported() {
        double d = 0.0;
        long l = 0L;
        d = NA_numeric_DOUBLE;
        l = Double.doubleToRawLongBits(d);
        if (l != 9221120237041092514L) {
            return false;
        }
        d = Double.longBitsToDouble(l);
        return (l = Double.doubleToRawLongBits(d)) == 9221120237041092514L;
    }

    protected static final long check2dArrayLength(boolean[] @NonNull [] array, int segmentLength) {
        long length = 0L;
        if (array.length > 0) {
            int last = array.length - 1;
            int i = 0;
            while (i < last) {
                if (array[i].length != segmentLength) {
                    throw new IllegalArgumentException("Unexpected data segment length (" + array[i].length + ", but " + segmentLength + " expected)");
                }
                ++i;
            }
            length = (long)last * (long)segmentLength;
            if (array[last].length > segmentLength) {
                throw new IllegalArgumentException("Unexpected data segment length (" + array[last].length + ", but max " + segmentLength + " expected)");
            }
            length += (long)array[last].length;
        }
        return length;
    }

    protected static final long check2dArrayLength(int[] @NonNull [] array, int segmentLength) {
        long length = 0L;
        if (array.length > 0) {
            int last = array.length - 1;
            int i = 0;
            while (i < last) {
                if (array[i].length != segmentLength) {
                    throw new IllegalArgumentException("Unexpected data segment length (" + array[i].length + ", but " + segmentLength + " expected)");
                }
                ++i;
            }
            length = (long)last * (long)segmentLength;
            if (array[last].length > segmentLength) {
                throw new IllegalArgumentException("Unexpected data segment length (" + array[last].length + ", but max " + segmentLength + " expected)");
            }
            length += (long)array[last].length;
        }
        return length;
    }

    protected static final long check2dArrayLength(double[] @NonNull [] array, int segmentLength) {
        long length = 0L;
        if (array.length > 0) {
            int last = array.length - 1;
            int i = 0;
            while (i < last) {
                if (array[i].length != segmentLength) {
                    throw new IllegalArgumentException("Unexpected data segment length (" + array[i].length + ", but " + segmentLength + " expected)");
                }
                ++i;
            }
            length = (long)last * (long)segmentLength;
            if (array[last].length > segmentLength) {
                throw new IllegalArgumentException("Unexpected data segment length (" + array[last].length + ", but max " + segmentLength + " expected)");
            }
            length += (long)array[last].length;
        }
        return length;
    }

    protected static final long check2dArrayLength(byte[] @NonNull [] array, int segmentLength) {
        long length = 0L;
        if (array.length > 0) {
            int last = array.length - 1;
            int i = 0;
            while (i < last) {
                if (array[i].length != segmentLength) {
                    throw new IllegalArgumentException("Unexpected data segment length (" + array[i].length + ", but " + segmentLength + " expected)");
                }
                ++i;
            }
            length = (long)last * (long)segmentLength;
            if (array[last].length > segmentLength) {
                throw new IllegalArgumentException("Unexpected data segment length (" + array[last].length + ", but max " + segmentLength + " expected)");
            }
            length += (long)array[last].length;
        }
        return length;
    }

    protected static final long check2dArrayLength(Object[] @NonNull [] array, int segmentLength) {
        long length = 0L;
        if (array.length > 0) {
            int last = array.length - 1;
            int i = 0;
            while (i < last) {
                if (array[i].length != segmentLength) {
                    throw new IllegalArgumentException("Unexpected data segment length (" + array[i].length + ", but " + segmentLength + " expected)");
                }
                ++i;
            }
            length = (long)last * (long)segmentLength;
            if (array[last].length > segmentLength) {
                throw new IllegalArgumentException("Unexpected data segment length (" + array[last].length + ", but max " + segmentLength + " expected)");
            }
            length += (long)array[last].length;
        }
        return length;
    }

    protected static final int[] @NonNull [] new2dIntArray(long length, int segmentLength) {
        if (length == 0L) {
            return EMPTY_INT_2dARRAY;
        }
        int[][] array = new int[1 + (int)((length - 1L) / (long)segmentLength)][];
        int last = array.length - 1;
        int i = 0;
        while (i < last) {
            array[i] = new int[segmentLength];
            ++i;
        }
        int restLength = (int)(length % (long)segmentLength);
        array[last] = new int[restLength == 0 ? segmentLength : restLength];
        return array;
    }

    protected static final double[] @NonNull [] new2dDoubleArray(long length, int segmentLength) {
        if (length == 0L) {
            return EMPTY_DOUBLE_2dARRAY;
        }
        double[][] array = new double[1 + (int)((length - 1L) / (long)segmentLength)][];
        int last = array.length - 1;
        int i = 0;
        while (i < last) {
            array[i] = new double[segmentLength];
            ++i;
        }
        int restLength = (int)(length % (long)segmentLength);
        array[last] = new double[restLength == 0 ? segmentLength : restLength];
        return array;
    }

    protected static final String[] @NonNull [] new2dStringArray(long length, int segmentLength) {
        if (length == 0L) {
            return EMPTY_STRING_2dARRAY;
        }
        String[][] array = new String[1 + (int)((length - 1L) / (long)segmentLength)][];
        int last = array.length - 1;
        int i = 0;
        while (i < last) {
            array[i] = new String[segmentLength];
            ++i;
        }
        int restLength = (int)(length % (long)segmentLength);
        array[last] = new String[restLength == 0 ? segmentLength : restLength];
        return array;
    }

    protected static final byte[] @NonNull [] new2dByteArray(long length, int segmentLength) {
        if (length == 0L) {
            return EMPTY_BYTE_2dARRAY;
        }
        byte[][] array = new byte[1 + (int)((length - 1L) / (long)segmentLength)][];
        int last = array.length - 1;
        int i = 0;
        while (i < last) {
            array[i] = new byte[segmentLength];
            ++i;
        }
        int restLength = (int)(length % (long)segmentLength);
        array[last] = new byte[restLength == 0 ? segmentLength : restLength];
        return array;
    }

    protected static final int[] addIdx(int[] idxs, int newIdx) {
        int i = Arrays.binarySearch(idxs, newIdx);
        if (i >= 0) {
            return idxs;
        }
        int[] newIdxs = new int[idxs.length + 1];
        i = -1 - i;
        System.arraycopy(idxs, 0, newIdxs, 0, i);
        newIdxs[i] = newIdx;
        System.arraycopy(idxs, i, newIdxs, i + 1, idxs.length - i);
        return newIdxs;
    }

    protected static final int[] insertIdx(int[] currentIdxs, int[] insertedIdxs) {
        int[] pos = new int[insertedIdxs.length];
        int i = 0;
        while (i < pos.length) {
            pos[i] = Arrays.binarySearch(currentIdxs, insertedIdxs[i]);
            if (pos[i] < 0) {
                pos[i] = -1 - pos[i];
            }
            ++i;
        }
        int[] newIdxs = new int[currentIdxs.length + insertedIdxs.length];
        int l = pos.length;
        int ci = currentIdxs.length - 1;
        while (l > 1) {
            int stop = pos[l - 1];
            while (ci >= stop) {
                newIdxs[ci + l] = currentIdxs[ci] + l;
                --ci;
            }
            newIdxs[ci + --l] = insertedIdxs[l] + l;
        }
        System.arraycopy(currentIdxs, 0, newIdxs, 0, pos[0]);
        return newIdxs;
    }

    protected static final void updateIdxInserted(int[] currentIdxs, int[] insertedIdxs) {
        int pos = Arrays.binarySearch(currentIdxs, insertedIdxs[0]);
        if (pos < 0) {
            pos = -1 - pos;
        }
        int i = 0;
        while (i < insertedIdxs.length) {
            int stop;
            int n = stop = ++i < insertedIdxs.length ? Arrays.binarySearch(currentIdxs, insertedIdxs[i]) : currentIdxs.length;
            if (stop < 0) {
                stop = -1 - stop;
            }
            while (pos < stop) {
                int n2 = pos;
                currentIdxs[n2] = currentIdxs[n2] + i;
            }
            pos = stop;
        }
    }

    protected static final int[] updateIdxRemoved(int[] currentIdxs, int[] removedIdxs) {
        int[] pos = new int[removedIdxs.length];
        int naCount = 0;
        int i = 0;
        while (i < pos.length) {
            pos[i] = Arrays.binarySearch(currentIdxs, removedIdxs[i]);
            if (pos[i] < 0) {
                pos[i] = -1 - pos[i];
            } else {
                ++naCount;
            }
            ++i;
        }
        int[] newIdxs = naCount == 0 ? currentIdxs : new int[currentIdxs.length - naCount];
        int l = 0;
        int ci = 0;
        int ni = 0;
        if (newIdxs != currentIdxs) {
            System.arraycopy(currentIdxs, 0, newIdxs, 0, pos[0]);
        }
        while (l < removedIdxs.length) {
            if (currentIdxs[pos[l]] == removedIdxs[l]) {
                ++ci;
            }
            int stop = ++l < removedIdxs.length ? pos[l] : currentIdxs.length;
            while (ci < stop) {
                newIdxs[ni] = currentIdxs[ci] - l;
                ++ci;
                ++ni;
            }
        }
        return newIdxs;
    }

    protected static final int[] deleteIdx(int[] idxs, int removeIdx) {
        int i = Arrays.binarySearch(idxs, removeIdx);
        if (i < 0) {
            return idxs;
        }
        int[] newIdxs = new int[idxs.length - 1];
        System.arraycopy(idxs, 0, newIdxs, 0, i);
        System.arraycopy(idxs, i + 1, newIdxs, i, idxs.length - i - 1);
        return newIdxs;
    }

    protected static final int getNewArraySize(int length) {
        if (length >= 0xFFFFFFF) {
            return Integer.MAX_VALUE;
        }
        return (length + 7 | 0xF) + 1;
    }

    protected static final double[] ensureCapacity(double[] currentValues, int length) {
        if (currentValues.length >= length) {
            return currentValues;
        }
        return new double[AbstractRStore.getNewArraySize(length)];
    }

    protected static final int[] ensureCapacity(int[] currentValues, int length) {
        int diff = currentValues.length - length;
        if (diff >= 0 && diff <= 512) {
            return currentValues;
        }
        return new int[AbstractRStore.getNewArraySize(length)];
    }

    protected static final byte[] ensureCapacity(byte[] currentValues, int length) {
        if (currentValues.length >= length) {
            return currentValues;
        }
        return new byte[AbstractRStore.getNewArraySize(length)];
    }

    protected static final String[] ensureCapacity(String[] currentValues, int length) {
        if (currentValues.length >= length) {
            return currentValues;
        }
        return new String[AbstractRStore.getNewArraySize(length)];
    }

    protected static final double[] prepareInsert(double[] currentValues, int currentLength, int[] idxs) {
        double[] newValues = AbstractRStore.ensureCapacity(currentValues, currentLength + idxs.length);
        int i = idxs.length - 1;
        System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, currentLength - idxs[i]);
        --i;
        while (i >= 0) {
            System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, idxs[i + 1] - idxs[i]);
            --i;
        }
        if (newValues != currentValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        return newValues;
    }

    protected static final int[] prepareInsert(int[] currentValues, int currentLength, int[] idxs) {
        int[] newValues = AbstractRStore.ensureCapacity(currentValues, currentLength + idxs.length);
        int i = idxs.length - 1;
        System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, currentLength - idxs[i]);
        --i;
        while (i >= 0) {
            System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, idxs[i + 1] - idxs[i]);
            --i;
        }
        if (newValues != currentValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        return newValues;
    }

    protected static final byte[] prepareInsert(byte[] currentValues, int currentLength, int[] idxs) {
        byte[] newValues = AbstractRStore.ensureCapacity(currentValues, currentLength + idxs.length);
        int i = idxs.length - 1;
        System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, currentLength - idxs[i]);
        --i;
        while (i >= 0) {
            System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, idxs[i + 1] - idxs[i]);
            --i;
        }
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        return newValues;
    }

    protected static final String[] prepareInsert(String[] currentValues, int currentLength, int[] idxs) {
        String[] newValues = AbstractRStore.ensureCapacity(currentValues, currentLength + idxs.length);
        int i = idxs.length - 1;
        System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, currentLength - idxs[i]);
        --i;
        while (i >= 0) {
            System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, idxs[i + 1] - idxs[i]);
            --i;
        }
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        return newValues;
    }

    protected static final double[] remove(double[] currentValues, int currentLength, int[] idxs) {
        double[] newValues = AbstractRStore.ensureCapacity(currentValues, currentLength - idxs.length);
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        int i = 0;
        while (i < idxs.length - 1) {
            System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, idxs[i + 1] - idxs[i]);
            ++i;
        }
        System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, currentLength - idxs[i] - 1);
        return newValues;
    }

    protected static final int[] remove(int[] currentValues, int currentLength, int[] idxs) {
        int[] newValues = AbstractRStore.ensureCapacity(currentValues, currentLength - idxs.length);
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        int i = 0;
        while (i < idxs.length - 1) {
            System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, idxs[i + 1] - idxs[i]);
            ++i;
        }
        System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, currentLength - idxs[i] - 1);
        return newValues;
    }

    protected static final byte[] remove(byte[] currentValues, int currentLength, int[] idxs) {
        byte[] newValues = AbstractRStore.ensureCapacity(currentValues, currentLength - idxs.length);
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        int i = 0;
        while (i < idxs.length - 1) {
            System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, idxs[i + 1] - idxs[i]);
            ++i;
        }
        System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, currentLength - idxs[i] - 1);
        return newValues;
    }

    protected static final String[] remove(String[] currentValues, int currentLength, int[] idxs) {
        String[] newValues = AbstractRStore.ensureCapacity(currentValues, currentLength - idxs.length);
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        int i = 0;
        while (i < idxs.length - 1) {
            System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, idxs[i + 1] - idxs[i]);
            ++i;
        }
        System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, currentLength - idxs[i] - 1);
        return newValues;
    }

    @Override
    public void setNA(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNA(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getLogi(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getLogi(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogi(int idx, boolean logi) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogi(long idx, boolean logi) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(int idx, int integer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(long idx, int integer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getNum(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getNum(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNum(int idx, double real) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNum(long idx, double real) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getChar(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getChar(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setChar(int idx, String character) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setChar(long idx, String character) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getRaw(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getRaw(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRaw(int idx, byte raw) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRaw(long idx, byte raw) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getCplxIm(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getCplxIm(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getCplxRe(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getCplxRe(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCplx(int idx, double real, double imaginary) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCplx(long idx, double real, double imaginary) {
        throw new UnsupportedOperationException();
    }

    protected abstract boolean isStructOnly();

    @Override
    public boolean containsNA() {
        return this.indexOfNA(0L) >= 0L;
    }

    @Override
    public long indexOfNA() {
        return this.indexOfNA(0L);
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        long length = this.getLength();
        while (fromIdx < length) {
            if (this.isNA(fromIdx)) {
                return fromIdx;
            }
            ++fromIdx;
        }
        return -1L;
    }

    @Override
    public boolean contains(int integer) {
        return this.indexOf(integer, 0L) >= 0L;
    }

    @Override
    public final long indexOf(int integer) {
        return this.indexOf(integer, 0L);
    }

    @Override
    public long indexOf(int integer, long fromIdx) {
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        long l = this.getLength();
        while (fromIdx < l) {
            if (!this.isNA(fromIdx) && integer == this.getInt(fromIdx)) {
                return fromIdx;
            }
            ++fromIdx;
        }
        return -1L;
    }

    @Override
    public boolean contains(String character) {
        return this.indexOf(character, 0L) >= 0L;
    }

    @Override
    public final long indexOf(String character) {
        return this.indexOf(character, 0L);
    }

    @Override
    public long indexOf(String character, long fromIdx) {
        if (character == null) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        long l = this.getLength();
        while (fromIdx < l) {
            if (!this.isNA(fromIdx) && character.equals(this.getChar(fromIdx))) {
                return fromIdx;
            }
            ++fromIdx;
        }
        return -1L;
    }

    protected int checkToArrayLength() {
        long length = this.getLength();
        if (length > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Not supported for long data");
        }
        return (int)length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RDataUtils.getStoreAbbr(this));
        sb.append(' ');
        if (this.isStructOnly()) {
            sb.append("<struct only>");
        } else {
            long length = this.getLength();
            if (length > 0L) {
                long end;
                long l = end = length <= 25L ? length : 10L;
                if (this.getStoreType() == 5) {
                    long idx = 0L;
                    while (true) {
                        if (this.isNA(idx)) {
                            sb.append("NA");
                        } else {
                            sb.append('\"');
                            sb.append(this.getChar(idx));
                            sb.append('\"');
                        }
                        if (++idx < end) {
                            sb.append(", ");
                            continue;
                        }
                        if (end != length) {
                            sb.append(", .., ");
                            idx = length - 10L;
                            end = length;
                            continue;
                        }
                        break;
                    }
                } else {
                    long idx = 0L;
                    while (true) {
                        if (this.isNA(idx)) {
                            sb.append("NA");
                        } else {
                            sb.append(this.getChar(idx));
                        }
                        if (++idx < end) {
                            sb.append(", ");
                            continue;
                        }
                        if (end == length) break;
                        sb.append(", .., ");
                        idx = length - 10L;
                        end = length;
                    }
                }
            }
        }
        return sb.toString();
    }
}

