/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.ui;

import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.yaml.core.source.ast.Collection;
import org.eclipse.statet.yaml.ui.YamlUI;
import org.eclipse.statet.yaml.ui.YamlUIResources;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class YamlElementLabelProvider
implements ElementLabelProvider {
    private final YamlUIResources yamlResources = YamlUI.getUIResources();
    private final StringBuilder textBuilder = new StringBuilder(100);

    protected final StringBuilder getTextBuilder() {
        this.textBuilder.setLength(0);
        return this.textBuilder;
    }

    public @Nullable Image getImage(LtkModelElement<?> element) {
        if (element.getModelTypeId() == "Yaml") {
            switch (element.getElementType() & 0xFFF) {
                case 1040: {
                    return this.yamlResources.getImage("org.eclipse.statet.yaml/image/obj/YamlDoc");
                }
                case 2560: {
                    return this.yamlResources.getImage("org.eclipse.statet.yaml/image/obj/YamlSeq");
                }
                case 2576: {
                    return this.yamlResources.getImage("org.eclipse.statet.yaml/image/obj/YamlMap");
                }
                case 2816: {
                    return this.yamlResources.getImage("org.eclipse.statet.yaml/image/obj/YamlScalar");
                }
                case 3584: {
                    return this.yamlResources.getImage("org.eclipse.statet.yaml/image/obj/Alias");
                }
                case 3840: {
                    return SharedUIResources.getInstance().getImage("org.eclipse.statet.ecommons.uimisc/images/obj/dummy");
                }
            }
            return null;
        }
        return null;
    }

    public @Nullable String getText(LtkModelElement<?> element) {
        if (element.getModelTypeId() == "Yaml") {
            return element.getElementName().getDisplayName();
        }
        return null;
    }

    public @Nullable StyledString getStyledText(LtkModelElement<?> element) {
        if (element.getModelTypeId() == "Yaml") {
            StyledString text = new StyledString(element.getElementName().getDisplayName());
            switch (element.getElementType() & 0xFFF) {
                case 2560: 
                case 2576: {
                    AstNode astNode = (AstNode)element.getAdapter(Collection.class);
                    if (astNode == null) break;
                    StringBuilder textBuilder = this.getTextBuilder();
                    textBuilder.append(" (");
                    textBuilder.append(astNode.getChildCount());
                    textBuilder.append(")");
                    text.append(textBuilder.toString(), StyledString.DECORATIONS_STYLER);
                }
            }
            return text;
        }
        return null;
    }
}

