/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProject;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProjects;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;

@NonNullByDefault
public class WorkspaceAdapterFactory
implements IAdapterFactory {
    private static final @NonNull Class<?>[] ADAPTERS = new Class[]{WikitextCoreAccess.class};

    public static WikitextCoreAccess getResourceCoreAccess(IResource resource) {
        WikitextProject wikitextProject = WikitextProjects.getWikitextProject(resource.getProject());
        if (wikitextProject != null) {
            return wikitextProject;
        }
        return WikitextCore.getWorkbenchAccess();
    }

    public static @Nullable WikitextCoreAccess getResourceCoreAccess(@Nullable Object resource) {
        if (resource instanceof IResource) {
            return WorkspaceAdapterFactory.getResourceCoreAccess((IResource)resource);
        }
        return null;
    }

    public @NonNull Class<?>[] getAdapterList() {
        return ADAPTERS;
    }

    public <T> @Nullable T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == WikitextCoreAccess.class) {
            if (adaptableObject instanceof WorkspaceSourceUnit) {
                return (T)WorkspaceAdapterFactory.getResourceCoreAccess(((WorkspaceSourceUnit)adaptableObject).getResource());
            }
            if (adaptableObject instanceof IResource) {
                return (T)WorkspaceAdapterFactory.getResourceCoreAccess((IResource)adaptableObject);
            }
            return (T)WikitextCore.getWorkbenchAccess();
        }
        return null;
    }
}

