/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import com.ibm.icu.text.Collator;
import java.util.Locale;
import org.eclipse.statet.internal.rj.renv.core.REnvCoreInternals;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.renv.core.BasicRPkg;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgType;
import org.eclipse.statet.rj.services.RPlatform;

@NonNullByDefault
public class RPkgUtils {
    public static final Collator NAMES_COLLATOR = REnvCoreInternals.R_NAMES_COLLATOR;

    private static boolean isWin(RPlatform rPlatform) {
        return rPlatform.getOsType().equals("windows");
    }

    private static boolean isMac(RPlatform rPlatform) {
        return rPlatform.getOSName().regionMatches(true, 0, "Mac OS", 0, 6);
    }

    public static @Nullable RPkgType getPkgType(String fileName, RPlatform rPlatform) {
        if (fileName.endsWith(".tar.gz")) {
            return RPkgType.SOURCE;
        }
        if (RPkgUtils.isWin(rPlatform) ? fileName.endsWith(".zip") || fileName.toLowerCase(Locale.ROOT).endsWith(".zip") : RPkgUtils.isMac(rPlatform) && fileName.endsWith(".tgz")) {
            return RPkgType.BINARY;
        }
        return null;
    }

    public static RPkgType checkPkgType(String fileName, RPlatform rPlatform) throws StatusException {
        RPkgType pkgType = RPkgUtils.getPkgType(fileName, rPlatform);
        if (pkgType == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services.core", String.format("Invalid file name '%1$s' (unsupported extension) for R package on %2$s.", fileName, rPlatform.getOSName())));
        }
        return pkgType;
    }

    public static RPkg checkPkgFileName(String fileName) throws StatusException {
        int extIdx;
        if (fileName.endsWith(".tar.gz")) {
            extIdx = fileName.length() - 7;
        } else if (fileName.endsWith(".zip") || fileName.endsWith(".tgz")) {
            extIdx = fileName.length() - 4;
        } else {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services.core", String.format("Invalid file name '%1$s' (unsupported extension) for R package.", fileName)));
        }
        int versionIdx = fileName.indexOf(95);
        if (versionIdx < 0) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services.core", String.format("Invalid file name '%1$s' (missing version) for R package.", fileName)));
        }
        return new BasicRPkg(fileName.substring(0, versionIdx), RNumVersion.create(fileName.substring(versionIdx + 1, extIdx)));
    }

    public static @Nullable String getPkgTypeInstallKey(RPlatform rPlatform, RPkgType pkgType) {
        if (pkgType == RPkgType.SOURCE) {
            return "source";
        }
        if (pkgType == RPkgType.BINARY) {
            if (RPkgUtils.isWin(rPlatform)) {
                return "win.binary";
            }
            if (RPkgUtils.isMac(rPlatform)) {
                return "mac.binary.leopard";
            }
        }
        return null;
    }
}

