/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rhelp;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class JettyServer {
    private static final String WEBAPP_NAME = "rhelp";
    private static final String OTHER_INFO = "org.eclipse.statet.r.rhelp";
    private static final String LOCALHOST = "127.0.0.1";
    private final String host = this.loadHost();
    private int port = -1;

    protected String loadHost() {
        String serverProperty = RCorePlugin.getInstance().getBundle().getBundleContext().getProperty("server_host");
        if (serverProperty != null && (serverProperty = serverProperty.trim()).length() > 0) {
            return serverProperty;
        }
        return LOCALHOST;
    }

    public void startServer() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.http.registry");
        if (bundle == null) {
            throw new IllegalStateException("bundle 'org.eclipse.equinox.http.registry' is missing.");
        }
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("http.host", this.host);
        ((Dictionary)dict).put("http.port", this.port == -1 ? 0 : this.port);
        ((Dictionary)dict).put("context.path", "/rhelp");
        ((Dictionary)dict).put("other.info", OTHER_INFO);
        ((Dictionary)dict).put("context.sessioninactiveinterval", 1800);
        JettyConfigurator.startServer((String)WEBAPP_NAME, dict);
        if (bundle.getState() == 4) {
            bundle.start(1);
        }
        if (this.port == -1) {
            ServiceReference[] reference = bundle.getBundleContext().getServiceReferences("org.osgi.service.http.HttpService", "(other.info=org.eclipse.statet.r.rhelp)");
            Object assignedPort = reference[0].getProperty("http.port");
            this.port = Integer.parseInt((String)assignedPort);
        }
    }

    public void stopServer() throws Exception {
        JettyConfigurator.stopServer((String)WEBAPP_NAME);
        this.port = -1;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

