/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.source.ast.Arithmetic;
import org.eclipse.statet.r.core.source.ast.Assignment;
import org.eclipse.statet.r.core.source.ast.Block;
import org.eclipse.statet.r.core.source.ast.CForLoop;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.CRepeatLoop;
import org.eclipse.statet.r.core.source.ast.CWhileLoop;
import org.eclipse.statet.r.core.source.ast.Dummy;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.Group;
import org.eclipse.statet.r.core.source.ast.Help;
import org.eclipse.statet.r.core.source.ast.Logical;
import org.eclipse.statet.r.core.source.ast.Model;
import org.eclipse.statet.r.core.source.ast.NSGet;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.NumberConst;
import org.eclipse.statet.r.core.source.ast.Pipe;
import org.eclipse.statet.r.core.source.ast.Power;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.Relational;
import org.eclipse.statet.r.core.source.ast.Seq;
import org.eclipse.statet.r.core.source.ast.Sign;
import org.eclipse.statet.r.core.source.ast.SourceComponent;
import org.eclipse.statet.r.core.source.ast.Special;
import org.eclipse.statet.r.core.source.ast.StringConst;
import org.eclipse.statet.r.core.source.ast.SubIndexed;
import org.eclipse.statet.r.core.source.ast.SubNamed;
import org.eclipse.statet.r.core.source.ast.Symbol;

@NonNullByDefault
class RScannerPostExprVisitor
extends RAstVisitor {
    static final int SYNTAXERROR_MASK = 0x4400000;
    private boolean syntaxError;

    RScannerPostExprVisitor() {
    }

    public int check(RAstNode node) {
        this.syntaxError = false;
        try {
            node.acceptInR(this);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.syntaxError) {
            return 0x4000000;
        }
        return 0;
    }

    public int checkTerminal(RAstNode node) {
        if ((node.getStatusCode() & 0x4400000) != 0) {
            return 0x4000000;
        }
        return 0;
    }

    private void doAcceptIn(RAstNode child) throws InvocationTargetException {
        boolean savedSyntaxError = this.syntaxError;
        this.syntaxError = false;
        child.acceptInR(this);
        if (this.syntaxError) {
            child.rParent.status |= 0x4000000;
        }
        this.syntaxError |= savedSyntaxError;
    }

    private void doAccecptInChildren(RAstNode node) throws InvocationTargetException {
        boolean savedSyntaxError = this.syntaxError;
        this.syntaxError = false;
        node.acceptInRChildren(this);
        if (this.syntaxError) {
            node.status |= 0x4000000;
        }
        this.syntaxError |= savedSyntaxError;
    }

    private void markSubsequentIfStatus12(RAstNode node, int status) {
        if ((node.getStatusCode() & 0x7FFFF0) == status) {
            node.status |= 0x800000;
        }
    }

    @Override
    public void visit(SourceComponent node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Block node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Group node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(CIfElse node) throws InvocationTargetException {
        if (node.withElse) {
            this.doAcceptIn(node.elseExpr.node);
        }
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(CForLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(CRepeatLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(CWhileLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(FCall node) throws InvocationTargetException {
        this.doAcceptIn(node.refExpr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(FCall.Args node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(FCall.Arg node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(FDef node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(FDef.Args node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(FDef.Arg node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Assignment node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Pipe node) throws InvocationTargetException {
        RAstNode target = node.getTargetChild();
        if (target.getNodeType() != NodeType.F_CALL && (target.getStatusCode() & 0x7FFFF0) != 4228016) {
            target.status = 4227504;
        }
        if ((node.getStatusCode() & 0x7FFFF0) == 4228880) {
            this.markSubsequentIfStatus12(node.getSourceChild(), 4227858);
            this.markSubsequentIfStatus12(target, 4228016);
            this.markSubsequentIfStatus12(target, 4227504);
        }
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Model node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Relational node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Logical node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Arithmetic node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Power node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Seq node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Special node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Sign node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(SubIndexed node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(SubIndexed.Args node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(SubIndexed.Arg node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(SubNamed node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(NSGet node) throws InvocationTargetException {
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(StringConst node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(NumberConst node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Symbol node) {
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Help node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.syntaxError |= (node.getStatusCode() & 0x4400000) != 0;
    }
}

