/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.docmlet.tex.core.commands.EnvDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.source.LtxHeuristicTokenScanner;
import org.eclipse.statet.docmlet.tex.ui.TexUIResources;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.viewers.ViewerLabelUtils;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxArgumentListContextInformation;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAssistInvocationContext;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.TexBracketLevel;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntIntervalArrays;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class LtxCommandCompletionProposal
extends SourceProposal<LtxAssistInvocationContext> {
    protected final TexCommand command;

    private static final boolean isFollowedByOpeningBracket(int forwardOffset, boolean allowSquare, LtxAssistInvocationContext context) {
        LtxHeuristicTokenScanner scanner = context.getLtxHeuristicTokenScanner();
        scanner.configure(context.getDocument());
        int idx = scanner.findAnyNonBlankForward(forwardOffset, -2, false);
        return idx >= 0 && (scanner.getChar() == '{' || allowSquare && scanner.getChar() == '[');
    }

    private static final boolean isClosedBracket(int backwardOffset, int forwardOffset, LtxAssistInvocationContext context) {
        boolean searchType = false;
        int[] balance = new int[3];
        balance[0] = balance[0] + 1;
        LtxHeuristicTokenScanner scanner = context.getLtxHeuristicTokenScanner();
        scanner.configureDefaultPartitions(context.getDocument());
        balance = scanner.computeBracketBalance(backwardOffset, forwardOffset, balance, 0);
        return balance[0] <= 0;
    }

    protected LtxCommandCompletionProposal(LtxCommandProposalParameters parameters) {
        super((SourceProposal.ProposalParameters)parameters);
        this.command = (TexCommand)ObjectUtils.nonNullAssert((Object)parameters.command);
    }

    protected String getName() {
        return this.command.getControlWord();
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            LtxAssistInvocationContext context = (LtxAssistInvocationContext)this.getInvocationContext();
            IDocument document = context.getDocument();
            --end;
            block3: while (++end < document.getLength()) {
                switch (document.getChar(end)) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
            }
        }
        return end - replacementOffset;
    }

    public String getSortingString() {
        return this.command.getControlWord();
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    protected StyledString computeStyledText() {
        StyledString styledText = new StyledString((this.command.getType() & 0xF) == 2 ? this.command.getControlWord() : "\\" + this.command.getControlWord());
        for (TexCommand.Parameter param : this.command.getParameters()) {
            if ((param.getType() & 2) != 0) {
                styledText.append("[]");
                continue;
            }
            styledText.append("{}");
        }
        styledText.append(" \u2013 " + this.command.getDescription(), StyledString.QUALIFIER_STYLER);
        return styledText;
    }

    protected void styleMatchingRegions(StyledString styledText, int matchRule, int[] matchingRegions, BoldStylerProvider boldStylerProvider) {
        matchingRegions = IntIntervalArrays.insertRegion((int[])matchingRegions, (int)0, (int)1);
        ViewerLabelUtils.setStyle((StyledString)styledText, (int[])matchingRegions, (StyledString.Styler)boldStylerProvider.getBoldStyler());
    }

    public Image getImage() {
        return TexUIResources.INSTANCE.getCommandImage(this.command);
    }

    public boolean isAutoInsertable() {
        return true;
    }

    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        ImList parameters;
        LtxAssistInvocationContext context = (LtxAssistInvocationContext)this.getInvocationContext();
        IDocument document = context.getDocument();
        SourceProposal.ApplyData applyData = this.getApplyData();
        StringBuilder replacement = new StringBuilder(this.command.getControlWord());
        if ((stateMask & 1) == 1) {
            replacement.insert(0, '\\');
        }
        int cursor = replacement.length();
        int mode = 0;
        IntArrayList positions = null;
        if (this.command == EnvDefinitions.VERBATIM_verb_COMMAND) {
            mode = 201;
        } else if ((this.command.getType() & 0xF) != 2 && (parameters = this.command.getParameters()) != null && !parameters.isEmpty()) {
            boolean isFirstOptional = ((TexCommand.Parameter)parameters.get(0)).isOptional();
            int idxFirstRequired = -1;
            int i = isFirstOptional ? 1 : 0;
            while (i < parameters.size()) {
                TexCommand.Parameter param = (TexCommand.Parameter)parameters.get(i);
                if (param.isRequired()) {
                    idxFirstRequired = i;
                    break;
                }
                ++i;
            }
            if (idxFirstRequired >= 0) {
                if (replacementOffset + replacementLength < document.getLength() - 1 && (document.getChar(replacementOffset + replacementLength) == '{' || isFirstOptional && document.getChar(replacementOffset + replacementLength) == '[')) {
                    ++cursor;
                    mode = 10;
                } else if (!LtxCommandCompletionProposal.isFollowedByOpeningBracket(replacementOffset + replacementLength, isFirstOptional, context)) {
                    replacement.append('{');
                    ++cursor;
                    mode = 11;
                }
                if (mode >= 10 && mode == 11 && !LtxCommandCompletionProposal.isClosedBracket(replacementOffset, replacementOffset + replacementLength, context)) {
                    replacement.append('}');
                    positions = new IntArrayList();
                    mode = 0;
                    if (isFirstOptional) {
                        positions.add(mode);
                    }
                    int n = ++mode;
                    ++mode;
                    positions.add(n);
                    i = idxFirstRequired + 1;
                    while (i < parameters.size()) {
                        if (((TexCommand.Parameter)parameters.get(i)).isRequired()) {
                            replacement.append("{}");
                            int n2 = ++mode;
                            ++mode;
                            positions.add(n2);
                        } else if (positions.getAt(positions.size() - 1) != mode) {
                            positions.add(mode);
                        }
                        ++i;
                    }
                    if (positions.getAt(positions.size() - 1) != mode) {
                        positions.add(mode);
                    }
                    mode = 111;
                }
            }
        }
        document.replace(replacementOffset, replacementLength, replacement.toString());
        applyData.setSelection(replacementOffset + cursor);
        if (mode > 100 && mode < 200) {
            this.createLinkedMode(replacementOffset + cursor - (mode - 110), (IntList)positions).enter();
        } else if (mode > 200 && mode < 300) {
            this.createLinkedVerbMode(replacementOffset + cursor);
        }
        if ((this.command.getType() & 0xF) == 1) {
            this.reinvokeAssist();
        }
    }

    private LinkedModeUI createLinkedMode(int offset, IntList positions) throws BadLocationException {
        LtxAssistInvocationContext context = (LtxAssistInvocationContext)this.getInvocationContext();
        IDocument document = context.getDocument();
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        ArrayList<LinkedPosition> linked = new ArrayList<LinkedPosition>(positions.size());
        int i = 0;
        while (i < positions.size() - 1) {
            LinkedPosition linkedPosition;
            LinkedPositionGroup group = new LinkedPositionGroup();
            if (positions.getAt(i) % 2 == 1) {
                linkedPosition = TexBracketLevel.createPosition('{', document, offset + positions.getAt(i), 0, pos++);
            } else {
                ++pos;
                linkedPosition = new LinkedPosition(document, offset + positions.getAt(i), 0, pos);
            }
            LinkedPosition position = linkedPosition;
            group.addPosition(position);
            linked.add(position);
            model.addGroup(group);
            ++i;
        }
        model.forceInstall();
        TexBracketLevel level = new TexBracketLevel(model, document, context.getEditor().getDocumentContentInfo(), linked, 0x1000000);
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)context.getSourceViewer());
        ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
        ui.setExitPosition((ITextViewer)context.getSourceViewer(), offset + positions.getAt(positions.size() - 1), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    private void createLinkedVerbMode(int offset) throws BadLocationException {
        LtxAssistInvocationContext context = (LtxAssistInvocationContext)this.getInvocationContext();
        IDocument document = context.getDocument();
        final LinkedSepMode mode = new LinkedSepMode(context.getSourceViewer(), document, offset);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                mode.install();
            }
        });
    }

    public static class ContextInformationProposal
    extends LtxCommandCompletionProposal {
        public ContextInformationProposal(LtxCommandProposalParameters parameters) {
            super(parameters);
        }

        @Override
        public boolean isAutoInsertable() {
            return true;
        }

        @Override
        protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
            SourceProposal.ApplyData applyData = this.getApplyData();
            applyData.clearSelection();
            applyData.setContextInformation((IContextInformation)new LtxArgumentListContextInformation(this.getReplacementOffset(), this.command));
        }
    }

    public static class Env
    extends LtxCommandCompletionProposal {
        protected Env(LtxCommandProposalParameters parameters) {
            super(parameters);
        }

        @Override
        protected StyledString computeStyledText() {
            StyledString styledText = new StyledString(this.command.getControlWord());
            styledText.append("\u2002\u2013\u2002", StyledString.QUALIFIER_STYLER);
            styledText.append(this.command.getDescription(), StyledString.QUALIFIER_STYLER);
            return styledText;
        }
    }

    private static class LinkedSepMode
    implements IDocumentListener,
    VerifyKeyListener {
        private final SourceViewer viewer;
        private final IDocument document;
        private final int offset;
        private boolean inserted;
        private boolean intern;

        public LinkedSepMode(SourceViewer viewer, IDocument document, int offset) {
            this.viewer = viewer;
            this.document = document;
            this.offset = offset;
        }

        public void install() {
            if (UIAccess.isOkToUse((Viewer)this.viewer)) {
                this.viewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this);
                this.document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void verifyKey(VerifyEvent event) {
            if (this.viewer.getDocument() == this.document) {
                Point selection = this.viewer.getSelectedRange();
                if (!this.inserted && selection.x == this.offset && selection.y == 0 && event.character != '\u0000') {
                    try {
                        char currentChar = this.offset < this.document.getLength() ? (char)this.document.getChar(this.offset) : (char)'\n';
                        char c = event.character;
                        if (currentChar <= ' ' && currentChar != c && c >= ' ' && !Character.isLetterOrDigit(c)) {
                            this.intern = true;
                            this.document.replace(this.offset, 0, "" + c + c);
                            this.inserted = true;
                            event.doit = false;
                            this.viewer.setSelection((ISelection)new TextSelection(this.offset + 1, 0), true);
                            return;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        this.intern = false;
                    }
                }
                if (this.inserted && event.character == '\b' && selection.x == this.offset + 1 && selection.y == 0) {
                    try {
                        this.intern = true;
                        this.document.replace(this.offset, 2, "");
                        this.inserted = false;
                        event.doit = false;
                        return;
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        this.intern = false;
                    }
                }
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (!this.intern) {
                this.dispose();
            }
        }

        private void dispose() {
            this.viewer.getTextWidget().removeVerifyKeyListener((VerifyKeyListener)this);
            this.document.removeDocumentListener((IDocumentListener)this);
        }
    }

    public static class LtxCommandProposalParameters
    extends SourceProposal.ProposalParameters<LtxAssistInvocationContext> {
        public TexCommand command;

        public LtxCommandProposalParameters(LtxAssistInvocationContext context, int replacementOffset, SearchPattern namePattern, int baseRelevance) {
            super((AssistInvocationContext)context, replacementOffset, namePattern, baseRelevance);
        }

        public LtxCommandProposalParameters(LtxAssistInvocationContext context, int replacementOffset, SearchPattern namePattern) {
            super((AssistInvocationContext)context, replacementOffset, namePattern);
        }

        public LtxCommandProposalParameters(LtxAssistInvocationContext context, TexCommand command) {
            super((AssistInvocationContext)context, context.getInvocationOffset(), 0);
            this.command = command;
        }

        public LtxCommandProposalParameters(LtxAssistInvocationContext context, int replacementOffset) {
            super((AssistInvocationContext)context, replacementOffset, 0);
        }
    }
}

