/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.internal.docmlet.tex.ui.TexUIMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CommandAssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.LinkedNamesAssistProposal;

@NonNullByDefault
public class TexLinkedNamesAssistProposal
extends LinkedNamesAssistProposal<AssistInvocationContext> {
    public static final int IN_FILE = 1;
    private final TexNameAccess access;
    private final int mode;

    public TexLinkedNamesAssistProposal(int mode, AssistInvocationContext invocationContext, TexNameAccess access) {
        super(TexLinkedNamesAssistProposal.init(invocationContext, mode, false));
        this.mode = mode;
        this.access = access;
    }

    private static CommandAssistProposal.ProposalParameters<AssistInvocationContext> init(AssistInvocationContext invocationContext, int mode, boolean withRegion) {
        switch (mode) {
            case 1: {
                return new CommandAssistProposal.ProposalParameters(invocationContext, "org.eclipse.statet.ltk.commands.QuickAssistRenameInFile", TexUIMessages.Proposal_RenameInFile_label, TexUIMessages.Proposal_RenameInFile_description, 90);
            }
        }
        throw new IllegalArgumentException();
    }

    protected void collectPositions(IDocument document, LinkedPositionGroup group) throws BadLocationException {
        TexAstNode nameNode;
        ImIdentityList allAccess = ImCollections.toIdentityList((Collection)this.access.getAllInUnit());
        int current = allAccess.indexOf((Object)this.access);
        if (current < 0) {
            return;
        }
        int idx = 0;
        TexAstNode nameNode2 = (TexAstNode)ObjectUtils.nonNullAssert((Object)((TexAstNode)this.access.getNameNode()));
        idx = this.addPosition(group, document, nameNode2, idx);
        if (idx == 0) {
            return;
        }
        if (this.mode == 1) {
            int i = current + 1;
            while (i < allAccess.size()) {
                nameNode = (TexAstNode)((TexNameAccess)allAccess.get(i)).getNameNode();
                if (nameNode != null) {
                    idx = this.addPosition(group, document, nameNode, idx);
                }
                ++i;
            }
        }
        if (this.mode == 1) {
            int i = 0;
            while (i < current) {
                nameNode = (TexAstNode)((TexNameAccess)allAccess.get(i)).getNameNode();
                if (nameNode != null) {
                    idx = this.addPosition(group, document, nameNode, idx);
                }
                ++i;
            }
        }
    }

    protected int addPosition(LinkedPositionGroup group, IDocument document, TexAstNode nameNode, int idx) throws BadLocationException {
        return this.addPosition(group, document, TexNameAccess.getTextPosition((TexAstNode)nameNode), idx);
    }
}

