/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.IndexedVariablePartition;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.ecommons.models.core.util.ElementPartitionFactory;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class VariablePartition<TValue extends IndexedValue>
extends DebugElement
implements IndexedVariablePartition,
IValue {
    protected final TValue value;
    private final ElementPartitionFactory.PartitionHandle partition;

    public VariablePartition(TValue value, ElementPartitionFactory.PartitionHandle partition) {
        super(value.getDebugTarget());
        this.value = value;
        this.partition = partition;
    }

    public String getModelIdentifier() {
        return this.value.getModelIdentifier();
    }

    public final long getPartitionStart() {
        return this.partition.getStart();
    }

    public final long getPartitionLength() {
        return this.partition.getLength();
    }

    protected int getNameIndexBase() {
        return 0;
    }

    protected @Nullable String getNameIndexLabel(long idx) {
        return null;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        long startIndex = this.getPartitionStart() + (long)this.getNameIndexBase();
        sb.append('[');
        sb.append(startIndex);
        sb.append(" ... ");
        sb.append(startIndex + (this.getPartitionLength() - 1L));
        sb.append(']');
        String label = this.getNameIndexLabel(this.getPartitionStart());
        if (label != null) {
            sb.append("  ");
            sb.append(label);
            sb.append(" ... ");
            label = this.getNameIndexLabel(this.getPartitionStart() + (this.getPartitionLength() - 1L));
            if (label != null) {
                sb.append(label);
            }
        }
        return sb.toString();
    }

    public IValue getValue() throws DebugException {
        return this;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public String getReferenceTypeName() throws DebugException {
        return "";
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public @NonNull IVariable[] getVariables() throws DebugException {
        try {
            return (IVariable[])this.partition.getElements(this.value);
        }
        catch (UnsupportedOperationException e) {
            throw VariablePartitionFactory.newNotSupported(e);
        }
        catch (IllegalArgumentException e) {
            throw VariablePartitionFactory.newRequestInvalidFailed(e);
        }
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        throw VariablePartitionFactory.newNotSupported();
    }

    public void setValue(String expression) throws DebugException {
        throw VariablePartitionFactory.newNotSupported();
    }

    public boolean verifyValue(IValue value) throws DebugException {
        throw VariablePartitionFactory.newNotSupported();
    }

    public void setValue(IValue value) throws DebugException {
        throw VariablePartitionFactory.newNotSupported();
    }

    public int hashCode() {
        return this.value.hashCode() + this.partition.hashCode();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VariablePartition)) {
            return false;
        }
        @NonNull VariablePartition other = (VariablePartition)obj;
        return this.value.equals(other.value) && this.partition.equals(other.partition);
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        return (T)super.getAdapter(adapterType);
    }
}

