/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime.bundle;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntryProvider;
import org.eclipse.statet.jcommons.runtime.bundle.BundleResolver;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.MultiStatus;

@NonNullByDefault
public class DefaultBundleResolver
implements BundleResolver {
    public static final String ID = "BundleEntryProvider";
    private final BundleEntryProvider entryProvider;
    private @Nullable ImList<? extends BundleEntry> knownEntries;

    public DefaultBundleResolver(BundleEntryProvider entryProvider) {
        this.entryProvider = entryProvider;
    }

    protected ImList<? extends BundleEntry> gatherKnownEntries() {
        ArrayList<BundleEntry> entries = new ArrayList<BundleEntry>();
        this.entryProvider.getEntries(entries);
        return ImCollections.toList(entries);
    }

    @Override
    public boolean resolveBundle(BundleSpec bundleSpec, Set<BundleEntry> resolved, MultiStatus status) {
        ImList<? extends BundleEntry> knownEntries = this.knownEntries;
        if (knownEntries == null) {
            this.knownEntries = knownEntries = this.gatherKnownEntries();
        }
        for (BundleEntry bundleEntry : knownEntries) {
            if (!bundleEntry.getBundleId().equals(bundleSpec.getId())) continue;
            resolved.add(bundleEntry);
            return true;
        }
        return false;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("BundleResolver", this.getClass());
        sb.append(' ', ID);
        sb.addProp("entryProvider", this.entryProvider);
        return sb.toString();
    }
}

