/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.internal.r.console.core.RConsoleCorePlugin;
import org.eclipse.statet.internal.r.nico.RNicoMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.runtime.ProcessUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.nico.impl.RTermController;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;

@NonNullByDefault
class RTermCancelRunnable
implements ToolRunnable {
    RTermCancelRunnable() {
    }

    public String getLabel() {
        return RNicoMessages.RTerm_CancelTask_label;
    }

    public String getTypeId() {
        return null;
    }

    public boolean changed(int event, Tool process) {
        return true;
    }

    public boolean canRunIn(Tool tool) {
        return true;
    }

    public void run(ToolService service, ProgressMonitor m) throws StatusException {
        IRBasicAdapter r = (IRBasicAdapter)service;
        REnvConfiguration rEnvConfig = (REnvConfiguration)ObjectUtils.nonNullAssert((Object)r.getTool().getAdapter(REnvConfiguration.class));
        String arch = rEnvConfig.getRArch();
        if (arch == null) {
            arch = SystemUtils.getLocalArch();
        }
        try {
            m.beginTask(RNicoMessages.RTerm_CancelTask_SendSignal_label, 10);
            URL url = RConsoleCorePlugin.getInstance().getBundle().getEntry("/win32/" + arch + "/sendsignal.exe");
            if (url == null) {
                throw new IOException("Missing 'sendsignal' tool for arch '" + arch + "'.");
            }
            File file = new File((url = FileLocator.toFileURL((URL)url)).getPath());
            if (!file.exists()) {
                throw new IOException("Missing file '" + url.toExternalForm() + "'.");
            }
            m.addWorked(1);
            RTermController controller = (RTermController)r.getController();
            Process rProcess = controller.getProcess();
            if (rProcess == null) {
                return;
            }
            ProcessBuilder processBuilder = new ProcessBuilder(file.getAbsolutePath(), Long.toString(rProcess.pid()));
            processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            m.addWorked(1);
            while (true) {
                try {
                    int code = process.exitValue();
                    if (code != 0) {
                        ObjectUtils.ToStringBuilder detail = new ObjectUtils.ToStringBuilder("Command failed:");
                        detail.addProp("command", ProcessUtils.generateCommandLine(processBuilder.command()));
                        detail.addProp("os.name", System.getProperty("os.name"));
                        detail.addProp("os.version", System.getProperty("os.version"));
                        detail.addProp("os.arch", System.getProperty("os.arch"));
                        detail.addProp("r.arch", arch);
                        detail.addProp("exit.code", "0x" + Integer.toHexString(code));
                        throw new IOException(detail.toString());
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (m.isCanceled()) {
                        process.destroy();
                        RConsoleCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.r.console.core", -1, "Sending CTRL+C to R process canceled.", null));
                        break;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new StatusException((org.eclipse.statet.jcommons.status.Status)new WarningStatus("org.eclipse.statet.r.console.core", "Error Sending CTRL+C to R process.", (Throwable)e));
        }
    }
}

