/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.wikitext.core.WikitextBuildParticipant;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocWorkspaceSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProject;
import org.eclipse.statet.internal.redocs.wikitext.r.core.model.WikidocRweaveSuModelContainer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RProjects;
import org.eclipse.statet.r.core.rmodel.RModel;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.build.RModelIndexUpdate;
import org.eclipse.statet.redocs.wikitext.r.core.model.WikidocRweaveSourceUnit;

@NonNullByDefault
public class WikitextRweaveBuildParticipant
extends WikitextBuildParticipant {
    private static final ImList<String> WIKITEXT_R_MODEL_TYPES = ImCollections.newList((Object)"WikidocRweave");
    private RModelIndexUpdate rIndexUpdate = (RModelIndexUpdate)ObjectUtils.nonNullLateInit();

    public void init() {
        super.init();
        RProject rProject = RProjects.getRProject((IProject)((WikitextProject)this.getLtkProject()).getProject());
        if (rProject != null) {
            this.setEnabled(true);
            this.rIndexUpdate = new RModelIndexUpdate(rProject, WIKITEXT_R_MODEL_TYPES, this.getBuildType() == 6);
        }
    }

    public void handleSourceUnitUpdated(WikidocWorkspaceSourceUnit sourceUnit, SubMonitor m) throws CoreException {
        if (sourceUnit instanceof WikidocRweaveSourceUnit) {
            WikidocRweaveSourceUnit unit = (WikidocRweaveSourceUnit)sourceUnit;
            WikidocRweaveSuModelContainer modelContainer = (WikidocRweaveSuModelContainer)((Object)unit.getAdapter(WikidocSourceUnitModelContainer.class));
            if (modelContainer != null) {
                this.rIndexUpdate.update((RSourceUnit)unit, RModel.getRModelInfo((SourceUnitModelInfo)modelContainer.getCurrentModel()));
            } else {
                this.rIndexUpdate.remove((RSourceUnit)unit);
            }
        }
    }

    public void handleSourceUnitRemoved(IFile file, SubMonitor m) throws CoreException {
        this.rIndexUpdate.remove(file);
    }

    public void finish(SubMonitor m) throws CoreException {
        this.rIndexUpdate.submit((IProgressMonitor)m);
    }
}

