/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core.util;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.FilterParserInput;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.jcommons.text.core.util.HtmlUtils;

@NonNullByDefault
public class HtmlStripParserInput
extends FilterParserInput {
    public HtmlStripParserInput(TextParserInput source, int defaultBufferSize) {
        super(source, defaultBufferSize);
    }

    public HtmlStripParserInput(TextParserInput source) {
        this(source, 2048);
    }

    public HtmlStripParserInput(String source) {
        this(new StringParserInput(source).init(), Math.min(source.length(), 2048));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int read(TextParserInput in, char[] buffer, int[] beginIndexes, int[] endIndexes, int beginIdx, int requiredEnd, int recommendEnd) {
        int idx = beginIdx;
        block5: while (idx < recommendEnd) {
            int c0 = in.get(0);
            switch (c0) {
                case -1: {
                    break block5;
                }
                case 60: {
                    if (!this.consumeTag(in)) break;
                    continue block5;
                }
                case 38: {
                    Match match = this.readEntity(in);
                    if (match == null) break;
                    if (idx + match.chars.length > buffer.length) break block5;
                    int beginIndex = in.getIndex();
                    int endIndex = beginIndex + in.getLengthInSource(match.n);
                    int i = 0;
                    while (true) {
                        if (i >= match.chars.length) {
                            in.consume(match.n);
                            continue block5;
                        }
                        buffer[idx] = match.chars[i];
                        beginIndexes[idx] = beginIndex;
                        endIndexes[idx] = endIndex;
                        ++i;
                        ++idx;
                    }
                }
            }
            buffer[idx] = (char)c0;
            beginIndexes[idx] = in.getIndex();
            endIndexes[idx] = in.getIndex() + in.getLengthInSource(1);
            ++idx;
            in.consume(1);
        }
        beginIndexes[idx] = in.getIndex();
        return idx;
    }

    private boolean consumeTag(TextParserInput in) {
        switch (in.get(1)) {
            case 63: {
                int n = 2;
                block21: while (true) {
                    switch (in.get(n++)) {
                        case -1: {
                            in.consume(n - 1);
                            return true;
                        }
                        case 34: {
                            n = this.consumeQuoteD(in, n);
                            continue block21;
                        }
                        case 39: {
                            n = this.consumeQuoteS(in, n);
                            continue block21;
                        }
                        case 63: {
                            if (in.get(n) != 62) break;
                            in.consume(n + 1);
                            return true;
                        }
                    }
                    if (n < 1024) continue;
                    in.consume(n);
                    n = 0;
                }
            }
            case 33: {
                if (in.matches(2, '-', '-')) {
                    int n = 4;
                    while (true) {
                        switch (in.get(n++)) {
                            case -1: {
                                in.consume(n - 1);
                                return true;
                            }
                            case 62: {
                                if (!in.matches(n - 3, '-', '-')) break;
                                in.consume(n);
                                return true;
                            }
                        }
                        if (n < 1024) continue;
                        in.consume(n);
                        n = 0;
                    }
                }
            }
            case 47: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                int n = 2;
                block23: while (true) {
                    switch (in.get(n++)) {
                        case -1: {
                            in.consume(n - 1);
                            return true;
                        }
                        case 34: {
                            n = this.consumeQuoteD(in, n);
                            continue block23;
                        }
                        case 39: {
                            n = this.consumeQuoteS(in, n);
                            continue block23;
                        }
                        case 62: {
                            in.consume(n);
                            return true;
                        }
                    }
                    if (n < 1024) continue;
                    in.consume(n);
                    n = 0;
                }
            }
        }
        return false;
    }

    private int consumeQuoteD(TextParserInput in, int n) {
        while (true) {
            switch (in.get(n++)) {
                case -1: {
                    return n - 1;
                }
                case 34: {
                    return n;
                }
            }
            if (n < 1024) continue;
            in.consume(n);
            n = 0;
        }
    }

    private int consumeQuoteS(TextParserInput in, int n) {
        while (true) {
            switch (in.get(n++)) {
                case -1: {
                    return n - 1;
                }
                case 39: {
                    return n;
                }
            }
            if (n < 1024) continue;
            in.consume(n);
            n = 0;
        }
    }

    private @Nullable Match readEntity(TextParserInput in) {
        switch (in.get(1)) {
            case 35: {
                switch (in.get(2)) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        int n = 3;
                        block20: while (n < 10) {
                            switch (in.get(n++)) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break;
                                }
                                case 59: {
                                    return HtmlStripParserInput.resolveEntity(in, Integer.parseInt(in.getString(2, n - 1), 10), n);
                                }
                                default: {
                                    break block20;
                                }
                            }
                        }
                        return null;
                    }
                    case 88: 
                    case 120: {
                        int n = 3;
                        block21: while (n < 10) {
                            switch (in.get(n++)) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: 
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    break;
                                }
                                case 59: {
                                    if (n <= 4) break block21;
                                    return HtmlStripParserInput.resolveEntity(in, Integer.parseInt(in.getString(3, n - 1), 16), n);
                                }
                                default: {
                                    break block21;
                                }
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                int n = 2;
                block22: while (n < 40) {
                    switch (in.get(n++)) {
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: {
                            break;
                        }
                        case 59: {
                            return HtmlStripParserInput.resolveEntity(in, in.getString(1, n - 1), n);
                        }
                        default: {
                            break block22;
                        }
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static @Nullable Match resolveEntity(TextParserInput in, int codePoint, int n) {
        try {
            return new Match(Character.toChars(codePoint), n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static @Nullable Match resolveEntity(TextParserInput in, String name, int n) {
        HtmlUtils.Entity entity = HtmlUtils.getNamedEntity(name);
        if (entity != null) {
            return new Match(entity.getChars(), n);
        }
        return null;
    }

    private static class Match {
        private final char[] chars;
        private final int n;

        public Match(char[] chars, int n) {
            this.chars = chars;
            this.n = n;
        }
    }
}

