/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.NatTableLayerDim;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.top.OverlayPainter;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.resize.core.DimPositionResizeCommand;
import org.eclipse.statet.ecommons.waltable.ui.action.IDragMode;
import org.eclipse.statet.ecommons.waltable.ui.util.CellEdgeDetectUtil;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class PositionResizeDragMode
implements IDragMode {
    private static final int DEFAULT_WIDTH_MINIMUM = 25;
    private static final int RESIZE_OVERLAY_SIZE = 2;
    private final Orientation orientation;
    private long positionToResize;
    private int positionStart;
    private int positionSize;
    private int startPixel;
    private int currentPixel;
    private int lastPixel = -1;
    private final OverlayPainter overlayPainter;

    private static void addPositions(long pixel, LayerDim dim, LRangeList positions) {
        long endPixel;
        long startPixel = Math.max(pixel - 1L, 0L);
        if (startPixel < (endPixel = Math.min(pixel + 1L, dim.getSize() - 1L))) {
            positions.add(new LRange(dim.getPositionByPixel(startPixel), dim.getPositionByPixel(endPixel) + 1L));
        }
    }

    public PositionResizeDragMode(Orientation orientation) {
        this.orientation = orientation;
        this.overlayPainter = orientation == Orientation.HORIZONTAL ? new ColumnResizeOverlayPainter() : new RowResizeOverlayPainter();
    }

    private int getMinPositionSize() {
        return 25;
    }

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.positionToResize = CellEdgeDetectUtil.getPositionToResize(natTable, new LPoint(event.x, event.y), this.orientation);
        if (this.positionToResize >= 0L) {
            NatTableLayerDim layerDim = natTable.getDim(this.orientation);
            this.positionStart = SwtUtils.toSWT(layerDim.getPositionStart(this.positionToResize));
            this.positionSize = layerDim.getPositionSize(this.positionToResize);
            this.startPixel = SwtUtils.getPixel(event, this.orientation);
            natTable.addOverlayPainter(this.overlayPainter);
        }
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        NatTableLayerDim layerDim = natTable.getDim(this.orientation);
        int pixel = SwtUtils.getPixel(event, this.orientation);
        if ((long)pixel > layerDim.getSize()) {
            return;
        }
        if (pixel < this.positionStart + this.getMinPositionSize()) {
            this.currentPixel = this.positionStart + this.getMinPositionSize();
        } else {
            this.currentPixel = pixel;
            LRangeList positionsToRepaint = new LRangeList();
            PositionResizeDragMode.addPositions(this.currentPixel, layerDim, positionsToRepaint);
            if (this.lastPixel >= 0) {
                PositionResizeDragMode.addPositions(this.lastPixel, layerDim, positionsToRepaint);
            }
            for (LRange positions : positionsToRepaint) {
                layerDim.repaintPositions(positions);
            }
            this.lastPixel = this.currentPixel;
        }
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        NatTableLayerDim layerDim = natTable.getDim(this.orientation);
        natTable.removeOverlayPainter(this.overlayPainter);
        this.updatePositionSize(layerDim, SwtUtils.getPixel(event, this.orientation));
    }

    private void updatePositionSize(LayerDim layerDim, int pixel) {
        int dragSize = pixel - this.startPixel;
        int newSize = this.positionSize + dragSize;
        if (newSize < this.getMinPositionSize()) {
            newSize = this.getMinPositionSize();
        }
        layerDim.getLayer().doCommand(new DimPositionResizeCommand(layerDim, this.positionToResize, newSize));
    }

    private class ColumnResizeOverlayPainter
    implements OverlayPainter {
        private ColumnResizeOverlayPainter() {
        }

        @Override
        public void paintOverlay(GC gc, Layer layer) {
            Color originalBackgroundColor = gc.getBackground();
            gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
            gc.fillRectangle(PositionResizeDragMode.this.currentPixel - 1, 0, 2, SwtUtils.toSWT(layer.getHeight()));
            gc.setBackground(originalBackgroundColor);
        }
    }

    private class RowResizeOverlayPainter
    implements OverlayPainter {
        private RowResizeOverlayPainter() {
        }

        @Override
        public void paintOverlay(GC gc, Layer layer) {
            Color originalBackgroundColor = gc.getBackground();
            gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
            gc.fillRectangle(0, PositionResizeDragMode.this.currentPixel - 1, SwtUtils.toSWT(layer.getWidth()), 2);
            gc.setBackground(originalBackgroundColor);
        }
    }
}

