/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Arrays;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.AbstractImIntList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImIntArrayList
extends AbstractImIntList {
    private final int[] array;

    public ImIntArrayList(int[] array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(int element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    public int getAt(int index) {
        if (index < 0 || index >= this.array.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[index];
    }

    @Override
    public int indexOf(int element) {
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int element) {
        int i = this.array.length - 1;
        while (i >= 0) {
            if (this.array[i] == element) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public IntStream stream() {
        return StreamSupport.intStream(Spliterators.spliterator(this.array, 1040), false);
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public String getString() {
        return new String(this.array, 0, this.array.length);
    }

    public int hashCode() {
        int hashCode = 9;
        int i = 0;
        while (i < this.array.length) {
            hashCode = 31 * hashCode + this.array[i];
            ++i;
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntList) {
            IntList other = (IntList)obj;
            if (this.array.length != other.size()) {
                return false;
            }
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] != other.getAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return ArrayUtils.toString(this.array, 0, this.array.length);
    }
}

