/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ReshowCompletionsRunnable
implements Runnable,
Listener,
ICompletionListener {
    private final SourceEditor editor;
    private final ISourceViewer viewer;
    private final SourceUnit su;
    private final AbstractDocument document;
    private final long documentStamp;
    private final Point selection;
    private final Display display;
    private final ContentAssist assist;
    private boolean assistSelection;

    public ReshowCompletionsRunnable(SourceEditor editor, ContentAssist assist) {
        this.editor = editor;
        this.viewer = editor.getViewer();
        this.su = editor.getSourceUnit();
        this.document = (AbstractDocument)this.viewer.getDocument();
        this.documentStamp = this.document.getModificationStamp();
        this.selection = this.viewer.getSelectedRange();
        this.assist = assist;
        this.display = this.viewer.getTextWidget().getDisplay();
        this.display.addFilter(25, (Listener)this);
        this.display.addFilter(16, (Listener)this);
        this.assist.addCompletionListener(this);
    }

    protected void dispose() {
        if (this.display.isDisposed()) {
            return;
        }
        this.display.removeFilter(25, (Listener)this);
        this.display.removeFilter(16, (Listener)this);
        this.assist.removeCompletionListener(this);
    }

    private boolean isValid() {
        return UIAccess.isOkToUse((Control)this.viewer.getTextWidget()) && (this.viewer.getTextWidget().isFocusControl() || this.assist.hasProposalPopupFocus()) && this.editor.getViewer() == this.viewer && this.editor.getSourceUnit() == this.su && this.viewer.getDocument() == this.document && this.document.getModificationStamp() == this.documentStamp && this.viewer.getSelectedRange().equals((Object)this.selection);
    }

    protected void cancel() {
        this.dispose();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 16: {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ReshowCompletionsRunnable.this.isValid()) {
                            ReshowCompletionsRunnable.this.cancel();
                        }
                    }
                });
                break;
            }
            default: {
                this.cancel();
            }
        }
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.cancel();
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        if (!this.assistSelection) {
            return;
        }
        this.cancel();
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        if (!this.assistSelection) {
            this.assistSelection = true;
            return;
        }
        this.cancel();
    }

    protected boolean showCompletionsNow() {
        return true;
    }

    @Override
    public void run() {
        if (this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ReshowCompletionsRunnable.this.dispose();
                if (ReshowCompletionsRunnable.this.isValid() && ReshowCompletionsRunnable.this.showCompletionsNow()) {
                    ReshowCompletionsRunnable.this.assist.showPossibleCompletions(true, true);
                }
            }
        });
    }
}

