/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rtool;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.internal.r.ui.rtools.Messages;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RProjects;

public class RProjectVariableResolver
extends ResourceVariableResolver {
    public static final String R_PKG_ROOT_PATH_NAME = "r_pkg_root_path";
    public static final String R_PKG_NAME_NAME = "r_pkg_name";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        RProject rProject = this.getRProject(variable, argument);
        if (variable.getName().equals(R_PKG_ROOT_PATH_NAME)) {
            IPath path = rProject.getPkgRootPath();
            if (path == null) {
                path = rProject.getProject().getFullPath();
            }
            return path.toString();
        }
        if (variable.getName().equals(R_PKG_NAME_NAME)) {
            String name = rProject.getPkgName();
            if (name == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_InvalidProject_NoPkgName_message, (Object)variable.getName(), (Object)rProject.getProject().getName())));
            }
            return name;
        }
        throw new IllegalArgumentException(variable.toString());
    }

    protected RProject getRProject(IDynamicVariable variable, String argument) throws CoreException {
        RProject rProject;
        IProject project = (IProject)this.getResource(variable, (byte)3, argument);
        if (!project.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_InvalidProject_NotExists_message, (Object)variable.getName(), (Object)project.getName())));
        }
        if (!project.hasNature("org.eclipse.statet.r.resourceProjects.R") || (rProject = RProjects.getRProject((IProject)project)) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_InvalidProject_NotExists_message, (Object)variable.getName(), (Object)project.getName())));
        }
        return rProject;
    }
}

