/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics;

import java.util.List;
import org.eclipse.statet.internal.rj.eclient.graphics.CircleElement;
import org.eclipse.statet.internal.rj.eclient.graphics.ClipSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.ColorSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.FillSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.FontSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.GraphicInitialization;
import org.eclipse.statet.internal.rj.eclient.graphics.LineElement;
import org.eclipse.statet.internal.rj.eclient.graphics.LineSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.PolygonElement;
import org.eclipse.statet.internal.rj.eclient.graphics.PolylineElement;
import org.eclipse.statet.internal.rj.eclient.graphics.RectElement;
import org.eclipse.statet.internal.rj.eclient.graphics.TextElement;
import org.eclipse.statet.rj.eclient.graphics.ERGraphicInstruction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Transform;

public class OldGCRenderer {
    private float scale = 1.0f;
    private final LineAttributes lineAttributes = new LineAttributes(1.0f);
    private Color lineColor;
    private int lineAlpha;
    private Color fillColor;
    private int fillAlpha;
    private int xMax;
    private int yMax;

    public void clear(float scale) {
        this.scale = scale;
        this.lineColor = null;
        this.lineAlpha = 255;
        this.fillColor = null;
        this.fillAlpha = 255;
        this.lineAttributes.style = 1;
        this.lineAttributes.width = scale;
        this.xMax = 0;
        this.yMax = 0;
    }

    public void paint(GC gc, List<? extends ERGraphicInstruction> instructions) {
        Transform defaultTransform = null;
        Transform tempTransform = null;
        float scale = this.scale;
        int currentAlpha = -1;
        int lineAlpha = this.lineAlpha;
        int fillAlpha = this.fillAlpha;
        try {
            gc.setAdvanced(true);
            gc.setAntialias(1);
            gc.setTextAntialias(1);
            gc.setLineAttributes(this.lineAttributes);
            gc.setTransform(defaultTransform);
            gc.setAlpha(currentAlpha);
            if (this.lineColor != null) {
                gc.setForeground(this.lineColor);
            }
            if (this.fillColor != null) {
                gc.setBackground(this.fillColor);
            }
            int ixmax = this.xMax;
            int iymax = this.yMax;
            for (ERGraphicInstruction eRGraphicInstruction : instructions) {
                block1 : switch (eRGraphicInstruction.getInstructionType()) {
                    case 0: {
                        GraphicInitialization init = (GraphicInitialization)eRGraphicInstruction;
                        ixmax = (int)(init.width * (double)scale + 0.5);
                        iymax = (int)(init.height * (double)scale + 0.5);
                        gc.setBackground(gc.getDevice().getSystemColor(1));
                        gc.setForeground(gc.getDevice().getSystemColor(2));
                        gc.setAlpha(255);
                        gc.fillRectangle(0, 0, ixmax, iymax);
                        gc.setClipping(0, 0, ixmax, iymax);
                        break;
                    }
                    case 1: {
                        ERGraphicInstruction setting = (ClipSetting)eRGraphicInstruction;
                        int ix0 = (int)(setting.x0 * (double)scale + 0.5);
                        int iy0 = (int)(setting.y0 * (double)scale + 0.5);
                        gc.setClipping(ix0, iy0, (int)Math.min(setting.x1 * (double)scale + 0.5, (double)ixmax) - ix0, (int)Math.min(setting.y1 * (double)scale + 0.5, (double)iymax) - iy0);
                        break;
                    }
                    case 2: {
                        ERGraphicInstruction setting = (ColorSetting)eRGraphicInstruction;
                        lineAlpha = setting.getAlpha();
                        gc.setForeground(((ColorSetting)setting).swtColor);
                        break;
                    }
                    case 3: {
                        ERGraphicInstruction setting = (FillSetting)eRGraphicInstruction;
                        fillAlpha = setting.getAlpha();
                        gc.setBackground(((FillSetting)setting).swtColor);
                        break;
                    }
                    case 4: {
                        ERGraphicInstruction setting = (LineSetting)eRGraphicInstruction;
                        switch (((LineSetting)setting).type) {
                            case 0: {
                                this.lineAttributes.style = 1;
                                this.lineAttributes.width = ((LineSetting)setting).width * scale;
                                gc.setLineAttributes(this.lineAttributes);
                                break block1;
                            }
                            case -1: {
                                this.lineAttributes.style = 1;
                                this.lineAttributes.width = 0.0f;
                                gc.setLineAttributes(this.lineAttributes);
                                break block1;
                            }
                        }
                        int rPattern = ((LineSetting)setting).type;
                        int length = 0;
                        while (rPattern != 0) {
                            ++length;
                            rPattern >>>= 4;
                        }
                        int[] dashes = new int[length];
                        rPattern = ((LineSetting)setting).type;
                        int i = 0;
                        while (i < length) {
                            dashes[i] = rPattern & 0xF;
                            rPattern >>>= 4;
                            ++i;
                        }
                        gc.setLineDash(dashes);
                        gc.setLineWidth((int)((double)(((LineSetting)setting).width * scale) + 0.5));
                        break;
                    }
                    case 5: {
                        ERGraphicInstruction setting = (FontSetting)eRGraphicInstruction;
                        gc.setFont(((FontSetting)setting).swtFont);
                        break;
                    }
                    case 6: {
                        ERGraphicInstruction element = (LineElement)eRGraphicInstruction;
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawLine((int)(element.x0 * (double)scale + 0.5), (int)(element.y0 * (double)scale + 0.5), (int)(element.x1 * (double)scale + 0.5), (int)(element.y1 * (double)scale + 0.5));
                        break;
                    }
                    case 7: {
                        ERGraphicInstruction element = (RectElement)eRGraphicInstruction;
                        int ix0 = (int)(((RectElement)element).x0 * (double)scale + 0.5);
                        int iy0 = (int)(((RectElement)element).y0 * (double)scale + 0.5);
                        int iw = (int)(((RectElement)element).x1 * (double)scale + 0.5) - ix0;
                        int ih = (int)(((RectElement)element).y1 * (double)scale + 0.5) - iy0;
                        if (fillAlpha != 0) {
                            if (fillAlpha != currentAlpha) {
                                currentAlpha = fillAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.fillRectangle(ix0, iy0, iw, ih);
                        }
                        if (lineAlpha == 0) break;
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawRectangle(ix0, iy0, iw, ih);
                        break;
                    }
                    case 8: {
                        ERGraphicInstruction element = (PolylineElement)eRGraphicInstruction;
                        int n = ((PolylineElement)element).x.length;
                        int[] icoord = new int[n * 2];
                        int i = 0;
                        int j = 0;
                        while (j < n) {
                            icoord[i++] = (int)(((PolylineElement)element).x[j] * (double)scale + 0.5);
                            icoord[i++] = (int)(((PolylineElement)element).y[j] * (double)scale + 0.5);
                            ++j;
                        }
                        gc.drawPolyline(icoord);
                        break;
                    }
                    case 9: {
                        ERGraphicInstruction element = (PolygonElement)eRGraphicInstruction;
                        int n = ((PolygonElement)element).x.length;
                        int[] icoord = new int[n * 2];
                        int i = 0;
                        int j = 0;
                        while (j < n) {
                            icoord[i++] = (int)(((PolygonElement)element).x[j] * (double)scale + 0.5);
                            icoord[i++] = (int)(((PolygonElement)element).y[j] * (double)scale + 0.5);
                            ++j;
                        }
                        if (fillAlpha != 0) {
                            if (fillAlpha != currentAlpha) {
                                currentAlpha = fillAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.fillPolygon(icoord);
                        }
                        if (lineAlpha == 0) break;
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawPolygon(icoord);
                        break;
                    }
                    case 10: {
                        ERGraphicInstruction element = (CircleElement)eRGraphicInstruction;
                        int id = (int)(((CircleElement)element).r * (double)scale * 2.0 + 0.5);
                        int ix0 = (int)((((CircleElement)element).x - ((CircleElement)element).r) * (double)scale + 0.5);
                        int iy0 = (int)((((CircleElement)element).y - ((CircleElement)element).r) * (double)scale + 0.5);
                        if (fillAlpha != 0) {
                            if (fillAlpha != currentAlpha) {
                                currentAlpha = fillAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.fillOval(ix0, iy0, id, id);
                        }
                        if (lineAlpha == 0) break;
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawOval(ix0, iy0, id, id);
                        break;
                    }
                    case 11: {
                        ERGraphicInstruction element = (TextElement)eRGraphicInstruction;
                        double hShift = ((TextElement)element).horizontalAdjust != 0.0 ? ((TextElement)element).horizontalAdjust * (double)gc.textExtent((String)((TextElement)element).text, (int)7).x : 0.0;
                        if (((TextElement)element).rotateDegree != 0.0) {
                            if (tempTransform == null) {
                                tempTransform = new Transform(gc.getDevice());
                            }
                            tempTransform.identity();
                            tempTransform.translate((float)(((TextElement)element).x * (double)scale), (float)(((TextElement)element).y * (double)scale));
                            tempTransform.rotate((float)(-((TextElement)element).rotateDegree));
                            tempTransform.translate((float)(-hShift), (float)(-gc.getFontMetrics().getAscent()));
                            gc.setTransform(tempTransform);
                            if (lineAlpha != currentAlpha) {
                                currentAlpha = lineAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.drawText(((TextElement)element).text, 0, 0, 7);
                            gc.setTransform(defaultTransform);
                            break;
                        }
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawText(((TextElement)element).text, (int)((((TextElement)element).x - hShift) * (double)scale + 0.5), (int)(((TextElement)element).y * (double)scale + 0.5) - gc.getFontMetrics().getAscent(), 7);
                    }
                }
            }
            this.lineColor = gc.getForeground();
            this.lineAlpha = lineAlpha;
            this.fillColor = gc.getBackground();
            this.fillAlpha = fillAlpha;
            this.xMax = ixmax;
            this.yMax = iymax;
        }
        finally {
            if (tempTransform != null) {
                tempTransform.dispose();
            }
        }
    }
}

