/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.statet.jcommons.collections.IdentityList;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class WorkbenchUIUtils {
    private static final Map<String, IdentityList<UIElement>> registeredElements = new HashMap<String, IdentityList<UIElement>>();
    private static int currentElementRefreshLevel;
    private static final List<UIElement> currentUpdatedElements;
    private static @Nullable IHandler2 currentElementUpdater1;
    private static @Nullable IHandler2 currentElementUpdater2;

    static {
        currentUpdatedElements = new ArrayList<UIElement>();
    }

    public static @Nullable ISelection getCurrentSelection(@Nullable Object context) {
        if (context instanceof IEvaluationContext) {
            IEvaluationContext evaluationContext = (IEvaluationContext)context;
            Object o = evaluationContext.getVariable("activeMenuSelection");
            if (o instanceof ISelection) {
                return (ISelection)o;
            }
            o = evaluationContext.getVariable("activeSite");
            if (o instanceof IWorkbenchSite) {
                IWorkbenchSite site = (IWorkbenchSite)o;
                ISelectionProvider selectionProvider = site.getSelectionProvider();
                if (selectionProvider != null) {
                    return selectionProvider.getSelection();
                }
                return null;
            }
            o = evaluationContext.getVariable("selection");
            if (o instanceof ISelection) {
                return (ISelection)o;
            }
        }
        return null;
    }

    public static @Nullable IWorkbenchPart getActivePart(@Nullable Object context) {
        Object o;
        if (context instanceof IEvaluationContext && (o = ((IEvaluationContext)context).getVariable("activePart")) instanceof IWorkbenchPart) {
            return (IWorkbenchPart)o;
        }
        return null;
    }

    public static @Nullable Control getActiveFocusControl(@Nullable Object context) {
        Object o;
        if (context instanceof IEvaluationContext && (o = ((IEvaluationContext)context).getVariable("activeFocusControl")) instanceof Control) {
            return (Control)o;
        }
        return null;
    }

    public static @Nullable Shell getShell(@Nullable Object context) {
        Object o;
        if (context instanceof IEvaluationContext && (o = ((IEvaluationContext)context).getVariable("activeShell")) instanceof Shell) {
            return (Shell)o;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }

    public static IServiceLocator getServiceLocator(@Nullable Object context) {
        Object o;
        if (context instanceof IEvaluationContext && (o = ((IEvaluationContext)context).getVariable("activeSite")) instanceof IServiceLocator) {
            return (IServiceLocator)o;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static @Nullable KeySequence getBestKeyBinding(String commandId) {
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (bindingSvc == null) {
            return null;
        }
        TriggerSequence binding = bindingSvc.getBestActiveBindingFor(commandId);
        if (binding instanceof KeySequence) {
            return (KeySequence)binding;
        }
        TriggerSequence[] bindings = bindingSvc.getActiveBindingsFor(commandId);
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i] instanceof KeySequence) {
                return (KeySequence)bindings[i];
            }
            ++i;
        }
        return null;
    }

    public static void activateContext(IServiceLocator serviceLocator, String contextId) {
        IContextService contextService = (IContextService)serviceLocator.getService(IContextService.class);
        try {
            Context context;
            while ((context = contextService.getContext(contextId)) != null && context.isDefined()) {
                contextService.activateContext(contextId);
                contextId = context.getParentId();
                if (contextId != null && !contextId.equals("org.eclipse.ui.contexts.dialog") && !contextId.equals("org.eclipse.ui.contexts.dialogAndWindow") && !contextId.equals("org.eclipse.ui.contexts.window")) continue;
                break;
            }
        }
        catch (NotDefinedException notDefinedException) {
            // empty catch block
        }
    }

    public static void registerCommandElement(String commandId, UIElement element) {
        ImIdentityList elements = registeredElements.get(commandId);
        elements = elements == null ? ImCollections.newIdentityList((Object)element) : ImCollections.addElement((IdentityList)elements, (Object)element);
        registeredElements.put(commandId, (IdentityList<UIElement>)elements);
    }

    public static void unregisterCommandElement(String commandId, UIElement element) {
        ImIdentityList elements = registeredElements.get(commandId);
        if (elements == null) {
            return;
        }
        elements = ImCollections.removeLastElement(elements, (Object)element);
        registeredElements.put(commandId, (IdentityList<UIElement>)elements);
    }

    public static boolean isElementUpdated(UIElement element) {
        int l = currentUpdatedElements.size();
        int i = 0;
        while (i < l) {
            if (currentUpdatedElements.get(i) == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void refreshCommandElements(String commandId, @Nullable IHandler2 handler, @Nullable Map filter) {
        if (currentElementRefreshLevel >= 10) {
            return;
        }
        ++currentElementRefreshLevel;
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            if (commandId != null && commandService != null) {
                commandService.refreshElements(commandId, filter);
            }
            if (handler instanceof IElementUpdater) {
                IElementUpdater updater = (IElementUpdater)handler;
                List elements = (List)registeredElements.get(commandId);
                if (elements != null) {
                    for (UIElement element : elements) {
                        if (WorkbenchUIUtils.isElementUpdated(element)) continue;
                        try {
                            updater.updateElement(element, null);
                        }
                        catch (Exception e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "An error occurred when invoking elements updater.", (Throwable)e));
                        }
                    }
                }
            }
        }
        finally {
            if (--currentElementRefreshLevel == 0) {
                currentUpdatedElements.clear();
            }
        }
    }

    public static void aboutToUpdateCommandsElements(IHandler2 handler, UIElement element) {
        currentElementUpdater1 = handler;
        if (currentElementRefreshLevel > 0) {
            currentUpdatedElements.add(element);
        }
    }

    public static void aboutToUpdateCommandsElements(IHandler2 handler, IHandler2 scopeHandler, UIElement element) {
        currentElementUpdater1 = handler;
        currentElementUpdater2 = scopeHandler;
        if (currentElementRefreshLevel > 0) {
            currentUpdatedElements.add(element);
        }
    }

    public static void finalizeUpdateCommandsElements(IHandler2 handler) {
        currentElementUpdater1 = null;
        currentElementUpdater2 = null;
    }

    public static boolean isCommandElementsUpdater(@Nullable IHandler2 handler) {
        return handler == currentElementUpdater1 || handler == currentElementUpdater2;
    }

    private WorkbenchUIUtils() {
    }
}

