/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainer;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikidocReconciler;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.ModelManager;
import org.eclipse.statet.ltk.model.core.build.SourceUnitModelContainer;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementDelta;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelEventJob;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelManager;

@NonNullByDefault
public class WikitextModelManagerImpl
extends AbstractModelManager
implements ModelManager,
Disposable {
    private final EventJob eventJob = new EventJob(this);
    private final WikidocReconciler reconciler = new WikidocReconciler(this);

    public WikitextModelManagerImpl() {
        super("Wikidoc");
    }

    public void dispose() {
        this.eventJob.dispose();
    }

    public EventJob getEventJob() {
        return this.eventJob;
    }

    public void reconcile(SourceUnitModelContainer<?, ?> adapter, int level, IProgressMonitor monitor) {
        if (adapter instanceof WikidocSourceUnitModelContainer) {
            this.reconciler.reconcile((WikidocSourceUnitModelContainer)adapter, level, monitor);
        }
    }

    static class EventJob
    extends AbstractModelEventJob<WikitextSourceUnit, WikidocSourceUnitModelInfo> {
        public EventJob(WikitextModelManagerImpl manager) {
            super((AbstractModelManager)manager);
        }

        protected LtkModelElementDelta createDelta(AbstractModelEventJob.Task task) {
            return new ModelDelta(task.getElement(), task.getOldInfo(), task.getNewInfo());
        }

        protected void dispose() {
            super.dispose();
        }
    }

    private static class ModelDelta
    implements LtkModelElementDelta {
        private final int level;
        private final LtkModelElement element;
        private final @Nullable SourceUnitModelInfo oldInfo;
        private final @Nullable AstInfo oldAst;
        private final @Nullable SourceUnitModelInfo newInfo;
        private final @Nullable AstInfo newAst;

        public ModelDelta(LtkModelElement element, @Nullable SourceUnitModelInfo oldInfo, @Nullable SourceUnitModelInfo newInfo) {
            this.level = 2;
            this.element = element;
            this.oldInfo = oldInfo;
            this.oldAst = oldInfo != null ? oldInfo.getAst() : null;
            this.newInfo = newInfo;
            this.newAst = newInfo != null ? newInfo.getAst() : null;
        }

        public LtkModelElement getModelElement() {
            return this.element;
        }

        public @Nullable AstInfo getOldAst() {
            return this.oldAst;
        }

        public @Nullable AstInfo getNewAst() {
            return this.newAst;
        }
    }
}

